/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.controller;

import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.DeviceAddService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.utils.HostKeyCheckUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.rest.common.Constants;
import com.huawei.ism.tool.service.rest.common.DeviceObs;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.model.entity.vo.BatchAuthInfoVO;
import com.huawei.ism.tool.service.rest.model.entity.vo.ClusterNodeVO;
import com.huawei.ism.tool.service.rest.model.entity.vo.DevNodeVO;
import com.huawei.ism.tool.service.rest.model.entity.vo.SandboxCloseVO;
import com.huawei.ism.tool.service.rest.model.entity.vo.SandboxOperateInfo;
import com.huawei.ism.tool.service.rest.service.device.ClusterAuthServer;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import com.huawei.ism.tool.service.sanbox.ISandBoxService;
import com.huawei.ism.tool.service.sanbox.SandBoxService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class BaseDeviceController {
    private static final Logger log = LoggerFactory.getLogger(BaseDeviceController.class);
    protected final DeviceAddService service;
    protected final INodeSupport support;
    protected final INodeObserver nodeObserver;
    protected final ISandBoxService sandBoxService;

    public BaseDeviceController(INodeSupport support, INodeObserver nodeObserver) {
        this.support = support;
        this.nodeObserver = nodeObserver;
        DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)DeviceObs.INS);
        DefaultNodeProviderImpl.getInstance().addNodeObservers(nodeObserver);
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(Collections.singletonList(DeviceType.ALL), this.support, ShowSysConstans.getShowSysCmds());
        this.service = new DeviceAddService((INodeTypeQuery)nodeTypeQuery);
        this.sandBoxService = new SandBoxService();
        this.initDevice();
    }

    @PostMapping
    public Response<DevNodeVO> login(@RequestBody DevNode node) {
        TaskResult result = null;
        if (node.isDsStorage()) {
            result = DeviceQueryErrorParser.parseErrorInfo((TaskResult)this.service.addDeviceByRest(node, DeviceOpr.ADD));
        } else if (ItDeviceType.Storage.equals((Object)node.getItDeviceType())) {
            result = DeviceQueryErrorParser.parseErrorInfo((TaskResult)this.service.addDevice(node, DeviceOpr.ADD));
        } else if (ItDeviceType.OCEAN_CYBER.equals((Object)node.getItDeviceType())) {
            result = DeviceQueryErrorParser.parseErrorInfo((TaskResult)this.service.addCyberEngineDevice(node, DeviceOpr.ADD));
        } else {
            return Response.fail(Constants.Device.UN_SUPPORT_MSG);
        }
        String fingerPrint = ObjectUtils.isEmpty((Object)result) ? "" : result.getFingerPrint();
        return Response.buildResultFromTaskResult(result, new DevNodeVO(node, fingerPrint));
    }

    @GetMapping
    public Response<List<? extends DevNodeVO>> queryAddedDevice() {
        List addedNodes = BusinessDeviceUtil.INS.filterDevNodeByINodeSupport(this.support).stream().map(DevNodeVO::new).collect(Collectors.toList());
        return Response.success(addedNodes);
    }

    @GetMapping(value={"/finger"})
    public Response<Map<String, String>> queryFingerMap() {
        Properties printProp = HostKeyCheckUtils.getFingerPrintProp();
        Set<String> hostIpSet = printProp.stringPropertyNames();
        HashMap hostKeyMap = new HashMap();
        hostIpSet.forEach(ip -> hostKeyMap.put(ip, printProp.getProperty((String)ip)));
        return Response.success(hostKeyMap);
    }

    @PostMapping(value={"/finger"})
    public Response<?> updateHostFinger(@RequestBody Map<String, String> hostKeyMap) {
        HostKeyCheckUtils.setFingerPrintProps(hostKeyMap);
        return Response.success();
    }

    @DeleteMapping(value={"/{sn}"})
    public Response<?> removeDevice(@PathVariable(value="sn") String sn) {
        try {
            DefaultNodeProviderImpl.getInstance().removeNode(sn);
            return Response.success("");
        }
        catch (ToolException e) {
            log.error("Remove dev error.", (Throwable)e);
            return Response.fail(Constants.Device.REMOVE_FAILED);
        }
    }

    @GetMapping(value={"/nodes/{sn}"})
    public Response<List<ClusterNodeVO>> queryClusterNodesInfo(@PathVariable(value="sn") String sn) {
        Optional<BusinessDevice> businessDeviceOpt = BusinessDeviceUtil.INS.findBusinessDev(sn);
        if (!businessDeviceOpt.isPresent()) {
            return Response.fail(Constants.Device.NODE_NOT_EXIST);
        }
        BusinessDevice businessDevice = businessDeviceOpt.get();
        List<AuthClusterNode> clusterNodes = businessDevice.getAuthClusterNodes();
        if (clusterNodes == null || clusterNodes.isEmpty()) {
            this.removeDevice(businessDevice.getDevNode().getDeviceSerialNumber());
            TaskResult taskResult = this.service.addDeviceByRest(businessDevice.getDevNode(), DeviceOpr.UPDATE);
            return Response.buildResultFromTaskResult(taskResult, ClusterNodeVO.getClusterNodes(BusinessDeviceUtil.INS.findBusinessDev(sn).orElseGet(BusinessDevice::new)));
        }
        return Response.success(ClusterNodeVO.getClusterNodes(businessDevice));
    }

    @PutMapping(value={"/nodes/bmcAuth"})
    public Response<String> authBmcInfo(@RequestBody BatchAuthInfoVO info) {
        if (ClusterAuthServer.INS.batchBmcAuth(info)) {
            return Response.success("");
        }
        return Response.fail(Constants.Device.UN_SUPPORT_MSG);
    }

    @PutMapping(value={"/nodes/osAuth"})
    public Response<String> authOsInfo(@RequestBody BatchAuthInfoVO info) {
        if (ClusterAuthServer.INS.batchOsAuth(info)) {
            return Response.success("");
        }
        return Response.fail(Constants.Device.UN_SUPPORT_MSG);
    }

    @PostMapping(value={"/nodes/sandbox/close"})
    public Response<String> closeSandBox(@RequestBody SandboxOperateInfo info) {
        BusinessDevice businessDevice = BusinessDeviceUtil.INS.findBusinessDev(info.getDeviceSn()).get();
        if (!this.sandBoxService.querySupportDisabledSandbox(businessDevice.getDevNode())) {
            return Response.fail(ResourceUtil.getString("sandbox.not.supported.disabled"));
        }
        List<String> successIps = this.sandBoxService.batchCloseSandBox(businessDevice.getDevNode(), info.getNodeIps(), info.getRootPassword());
        this.updateNodeSandboxStatus(businessDevice, successIps, SandboxStatus.CLOSE);
        Context.INS.recordSandboxClose(businessDevice.getDevNode(), successIps);
        List<String> errorIps = this.getErrorIps(successIps, info.getNodeIps());
        return CollectionUtil.isEmpty(errorIps) ? Response.success(ResourceUtil.getString("sandbox.disabled.success")) : Response.fail(ResourceUtil.getString("sandbox.disabled.failed") + errorIps);
    }

    @PostMapping(value={"/nodes/sandbox/open"})
    public Response<String> autoOpenSandBox(@RequestBody SandboxOperateInfo info) {
        BusinessDevice businessDevice = BusinessDeviceUtil.INS.findBusinessDev(info.getDeviceSn()).get();
        List<String> successIps = this.sandBoxService.batchOpenSandBox(businessDevice.getDevNode(), info.getNodeIps());
        this.updateNodeSandboxStatus(businessDevice, successIps, SandboxStatus.OPEN);
        Context.INS.recordSandboxOpen(businessDevice.getDevNode(), successIps);
        List<String> errorIps = this.getErrorIps(successIps, info.getNodeIps());
        return CollectionUtil.isEmpty(errorIps) ? Response.success(ResourceUtil.getString("sandbox.enabled.success")) : Response.fail(ResourceUtil.getString("sandbox.enabled.failed") + errorIps);
    }

    @GetMapping(value={"/nodes/sandbox/needrestore"})
    public Response<List<SandboxCloseVO>> needRestoreSandbox() {
        Map<DevNode, List<String>> sandboxCloseMap = Context.INS.getSandboxClosedMap();
        List sandboxCloseVOS = sandboxCloseMap.keySet().stream().filter(node -> !((List)sandboxCloseMap.get(node)).isEmpty()).map(node -> new SandboxCloseVO((DevNode)node, (List)sandboxCloseMap.get(node))).collect(Collectors.toList());
        return Response.success(sandboxCloseVOS);
    }

    private List<String> getErrorIps(List<String> successIps, List<String> inputIps) {
        return inputIps.stream().filter(ip -> !successIps.contains(ip)).collect(Collectors.toList());
    }

    private void updateNodeSandboxStatus(BusinessDevice businessDevice, List<String> nodeIps, SandboxStatus status) {
        businessDevice.getAuthClusterNodes().stream().map(AuthClusterNode::getNode).filter(clusterNode -> nodeIps.contains(clusterNode.getManagementIp())).forEach(clusterNode -> clusterNode.setSandboxStatus(status));
    }

    private void fireNodeAdd(INodeObserver observer, DevNode node) {
        try {
            observer.fireNodeAdd(node);
        }
        catch (ToolException e) {
            log.error("Add dev failed", (Throwable)e);
        }
    }

    private void initDevice() {
        BusinessDeviceUtil.INS.filterDevNodeByINodeSupport(this.support).stream().peek(dev -> this.fireNodeAdd(DeviceObs.INS, (DevNode)dev)).forEach(dev -> this.fireNodeAdd(this.nodeObserver, (DevNode)dev));
    }
}

