/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model;

import com.huawei.ism.tool.service.rest.model.CheckedFunction;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Either<L, R> {
    private static final Logger log = LoggerFactory.getLogger(Either.class);
    private final L left;
    private final R right;

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    private static <L, R> Either left(L value) {
        return new Either<L, Object>(value, null);
    }

    private static <L, R> Either right(R value) {
        return new Either<Object, R>(null, value);
    }

    public Optional<L> getLeft() {
        return Optional.ofNullable(this.left);
    }

    public Optional<R> getRight() {
        return Optional.ofNullable(this.right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public <T> Optional<T> mapLeft(Function<? super L, T> mapper) {
        if (this.isLeft()) {
            return Optional.of(mapper.apply(this.left));
        }
        return Optional.empty();
    }

    public <T> Optional<T> mapRight(Function<? super R, T> mapper) {
        if (this.isRight()) {
            return Optional.of(mapper.apply(this.right));
        }
        return Optional.empty();
    }

    public static <T, R> Function<T, Either> lift(CheckedFunction<T, R> function) {
        return functionArg -> {
            try {
                return Either.right(function.apply(functionArg));
            }
            catch (Exception ex) {
                log.error("Execute function error.", (Throwable)ex);
                return Either.left(ex);
            }
        };
    }

    public static <T, R> Function<T, Either> liftWithValue(CheckedFunction<T, R> function) {
        return functionArg -> {
            try {
                return Either.right(function.apply(functionArg));
            }
            catch (Exception ex) {
                log.error("Execute function error.", (Throwable)ex);
                return Either.left(Pair.of((Object)ex, (Object)functionArg));
            }
        };
    }

    public String toString() {
        if (this.isLeft()) {
            return "left(" + this.left + ")";
        }
        return "right(" + this.right + ")";
    }
}

