/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model.entity;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthClusterNode {
    private static final Logger log = LoggerFactory.getLogger(AuthClusterNode.class);
    private ClusterNode node;
    private User osUser;
    private User osRootUser;
    private User bmcUser;
    private int sshPort;
    private int redfishPort;
    private volatile AuthStatusInfo osAuthStatusInfo = new AuthStatusInfo("", Status.WAITING);
    private volatile AuthStatusInfo bmcAuthStatusInfo = new AuthStatusInfo("", Status.WAITING);
    private boolean isMinisystem;

    public AuthClusterNode(ClusterNode clusterNode) {
        this.node = clusterNode;
    }

    public void initOsAuth() {
        this.osAuthStatusInfo = new AuthStatusInfo("", Status.WAITING);
    }

    public void initBmcAuth() {
        this.bmcAuthStatusInfo = new AuthStatusInfo("", Status.WAITING);
    }

    public void updateOsAuthStatus(Status status, String description) {
        this.osAuthStatusInfo = new AuthStatusInfo(description, status);
    }

    public void updateBmcAuthStatus(Status status, String description) {
        this.bmcAuthStatusInfo = new AuthStatusInfo(description, status);
    }

    public ClusterNode getNode() {
        return this.node;
    }

    public User getOsUser() {
        return this.osUser;
    }

    public User getOsRootUser() {
        return this.osRootUser;
    }

    public User getBmcUser() {
        return this.bmcUser;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public int getRedfishPort() {
        return this.redfishPort;
    }

    public AuthStatusInfo getOsAuthStatusInfo() {
        return this.osAuthStatusInfo;
    }

    public AuthStatusInfo getBmcAuthStatusInfo() {
        return this.bmcAuthStatusInfo;
    }

    public boolean isMinisystem() {
        return this.isMinisystem;
    }

    public void setNode(ClusterNode node) {
        this.node = node;
    }

    public void setOsUser(User osUser) {
        this.osUser = osUser;
    }

    public void setOsRootUser(User osRootUser) {
        this.osRootUser = osRootUser;
    }

    public void setBmcUser(User bmcUser) {
        this.bmcUser = bmcUser;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public void setRedfishPort(int redfishPort) {
        this.redfishPort = redfishPort;
    }

    public void setOsAuthStatusInfo(AuthStatusInfo osAuthStatusInfo) {
        this.osAuthStatusInfo = osAuthStatusInfo;
    }

    public void setBmcAuthStatusInfo(AuthStatusInfo bmcAuthStatusInfo) {
        this.bmcAuthStatusInfo = bmcAuthStatusInfo;
    }

    public void setMinisystem(boolean isMinisystem) {
        this.isMinisystem = isMinisystem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthClusterNode)) {
            return false;
        }
        AuthClusterNode other = (AuthClusterNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSshPort() != other.getSshPort()) {
            return false;
        }
        if (this.getRedfishPort() != other.getRedfishPort()) {
            return false;
        }
        if (this.isMinisystem() != other.isMinisystem()) {
            return false;
        }
        ClusterNode this$node = this.getNode();
        ClusterNode other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        User this$osUser = this.getOsUser();
        User other$osUser = other.getOsUser();
        if (this$osUser == null ? other$osUser != null : !this$osUser.equals(other$osUser)) {
            return false;
        }
        User this$osRootUser = this.getOsRootUser();
        User other$osRootUser = other.getOsRootUser();
        if (this$osRootUser == null ? other$osRootUser != null : !this$osRootUser.equals(other$osRootUser)) {
            return false;
        }
        User this$bmcUser = this.getBmcUser();
        User other$bmcUser = other.getBmcUser();
        if (this$bmcUser == null ? other$bmcUser != null : !this$bmcUser.equals(other$bmcUser)) {
            return false;
        }
        AuthStatusInfo this$osAuthStatusInfo = this.getOsAuthStatusInfo();
        AuthStatusInfo other$osAuthStatusInfo = other.getOsAuthStatusInfo();
        if (this$osAuthStatusInfo == null ? other$osAuthStatusInfo != null : !((Object)this$osAuthStatusInfo).equals(other$osAuthStatusInfo)) {
            return false;
        }
        AuthStatusInfo this$bmcAuthStatusInfo = this.getBmcAuthStatusInfo();
        AuthStatusInfo other$bmcAuthStatusInfo = other.getBmcAuthStatusInfo();
        return !(this$bmcAuthStatusInfo == null ? other$bmcAuthStatusInfo != null : !((Object)this$bmcAuthStatusInfo).equals(other$bmcAuthStatusInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthClusterNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSshPort();
        result = result * 59 + this.getRedfishPort();
        result = result * 59 + (this.isMinisystem() ? 79 : 97);
        ClusterNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        User $osUser = this.getOsUser();
        result = result * 59 + ($osUser == null ? 43 : $osUser.hashCode());
        User $osRootUser = this.getOsRootUser();
        result = result * 59 + ($osRootUser == null ? 43 : $osRootUser.hashCode());
        User $bmcUser = this.getBmcUser();
        result = result * 59 + ($bmcUser == null ? 43 : $bmcUser.hashCode());
        AuthStatusInfo $osAuthStatusInfo = this.getOsAuthStatusInfo();
        result = result * 59 + ($osAuthStatusInfo == null ? 43 : ((Object)$osAuthStatusInfo).hashCode());
        AuthStatusInfo $bmcAuthStatusInfo = this.getBmcAuthStatusInfo();
        result = result * 59 + ($bmcAuthStatusInfo == null ? 43 : ((Object)$bmcAuthStatusInfo).hashCode());
        return result;
    }

    public String toString() {
        return "AuthClusterNode(node=" + this.getNode() + ", osUser=" + this.getOsUser() + ", osRootUser=" + this.getOsRootUser() + ", bmcUser=" + this.getBmcUser() + ", sshPort=" + this.getSshPort() + ", redfishPort=" + this.getRedfishPort() + ", osAuthStatusInfo=" + this.getOsAuthStatusInfo() + ", bmcAuthStatusInfo=" + this.getBmcAuthStatusInfo() + ", isMinisystem=" + this.isMinisystem() + ")";
    }

    public static class AuthStatusInfo {
        String description = "";
        Status authStatus;

        public boolean isAuthSuccess() {
            return this.authStatus == Status.SUCCESS;
        }

        public String getDescription() {
            return this.description;
        }

        public Status getAuthStatus() {
            return this.authStatus;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setAuthStatus(Status authStatus) {
            this.authStatus = authStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthStatusInfo)) {
                return false;
            }
            AuthStatusInfo other = (AuthStatusInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Status this$authStatus = this.getAuthStatus();
            Status other$authStatus = other.getAuthStatus();
            return !(this$authStatus == null ? other$authStatus != null : !((Object)((Object)this$authStatus)).equals((Object)other$authStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthStatusInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Status $authStatus = this.getAuthStatus();
            result = result * 59 + ($authStatus == null ? 43 : ((Object)((Object)$authStatus)).hashCode());
            return result;
        }

        public String toString() {
            return "AuthClusterNode.AuthStatusInfo(description=" + this.getDescription() + ", authStatus=" + (Object)((Object)this.getAuthStatus()) + ")";
        }

        public AuthStatusInfo(String description, Status authStatus) {
            this.description = description;
            this.authStatus = authStatus;
        }
    }
}

