/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.query;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.rest.model.entity.TaskLanguage;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryTaskUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryTaskUtils.class);
    private static final String QUERY_TASK_URL = "/dsware/service/task/queryTaskInfo";
    private static final int DEFAULT_TIME_OUT_SEC = 600;

    public static boolean queryTaskProcessByName(DevNode devNode, TaskLanguage targetName) throws ToolException {
        return QueryTaskUtils.queryTaskProcessByName(devNode, targetName, 600);
    }

    public static boolean queryTaskProcessByName(DevNode devNode, TaskLanguage targetName, int timeOutSecs) throws ToolException {
        RestConnection restConn = RestConnectionManager.getRestConnection((DevNode)devNode);
        String cmd = RestUtil.getDstorageUrlHead((DevNode)devNode) + QUERY_TASK_URL;
        String taskId = QueryTaskUtils.getTaskIdByTaskName(restConn, targetName, cmd);
        return QueryTaskUtils.queryTaskProcess(restConn, taskId, cmd, timeOutSecs);
    }

    public static boolean queryTaskProcessById(DevNode devNode, String taskId, int timeOutSecs) throws ToolException {
        RestConnection restConn = RestConnectionManager.getRestConnection((DevNode)devNode);
        String cmd = RestUtil.getDstorageUrlHead((DevNode)devNode) + QUERY_TASK_URL;
        return QueryTaskUtils.queryTaskProcess(restConn, taskId, cmd, timeOutSecs);
    }

    private static boolean queryTaskProcess(RestConnection restConn, String taskId, String cmd, int timeOutSecs) throws ToolException {
        if (StringUtils.isNULLStr(taskId)) {
            throw new ToolException(ResourceUtil.getStringWithParams("find.task.error", taskId));
        }
        log.info("Query task id: {}", (Object)taskId);
        long startTime = System.currentTimeMillis();
        long timeOut = TimeUnit.SECONDS.toMillis(timeOutSecs);
        while (System.currentTimeMillis() - startTime < timeOut) {
            String status = QueryTaskUtils.getTaskStatusByTaskId(restConn, taskId, cmd);
            if (StringUtils.isNULLStr(status)) {
                throw new ToolException(ResourceUtil.getStringWithParams("find.task.error", taskId));
            }
            if (Status.WAITING.toString().equalsIgnoreCase(status)) {
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("An exception occurred when querying the task, task id: {}.", (Object)taskId);
                    throw new ToolException("unknown.exception.occurred");
                }
            }
            if (Status.FAILED.toString().equalsIgnoreCase(status)) {
                return false;
            }
            if (!Status.SUCCESS.toString().equalsIgnoreCase(status)) continue;
            return true;
        }
        throw new ToolException("query.task.time.out");
    }

    private static String getTaskStatusByTaskId(RestConnection connection, String taskId, String cmd) throws ToolException {
        ResponseInfo response = QueryTaskUtils.getResponse(connection, cmd);
        if (!response.isSuccess()) {
            return "";
        }
        JSONArray taskInfos = QueryTaskUtils.getTaskInfos(response);
        return IntStream.range(0, taskInfos.length()).mapToObj(arg_0 -> ((JSONArray)taskInfos).getJSONObject(arg_0)).filter(taskInfo -> taskId.equals(taskInfo.get("taskId").toString())).map(taskInfo -> taskInfo.get("taskStatus").toString()).findFirst().orElse("");
    }

    private static String getTaskIdByTaskName(RestConnection restConn, TaskLanguage targetName, String cmd) throws ToolException {
        ResponseInfo response = QueryTaskUtils.getResponse(restConn, cmd);
        if (!response.isSuccess()) {
            return "";
        }
        JSONArray taskInfos = QueryTaskUtils.getTaskInfos(response);
        return IntStream.range(0, taskInfos.length()).mapToObj(arg_0 -> ((JSONArray)taskInfos).getJSONObject(arg_0)).filter(taskInfo -> QueryTaskUtils.isTargetTask(targetName, taskInfo)).map(taskInfo -> taskInfo.get("taskId").toString()).findFirst().orElse("");
    }

    private static JSONArray getTaskInfos(ResponseInfo response) {
        return new JSONObject(response.getContent()).getJSONArray("taskInfo");
    }

    private static boolean isTargetTask(TaskLanguage targetName, JSONObject jsonObject) {
        String taskName = jsonObject.get("taskName").toString();
        return targetName.getEn().equals(taskName) || targetName.getZh().equals(taskName);
    }

    private static ResponseInfo getResponse(RestConnection restConn, String cmd) throws ToolException {
        try {
            return restConn.execGet(cmd);
        }
        catch (ToolException e) {
            log.error("Failed to execute the command {}.", (Object)cmd, (Object)e);
            throw new ToolException("http.connection.error.tool.exception");
        }
    }

    private QueryTaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

