/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.service.device;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.uMate.common.rest.RedfishConnestion;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedfishConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(RedfishConnectionManager.class);
    public static final RedfishConnectionManager INS = new RedfishConnectionManager();
    private final Map<String, RedfishConnestion> CONN_POOL = new ConcurrentHashMap<String, RedfishConnestion>();

    public synchronized RedfishConnestion getRedFishConnection(DevNode node) throws ToolException {
        String key = this.getKey(node);
        if (this.containsConnCache(node)) {
            RedfishConnestion connection = this.CONN_POOL.get(key);
            return connection;
        }
        RedfishConnestion connection = this.getConnection(node);
        this.connectionCheck(connection);
        this.CONN_POOL.put(key, connection);
        return connection;
    }

    private void connectionCheck(RedfishConnestion connection) throws ToolException {
        if (!connection.connect(true)) {
            log.error("Build redfish conn failed.");
            throw new ToolException("device.cluster.auth.failed", new Object[]{connection.getDestIp()});
        }
    }

    RedfishConnestion getConnection(DevNode node) {
        return new RedfishConnestion(node.getIp(), String.valueOf(node.getPort()), node.getLoginUser().getUserName(), node.getLoginUser().getPassword());
    }

    public void releaseConn(DevNode node) {
        RedfishConnestion connection = this.CONN_POOL.remove(this.getKey(node));
        if (connection != null) {
            log.info("Release {} node's redfish conn.", (Object)node.getIp());
            connection.release();
        }
    }

    public boolean containsConnCache(DevNode devNode) {
        return this.CONN_POOL.containsKey(this.getKey(devNode));
    }

    public String getKey(DevNode node) {
        return node.getDeviceSerialNumber() + "_" + node.getIp();
    }
}

