/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.util;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.service.rest.common.DeviceObs;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessDeviceUtil {
    private static final Logger log = LoggerFactory.getLogger(BusinessDeviceUtil.class);
    public static final BusinessDeviceUtil INS = new BusinessDeviceUtil();
    private final DeviceObs deviceObs = DeviceObs.INS;

    public Optional<BusinessDevice> findBusinessDev(String sn) {
        return Optional.ofNullable(this.deviceObs.getSn2BusinessDevMap().get(sn));
    }

    public List<DevNode> filterDevNodeByINodeSupport(INodeSupport support) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> support.isNodeSupport(EntityUtils.toNewDev(node))).collect(Collectors.toList());
    }

    public Optional<AuthClusterNode> findClusterNodeByIp(String deviceSn, String ip) {
        Optional<BusinessDevice> device = this.findBusinessDev(deviceSn);
        if (!device.isPresent()) {
            log.warn("Can not find device {} ", (Object)deviceSn);
            return Optional.empty();
        }
        return device.get().findTargetClusterNodeByIp(ip);
    }

    public DevNode buildBmcNode(AuthClusterNode node) {
        DevNode devNode = new DevNode();
        devNode.setIp(node.getNode().getBmcIp());
        devNode.setProductModel(node.getNode().getModel());
        devNode.setLoginUser(node.getBmcUser());
        devNode.setPort(node.getRedfishPort());
        devNode.setDeviceSerialNumber(node.getNode().getSerialNumber());
        return devNode;
    }

    public DevNode buildDswareNode(BusinessDevice businessDevice) {
        AuthClusterNode fsmAuthClusterNode = businessDevice.getAuthClusterNodes().stream().filter(authClusterNode -> authClusterNode.getNode().getRoles().contains("management")).findFirst().get();
        DevNode fsmNode = this.buildOsNode(fsmAuthClusterNode);
        fsmNode.setDeviceSerialNumber(fsmNode.getDeviceSerialNumber() + "dsware");
        return fsmNode;
    }

    public DevNode buildOsNode(AuthClusterNode node) {
        DevNode devNode = new DevNode();
        devNode.setDeviceSerialNumber(node.getNode().getSerialNumber());
        devNode.setSshForwardList(node.getNode().getSshForwardList());
        devNode.setIp(node.getNode().getManagementIp());
        devNode.setProductModel(node.getNode().getModel());
        devNode.setLoginUser(node.getOsUser());
        devNode.setRootUser(node.getOsRootUser());
        devNode.setPort(node.getSshPort());
        return devNode;
    }
}

