/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based;

import com.huawei.ism.tool.service.annotations.Readonly;
import com.huawei.ism.tool.service.annotations.Stateless;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.DefaultExtraData;
import com.huawei.ism.tool.service.task.state.based.DefaultTaskExecutor;
import com.huawei.ism.tool.service.task.state.based.TaskExecutor;
import com.huawei.ism.tool.service.task.state.based.TaskExecutorFactory;
import com.huawei.ism.tool.service.task.state.based.transition.TransitionPath;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class DefaultTaskExecutorFactory<S extends Enum<S>, E extends Enum<E>>
implements TaskExecutorFactory<S, E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskExecutorFactory.class);
    private final String name;
    private final Class<S> stateType;
    private final Class<E> eventType;
    private final S defaultInitialState;
    @Readonly
    private final Map<S, Action<S, E>> initialActions;
    @Readonly
    private final Map<S, Map<E, TransitionPath<S, E>>> transitions;

    @Override
    public TaskExecutor<S, E> build(String id) {
        DefaultTaskExecutor<S, E> executor = new DefaultTaskExecutor<S, E>(this.name + ":" + id, this.stateType, this.eventType, this.defaultInitialState, this.initialActions, this.transitions, new DefaultExtraData());
        log.info("build task executor: {}", (Object)executor.describe());
        return executor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.name + ", state type: " + this.stateType + ", event type: " + this.eventType + ", default initial state: " + this.defaultInitialState + ", other initial states: " + this.initialActions.keySet();
    }

    public DefaultTaskExecutorFactory(String name, Class<S> stateType, Class<E> eventType, S defaultInitialState, Map<S, Action<S, E>> initialActions, Map<S, Map<E, TransitionPath<S, E>>> transitions) {
        this.name = name;
        this.stateType = stateType;
        this.eventType = eventType;
        this.defaultInitialState = defaultInitialState;
        this.initialActions = initialActions;
        this.transitions = transitions;
    }

    @Override
    public String name() {
        return this.name;
    }
}

