/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based.construct;

import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.Condition;
import com.huawei.ism.tool.service.task.state.based.construct.DefaultTaskExecutorFactoryBuilder;
import com.huawei.ism.tool.service.task.state.based.construct.TaskExecutorFactoryBuilder;
import com.huawei.ism.tool.service.task.state.based.construct.TransitionErrPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TransitionStepHelper<S extends Enum<S>, E extends Enum<E>>
implements TaskExecutorFactoryBuilder.TransitionSourceStateStep<S, E>,
TaskExecutorFactoryBuilder.TransitionTargetStateStep<S, E>,
TaskExecutorFactoryBuilder.TransitionEventStep<S, E>,
TaskExecutorFactoryBuilder.TransitionConditionOrActionOrAndStep<S, E>,
TaskExecutorFactoryBuilder.TransitionActionOrAndStep<S, E>,
TaskExecutorFactoryBuilder.TransitionErrOrAndStep<S, E> {
    S source;
    S target;
    E event;
    @Nullable
    Condition<S, E> condition;
    @Nullable
    Action<S, E> action;
    @Nullable
    S errState;
    @Nullable
    E errEvent;
    @Nullable
    Condition<S, E> errCondition;
    @Nullable
    Action<S, E> errAction;
    TransitionErrPolicy errPolicy = TransitionErrPolicy.USE_DEFAULT_ERR_POLICY;
    final int id;
    private final DefaultTaskExecutorFactoryBuilder<S, E> factoryBuilder;

    @Override
    public TaskExecutorFactoryBuilder.TransitionTargetStateStep<S, E> from(@NotNull S source) {
        this.factoryBuilder.checkFieldNotSet(this.source, "source state");
        this.factoryBuilder.checkStateAvailable(source);
        this.source = source;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionEventStep<S, E> to(@NotNull S target) {
        this.factoryBuilder.checkFieldNotSet(this.target, "target state");
        this.factoryBuilder.checkStateAvailable(target);
        this.target = target;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionEventStep<S, E> toSelf() {
        return this.to(this.source);
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionConditionOrActionOrAndStep<S, E> by(@NotNull E event) {
        this.factoryBuilder.checkFieldNotSet(this.event, "event");
        this.factoryBuilder.checkEventAvailable(event);
        this.event = event;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionActionOrAndStep<S, E> when(Condition<S, E> condition) {
        this.factoryBuilder.checkFieldNotSet(this.condition, "condition");
        this.condition = condition;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionErrOrAndStep<S, E> exec(Action<S, E> action) {
        this.factoryBuilder.checkFieldNotSet(this.action, "action");
        this.action = action;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.ErrTransitionPolicyStep<S, E> ifErr() {
        return new ErrTransitionHelper();
    }

    @Override
    public TaskExecutorFactoryBuilder.NewTransitionOrDefaultErrOrBuildStep<S, E> and() {
        this.factoryBuilder.addTransition(this);
        return this.factoryBuilder;
    }

    public String toString() {
        return this.source + "==<" + this.event + (this.condition != null ? "|C" : "") + (this.action != null ? "|A" : "") + ">==>" + this.target + (this.errPolicy == TransitionErrPolicy.THROW_EXCEPTION ? "(T)" : (this.errPolicy == TransitionErrPolicy.RE_TRANSIT ? "==<" + this.errEvent + ">==>" + this.errState + (this.errCondition == null ? (this.errAction == null ? "" : "(EA)") : (this.action == null ? "(EC)" : "(EC|EA)")) : "")) + ":" + this.id;
    }

    public TransitionStepHelper(S source, S target, E event, @Nullable Condition<S, E> condition, @Nullable Action<S, E> action, @Nullable S errState, @Nullable E errEvent, @Nullable Condition<S, E> errCondition, @Nullable Action<S, E> errAction, TransitionErrPolicy errPolicy, int id, DefaultTaskExecutorFactoryBuilder<S, E> factoryBuilder) {
        this.source = source;
        this.target = target;
        this.event = event;
        this.condition = condition;
        this.action = action;
        this.errState = errState;
        this.errEvent = errEvent;
        this.errCondition = errCondition;
        this.errAction = errAction;
        this.errPolicy = errPolicy;
        this.id = id;
        this.factoryBuilder = factoryBuilder;
    }

    public TransitionStepHelper(int id, DefaultTaskExecutorFactoryBuilder<S, E> factoryBuilder) {
        this.id = id;
        this.factoryBuilder = factoryBuilder;
    }

    private class ErrTransitionHelper
    implements TaskExecutorFactoryBuilder.ErrTransitionPolicyStep<S, E>,
    TaskExecutorFactoryBuilder.ErrTransitionEventStep<S, E>,
    TaskExecutorFactoryBuilder.ErrTransitionConditionStep<S, E>,
    TaskExecutorFactoryBuilder.ErrTransitionConditionOrActionOrAndStep<S, E>,
    TaskExecutorFactoryBuilder.ErrTransitionActionOrAndStep<S, E> {
        private ErrTransitionHelper() {
        }

        @Override
        public TaskExecutorFactoryBuilder.ErrTransitionEventStep<S, E> transitTo(@NotNull S errState) {
            TransitionStepHelper.this.factoryBuilder.checkFieldNotSet(TransitionStepHelper.this.errState, "error state");
            TransitionStepHelper.this.factoryBuilder.checkStateAvailable(errState);
            TransitionStepHelper.this.errState = errState;
            TransitionStepHelper.this.errPolicy = TransitionErrPolicy.RE_TRANSIT;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.ErrTransitionConditionOrActionOrAndStep<S, E> by(@NotNull E errEvent) {
            TransitionStepHelper.this.factoryBuilder.checkFieldNotSet(TransitionStepHelper.this.errEvent, "error event");
            TransitionStepHelper.this.factoryBuilder.checkEventAvailable(errEvent);
            TransitionStepHelper.this.errEvent = errEvent;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.ErrTransitionActionOrAndStep<S, E> when(Condition<S, E> condition) {
            TransitionStepHelper.this.factoryBuilder.checkFieldNotSet(TransitionStepHelper.this.errCondition, "error condition");
            TransitionStepHelper.this.errCondition = condition;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.AndStep<S, E> exec(Action<S, E> action) {
            TransitionStepHelper.this.factoryBuilder.checkFieldNotSet(TransitionStepHelper.this.errAction, "error action");
            TransitionStepHelper.this.errAction = action;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.NewTransitionOrDefaultErrOrBuildStep<S, E> and() {
            return TransitionStepHelper.this.and();
        }

        @Override
        public TaskExecutorFactoryBuilder.AndStep<S, E> throwException() {
            TransitionStepHelper.this.factoryBuilder.checkFieldNotSet(TransitionStepHelper.this.errPolicy == TransitionErrPolicy.USE_DEFAULT_ERR_POLICY, "error policy");
            TransitionStepHelper.this.errPolicy = TransitionErrPolicy.THROW_EXCEPTION;
            TransitionStepHelper.this.factoryBuilder.addTransition(TransitionStepHelper.this);
            return TransitionStepHelper.this.factoryBuilder;
        }

        public String toString() {
            return TransitionStepHelper.this.toString();
        }
    }
}

