/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.https.conn;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.https.entity.HttpProxy;
import com.huawei.ism.tool.https.entity.HttpsConnection;
import com.huawei.ism.tool.https.utils.HttpsConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

public class HttpsConnManager {
    public static final String BOUNDARY = "boundary";
    public static final String CHARSET = "UTF-8";
    private static final String REST_POST = "POST";
    private static final String PROPERTY_KEY_CONNECTION = "Connection";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String PROPERTY_KEY_CHARSET = "Charset";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsConnManager.class);
    private static final HttpsConnManager INSTANCE = new HttpsConnManager();
    private static final String CONTENT_TYPE = "multipart/form-data";
    private static final int ONE_SECONDS = 1000;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int NUM_60 = 60;
    private static int readTimeout = 60000;

    private HttpsConnManager() {
    }

    public static HttpsConnManager getInstance() {
        return INSTANCE;
    }

    public HttpsConnection getHttpsConnByUrl(String url, HttpProxy httpProxy, SSLSocketFactory sslSocketFactory) {
        HttpsURLConnection connection;
        if (StringUtils.isNULLStr((String)url) || null == sslSocketFactory) {
            LOGGER.error("the url or sslSocketFactory is blank.");
            return null;
        }
        URL requestUrl = this.getRequestUrl(url);
        if (null == requestUrl) {
            LOGGER.info("request url is null");
            return new HttpsConnection(null, 1);
        }
        HttpsConnection conn = new HttpsConnection(connection, null == (connection = this.getHttpURLConnection(httpProxy, sslSocketFactory, requestUrl)) ? -1 : 0);
        return conn;
    }

    private HttpsURLConnection getHttpURLConnection(HttpProxy httpProxy, SSLSocketFactory sslSocketFactory, URL requestUrl) {
        HttpsURLConnection connection = null;
        try {
            Proxy proxy = this.getProxy(httpProxy);
            connection = (HttpsURLConnection)requestUrl.openConnection(proxy);
            connection.setSSLSocketFactory(sslSocketFactory);
            this.setReqParam(connection);
        }
        catch (IOException e) {
            LOGGER.error("getHttpsConnByUrl io exception.");
        }
        catch (Exception e) {
            LOGGER.error("getHttpsConnByUrl exception.", (Throwable)e);
        }
        return connection;
    }

    private URL getRequestUrl(String url) {
        URL requestUrl = null;
        try {
            requestUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.error("the url format is error.");
        }
        return requestUrl;
    }

    public Proxy getProxy(HttpProxy httpProxy) {
        if (null == httpProxy) {
            return Proxy.NO_PROXY;
        }
        Proxy proxy = Proxy.NO_PROXY;
        if (!StringUtils.isNULLStr((String)httpProxy.getHost()) && httpProxy.getPort() != 0) {
            Proxy.Type type = null;
            if (HttpProxy.ProxyType.SOCKS.equals((Object)httpProxy.getType())) {
                type = Proxy.Type.SOCKS;
            } else if (HttpProxy.ProxyType.HTTP.equals((Object)httpProxy.getType())) {
                type = Proxy.Type.HTTP;
            }
            if (null == type) {
                return proxy;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the proxy type:" + type.name());
            }
            proxy = new Proxy(type, new InetSocketAddress(httpProxy.getHost(), httpProxy.getPort()));
            if (!StringUtils.isNULLStr((String)httpProxy.getUserName())) {
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
                AuthCacheValue.setAuthCache((AuthCache)new AuthCacheImpl());
                Authenticator.setDefault(new BasicAuthenticator(httpProxy.getUserName(), httpProxy.getPassword()));
            }
        }
        return proxy;
    }

    private void setReqParam(HttpsURLConnection connection) throws ProtocolException {
        connection.setReadTimeout(readTimeout);
        connection.setConnectTimeout(5000);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(REST_POST);
        connection.setRequestProperty(PROPERTY_KEY_CONNECTION, KEEP_ALIVE);
        connection.setRequestProperty(PROPERTY_KEY_CHARSET, CHARSET);
        connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=boundary");
    }

    public boolean isHttpsResponseSuccess(HttpsURLConnection conn) {
        if (null == conn) {
            LOGGER.info("isHttpsResponseSuccess error , because conn is null");
            return false;
        }
        int resCode = 0;
        try {
            resCode = conn.getResponseCode();
            if (resCode == 200) {
                return true;
            }
            LOGGER.error("https error:" + resCode);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("isHttpsResponseSuccess error , because of io", (Throwable)e);
            return false;
        }
    }

    public String getHttpsResponseParams(HttpsURLConnection conn, String key) {
        if (null == conn) {
            LOGGER.info("https response params is null");
            return "";
        }
        int resCode = 0;
        try {
            resCode = conn.getResponseCode();
            if (resCode == 200) {
                String headerValue = conn.getHeaderField(key);
                if (StringUtils.isNULLStr((String)headerValue)) {
                    LOGGER.info("https response param header value is null");
                    return "";
                }
                return URLDecoder.decode(headerValue, "utf-8");
            }
            LOGGER.error("https error:" + resCode);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("handle https response error , because of unsupported encoding");
        }
        catch (IOException e) {
            LOGGER.error("handle https response error , because of io");
        }
        return "";
    }

    public void setHttpsRequestParams(HttpsURLConnection conn, Map<String, String> params) {
        if (params.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.initConnKeyAndValue(conn, key, value);
        }
    }

    private void initConnKeyAndValue(HttpsURLConnection conn, String key, String value) {
        if (StringUtils.isNULLStr((String)value)) {
            conn.setRequestProperty(key, "");
        } else {
            String valued = value;
            try {
                if (!StringUtils.isNULLStr((String)valued)) {
                    valued = URLEncoder.encode(valued, "utf-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                valued = value;
            }
            conn.setRequestProperty(key, valued);
        }
    }

    static {
        try {
            readTimeout = Integer.parseInt(HttpsConfig.get("httpurlconnection.socket.time.out")) * 1000;
        }
        catch (NumberFormatException e) {
            LOGGER.error("socket time out read error!");
        }
    }

    private static class BasicAuthenticator
    extends Authenticator {
        private String userName;
        private String paswd;

        public BasicAuthenticator(String userName, String paswd) {
            this.userName = userName;
            this.paswd = paswd;
            if (null == paswd) {
                this.paswd = "";
            }
        }

        @Override
        protected Authenticator.RequestorType getRequestorType() {
            return Authenticator.RequestorType.PROXY;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.paswd.toCharArray());
        }
    }
}

