/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.factory;

import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.factory.TLVConnectionSVPImpl;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubservice.exception.ConnectionException;
import com.huawei.ism.tool.framework.pubservice.exception.DeviceStatusException;
import com.huawei.ism.tool.framework.pubservice.exception.UserAuthExpection;
import com.huawei.ism.tool.framework.pubservice.exception.UserStatusExpection;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import com.huawei.json.JSONObject;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlvConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlvConnector.class);
    private static final String ERR_AUTHENTICATEFAIL = "1";
    private static final String ERR_CONNECTION = "2";
    private static final String ERR_USER_STATUS = "3";
    private static final String ERR_DEVICE_STATUS = "4";
    private static final String ERR_OTHER = "9";
    private DevNode devNode = null;
    private String svpIp = "";
    private String svpPort = "";
    private String svpSession = "";

    public TlvConnector(String ip, int port, String username, String password, Boolean isSSL) {
        this.setLoginInfo(ip, port, username, password, isSSL);
    }

    public TlvConnector(String svpIp, String svpPort, String svpSession, String deviceType, String sn) {
        DevNode deviceNode = new DevNode();
        deviceNode.setDeviceType(DeviceType.valueOf(deviceType));
        deviceNode.setDeviceSerialNumber(sn);
        this.svpIp = svpIp;
        this.svpPort = svpPort;
        this.svpSession = svpSession;
        this.devNode = deviceNode;
    }

    public TlvConnector(List<String> ipList, int port, String username, String password, Boolean isSSL) {
        this.setLoginInfo(ipList, port, username, password, isSSL);
    }

    public TlvConnector(String ip, int port, String username, String password, String sslVersion) {
        this.setLoginInfo(ip, port, username, password, (Boolean)true);
        if (null != this.devNode && !StringUtils.isNULLStr(sslVersion)) {
            this.devNode.setSslVersion(sslVersion);
        }
    }

    public TlvConnector(List<String> ipList, int port, String username, String password, String sslVersion) {
        this.setLoginInfo(ipList, port, username, password, (Boolean)true);
        if (null != this.devNode && !StringUtils.isNULLStr(sslVersion)) {
            this.devNode.setSslVersion(sslVersion);
        }
    }

    public TlvConnector(DevNode dev) {
        this.devNode = dev;
    }

    private void setLoginInfo(String ip, int port, String username, String password, Boolean isSSL) {
        DevNode deviceNode = new DevNode();
        User user = new User(username, password);
        deviceNode.setTlvPort(port);
        deviceNode.setLoginUser(user);
        deviceNode.setIp(ip);
        if (isSSL.booleanValue()) {
            deviceNode.setTlvSocketType("SSL");
        }
        this.devNode = deviceNode;
    }

    private void setLoginInfo(List<String> ipList, int port, String username, String password, Boolean isSSL) {
        LOGGER.info("ipList=", ipList);
        DevNode deviceNode = new DevNode();
        User user = new User(username, password);
        deviceNode.setTlvPort(port);
        deviceNode.setLoginUser(user);
        for (String ip : ipList) {
            deviceNode.addIp(ip);
        }
        deviceNode.setIpListAreInnerIp(true);
        if (isSSL.booleanValue()) {
            deviceNode.setTlvSocketType("SSL");
        }
        this.devNode = deviceNode;
    }

    public TLVConnection getConnection() throws ToolException {
        if (null == this.devNode) {
            return null;
        }
        IConnectionManage connMng = PublicServiceManage.getInstance().getService(IConnectionManage.class);
        TLVConnection conn = null;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("devNode device id = " + this.devNode.getDeviceSerialNumber());
            }
            conn = (TLVConnection)connMng.getTLVConnection(this.devNode);
            this.devNode.setDeviceSerialNumber(conn.getDeviceID());
        }
        catch (UserAuthExpection e) {
            LOGGER.error("Get TLV connection UserAuth failed", (Throwable)e);
            throw new ToolException(ERR_AUTHENTICATEFAIL, e.getMessage(), (Throwable)e);
        }
        catch (UserStatusExpection e) {
            LOGGER.error("Get TLV connection UserStatus failed", (Throwable)e);
            throw new ToolException(ERR_USER_STATUS, e.getMessage(), (Throwable)e);
        }
        catch (DeviceStatusException e) {
            LOGGER.error("Get TLV connection DeviceStatus failed", (Throwable)e);
            throw new ToolException(ERR_DEVICE_STATUS, e.getMessage(), (Throwable)e);
        }
        catch (ConnectionException e) {
            LOGGER.error("Get TLV connection failed", (Throwable)e);
            throw new ToolException(ERR_CONNECTION, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Get TLV connection otherException failed", (Throwable)e);
            String unKnownReason = ResourceUtil.getString("bizpackage.toolexception.unknown");
            throw new ToolException(ERR_OTHER, unKnownReason, (Throwable)e);
        }
        return conn;
    }

    public TLVConnection getConnectionSVP() throws ToolException {
        TLVConnectionSVPImpl connectionSVPImpl = new TLVConnectionSVPImpl();
        TLVConnection conn = null;
        try {
            conn = (TLVConnection)connectionSVPImpl.getTLVConnection(this.devNode, this.svpIp, this.svpPort, this.svpSession);
        }
        catch (UserAuthExpection e) {
            LOGGER.error("Get TLV connection UserAuth failed", (Throwable)e);
            throw new ToolException(ERR_AUTHENTICATEFAIL, e.getMessage(), (Throwable)e);
        }
        catch (DeviceStatusException e) {
            LOGGER.error("Get TLV connection DeviceStatus failed", (Throwable)e);
            throw new ToolException(ERR_DEVICE_STATUS, e.getMessage(), (Throwable)e);
        }
        catch (UserStatusExpection e) {
            LOGGER.error("Get TLV connection UserStatus failed", (Throwable)e);
            throw new ToolException(ERR_USER_STATUS, e.getMessage(), (Throwable)e);
        }
        catch (ConnectionException e) {
            LOGGER.error("Get TLV connection failed", (Throwable)e);
            throw new ToolException(ERR_CONNECTION, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Get TLV connection otherException failed", (Throwable)e);
            String unKnownReason = ResourceUtil.getString("bizpackage.toolexception.unknown");
            throw new ToolException(ERR_OTHER, unKnownReason, (Throwable)e);
        }
        return conn;
    }

    public String getLoginInfo() {
        if (null == this.devNode) {
            return null;
        }
        HashMap<String, String> loginMap = new HashMap<String, String>();
        String pwd = this.devNode.getLoginUser().getPassword();
        loginMap.put("ip", this.devNode.getIp());
        loginMap.put("tlvPort", String.valueOf(this.devNode.getTlvPort()));
        loginMap.put("user", this.devNode.getLoginUser().getUserName());
        loginMap.put("pawd", pwd);
        String tlvType = this.devNode.getTlvSocketType();
        if (tlvType.equals("SSL")) {
            loginMap.put("ssl", "true");
        } else {
            loginMap.put("ssl", "false");
        }
        JSONObject json = new JSONObject(loginMap);
        String ret = json.toString();
        return ret;
    }

    public TLVConnection getConnectionNoException() {
        if (null == this.devNode) {
            return null;
        }
        TLVConnection conn = null;
        IConnectionManage connMng = PublicServiceManage.getInstance().getService(IConnectionManage.class);
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("devNode device id = " + this.devNode.getDeviceSerialNumber());
            }
            conn = (TLVConnection)connMng.getTLVConnection(this.devNode);
            this.devNode.setDeviceSerialNumber(conn.getDeviceID());
        }
        catch (UserAuthExpection e) {
            LOGGER.error("Get TLV connection UserAuth failed", (Throwable)e);
            return null;
        }
        catch (UserStatusExpection e) {
            LOGGER.error("Get TLV connection UserStatus failed", (Throwable)e);
            return null;
        }
        catch (DeviceStatusException e) {
            LOGGER.error("Get TLV connection DeviceStatus failed", (Throwable)e);
            return null;
        }
        catch (ConnectionException e) {
            LOGGER.error("Get TLV connection failed", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Get TLV connection otherException failed", (Throwable)e);
            return null;
        }
        return conn;
    }

    public ITLVConnection getConnForwardNoException() {
        if (null == this.devNode) {
            return null;
        }
        try {
            LOGGER.info("Start to get tlv connection.");
            com.huawei.ism.tool.obase.entity.DevNode oldDev = EntityUtils.toOldDev((DevNode)this.devNode);
            ITLVConnection conn = TlvConnectionManager.getConnectionByInnerIp((com.huawei.ism.tool.obase.entity.DevNode)oldDev);
            return conn;
        }
        catch (UserAuthExpection e) {
            LOGGER.error("Get TLV connection UserAuth failed", (Throwable)e);
            return null;
        }
        catch (UserStatusExpection e) {
            LOGGER.error("Get TLV connection UserStatus failed", (Throwable)e);
            return null;
        }
        catch (DeviceStatusException e) {
            LOGGER.error("Get TLV connection DeviceStatus failed", (Throwable)e);
            return null;
        }
        catch (ConnectionException e) {
            LOGGER.error("Get TLV connection failed", (Throwable)e);
            return null;
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            LOGGER.error("Get TLV connection otherException failed", (Throwable)e);
            return null;
        }
    }
}

