/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileChooser {
    private static final String BUTTON_DESC = ResourceUtil.getString("bizpack.wizard.selectstep.button.desc");
    private JPanel fileChooserPanel = new JPanel();
    private String id = "";
    private String title = "";
    private String desc = "";
    private String labelDesc = "";
    private FileChooserType type;
    private JButton chooseFileButton;
    private JTextField textField;
    private String selectFileDefaultId = "";
    private int mincapacity = 0;

    private void initUi() {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.chooseFileButton = UiMethod.createButton((String)BUTTON_DESC, (char)'B');
        this.fileChooserPanel.setLayout(new BoxLayout(this.fileChooserPanel, 1));
        JLabel topDesc = new JLabel(util.getString(this.desc));
        JLabel descLabel = new JLabel(util.getString(this.labelDesc));
        this.textField = new JTextField();
        this.textField.setEditable(false);
        if (!this.desc.trim().equals("")) {
            this.fileChooserPanel.add(UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), topDesc}));
        }
        this.fileChooserPanel.add(Box.createVerticalStrut(12));
        this.fileChooserPanel.add(UiMethod.createHorizontalBox((Component[])new Component[]{descLabel, this.textField, this.chooseFileButton}));
        this.fileChooserPanel.add(Box.createVerticalStrut(12));
        this.selectFileDefaultId = "Select_file_" + this.id;
    }

    public JPanel getFileChooserBord() {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.fileChooserPanel.removeAll();
        this.initUi();
        this.fileChooserPanel.setBorder(BorderFactory.createTitledBorder(util.getString(this.title)));
        String userPath = FilePathUtils.filterPath(System.getProperty("user.home"));
        if (this.isValidPath(new File(userPath), this.mincapacity)) {
            this.textField.setText(userPath);
        }
        return this.fileChooserPanel;
    }

    private boolean isValidPath(File selectFile, int miniCapacity) {
        if (!selectFile.canWrite()) {
            return false;
        }
        if (miniCapacity == 0) {
            return true;
        }
        return this.checkDiskFreeSpace(selectFile, miniCapacity);
    }

    private boolean checkDiskFreeSpace(File file, int miniCapacity) {
        long capacity;
        long freeSpace = file.getFreeSpace();
        return freeSpace >= (capacity = (long)miniCapacity * 1024L * 1024L);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getLabelDesc() {
        return this.labelDesc;
    }

    public void setLabelDesc(String labelDesc) {
        this.labelDesc = labelDesc;
    }

    public FileChooserType getType() {
        return this.type;
    }

    public void setType(FileChooserType type) {
        this.type = type;
    }

    public JButton getChooseFileButton() {
        return this.chooseFileButton;
    }

    public void setChooseFileButton(JButton chooseFileButton) {
        this.chooseFileButton = chooseFileButton;
    }

    public String getSelectID() {
        return this.selectFileDefaultId;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setTextField(JTextField textField) {
        this.textField = textField;
    }

    public int getMincapacity() {
        return this.mincapacity;
    }

    public void setMincapacity(int mincapacity) {
        this.mincapacity = mincapacity;
    }

    public void setFileChooserDisable() {
        this.chooseFileButton.setEnabled(false);
        this.textField.setEditable(false);
    }

    public void fillTextFieldPath(String userPath) {
        if (this.isValidPath(new File(userPath), this.mincapacity)) {
            this.textField.setText(userPath);
        }
    }

    public static enum FileChooserType {
        DIR("dir"),
        FILE("file"),
        DIR_AND_FILE("dir_and_file");

        private String key = "";

        private FileChooserType(String type) {
            this.key = type;
        }

        public String toString() {
            return this.key;
        }
    }
}

