/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component.info;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoItem {
    private static final int GAP_SIZE = 50;
    private static final int EXTEND_WEIGHT = 44;
    private static final int LABEL_HEIGHT = 18;
    private String id = "";
    private boolean isHorizonLine = false;
    private JLabel label = new JLabel();
    private JLabel text = new JLabel();
    private BizStepConfig cfg;

    public InfoItem(BizStepConfig cfg) {
        this.cfg = cfg;
        AutomateUtils.setNameAttribute(this.label, "label");
        AutomateUtils.setNameAttribute(this.text, "text");
    }

    public JPanel getItemBord() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.label);
        panel.add(Box.createHorizontalStrut(6));
        panel.add(this.text);
        panel.add(Box.createHorizontalStrut(6));
        if (this.isHorizonLine) {
            this.setJLabelLen();
        }
        return panel;
    }

    private void setJLabelLen() {
        Dimension wizardSize = this.cfg.getWizardSize();
        if (wizardSize == null) {
            wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
        }
        int wi = wizardSize.width;
        if (this.cfg.isNeedDeviceGraph()) {
            wi -= this.cfg.getDevGraphSize().width + 50;
        }
        int panelWidth = (wi - 44) * 2 / 3;
        double w3 = this.label.getMinimumSize().getWidth();
        int textLen = (int)((double)panelWidth - w3 - 12.0 - 12.0);
        this.text.setPreferredSize(new Dimension(textLen, 18));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabelText(String labelTxt) {
        this.label.setText(labelTxt);
    }

    public JLabel getText() {
        return this.text;
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    public void setTextAndTips(String str, String tips) {
        this.text.setText(str);
        this.text.setToolTipText(tips);
    }

    public boolean isHorizon() {
        return this.isHorizonLine;
    }

    public void setHorizonLine(boolean isHorizon) {
        this.isHorizonLine = isHorizon;
    }
}

