/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.condition;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.ICondition;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;

public class StepCondition
implements ICondition {
    private static final String METHOD = "execute";
    private static final String PROCESS = "process";
    private String script = "";
    private String param = "";

    public boolean isMeet(String stepId) {
        if (!this.setScriptInfo(stepId)) {
            return true;
        }
        return this.execScript();
    }

    private boolean execScript() {
        JDialog parent = BizPackageContext.getInstance().getWizard();
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append(PROCESS);
        List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(scriptPath.toString(), this.script, METHOD, this.param)});
        WaitDialogResult result = (WaitDialogResult)fs.get(0);
        if (!WaitDialogResult.handleResult((Window)parent, result)) {
            return true;
        }
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        return (Boolean)ssEnv.getDict().get("succ");
    }

    private boolean setScriptInfo(String stepId) {
        BizStepConfig stepCfg = BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(stepId);
        if (null == stepCfg) {
            return false;
        }
        if (!stepCfg.getConditionCfg().isHasCondition()) {
            return false;
        }
        this.script = stepCfg.getConditionCfg().getScript();
        this.param = stepCfg.getConditionCfg().getParam();
        return true;
    }

    public boolean isForPrevious() {
        return true;
    }
}

