/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.ShowSupportDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.util.ListSortUtil;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

public class ShowSupportDialog
extends JDialog {
    private static final long serialVersionUID = -8800346513315757872L;
    private static final Dimension DIALOG_SIZE = new Dimension(450, 530);
    private ShowSupportDialogLayout layout = new ShowSupportDialogLayout();

    public ShowSupportDialog(JDialog parent) {
        super(parent);
        this.setResizable(false);
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
        this.setTitle(ResourceUtil.getString("bizpack.supportdialog.title"));
        this.add(this.layout);
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getConfirmeBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSupportDialog.this.confirmeAction();
            }
        });
    }

    private void setTable() {
        List<PackProduct> products = BizPackageContext.getInstance().getPackProducts();
        this.initTableData(products);
    }

    private TableRow<String, String> createTableRow(PackProduct packProduct) {
        String productName = packProduct.getProductName();
        List<String> versions = packProduct.getVersions();
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumns(), (Object)productName, (Object)productName);
        row.setValueAt(0, (Object)productName);
        StringBuffer supportVer = new StringBuffer();
        ListSortUtil.sortVersion(versions, "ASC");
        for (String ver : versions) {
            supportVer.append(",");
            supportVer.append(ver);
        }
        String supVerStr = supportVer.toString();
        if (!supVerStr.isEmpty()) {
            supVerStr = supVerStr.substring(",".length());
        }
        row.setValueAt(1, (Object)supVerStr);
        return row;
    }

    private void initTableData(List<PackProduct> products) {
        this.layout.getTableModel().removeAll();
        ListSortUtil.sortProductName(products, "ASC");
        for (PackProduct packProduct : products) {
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(packProduct)});
        }
    }

    private void confirmeAction() {
        this.dispose();
    }
}

