/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.connect;

import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.GuideFlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.intf.GetUserInputImpl;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.connect.ConnectionGuideStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.connect.ConnectionGuideStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionGuideStep
extends AbstractBizStep
implements IDevgGraphInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionGuideStep.class);
    private ConnectionGuideStepLayout conGuideLayout;
    private ConnectionGuideStepCfg cfg;
    private boolean manualCheckFlag = true;

    protected FlowWizardCardLayout getLayout() {
        return this.conGuideLayout;
    }

    protected boolean init() {
        this.setCurStepID();
        ConnectionGuideStepCfg conCfg = (ConnectionGuideStepCfg)BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId());
        this.initByConfig(conCfg);
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        this.conGuideLayout.getCheck().setSelected(false);
        if (this.cfg.isNeedAllCheck()) {
            List<JCheckBox> checks = this.conGuideLayout.getCheckBoxs();
            for (JCheckBox jCheckBox : checks) {
                jCheckBox.setSelected(false);
            }
        }
        if (this.conGuideLayout.getCheck().isSelected()) {
            this.chgWizState(true);
        } else {
            this.chgWizState(false);
        }
        if (this.cfg.isNeedDeviceGraph()) {
            this.paintDevGraph(this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IStep currentStep = BizPackageContext.getInstance().getCurrentStep();
                if (currentStep != null && currentStep instanceof ConnectionGuideStep) {
                    ((ConnectionGuideStep)currentStep).notifyObserver(AutoProcessStatus.DISPLAY);
                }
            }
        });
        return true;
    }

    public boolean ending() {
        return this.next();
    }

    public boolean flowExiting() {
        return this.cancel();
    }

    protected boolean next() {
        this.exeConfirm();
        if (this.cfg.isShowDialog()) {
            PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
            GetUserInputImpl wdialog = new GetUserInputImpl();
            return wdialog.showWarningDialog(resource.getString(this.cfg.getDialogMsg()));
        }
        return true;
    }

    private void exeConfirm() {
        String script = this.cfg.getScriptFile();
        if (!StringUtils.isNULLStr(script)) {
            if (!ExecPyUtils.execInitScript(script, "", "confirm")) {
                LOGGER.info("exec confirm failed.");
            } else {
                JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
                if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                    String errMsg = (String)ssEnv.getDict().get("errMsg");
                    LOGGER.error("init presetting step dropDown Text err." + errMsg);
                }
            }
        }
    }

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        if (stepConfig instanceof ConnectionGuideStepCfg) {
            this.cfg = (ConnectionGuideStepCfg)stepConfig;
            this.conGuideLayout = new ConnectionGuideStepLayout(this.cfg);
            this.conGuideLayout.getTitleDesc().setText(resource.getString(this.cfg.getPrompt()));
            if (!StringUtils.isNULLStr(this.cfg.getTailPrompt())) {
                this.conGuideLayout.getTailPromptPane().setText("<font face='\u5b8b\u4f53&&arial' size='3'>" + resource.getString(this.cfg.getTailPrompt()) + "</font>");
            }
            this.conGuideLayout.getCheck().setText(resource.getString(this.cfg.getPromise()));
            this.conGuideLayout.getCheck().setToolTipText(resource.getString(this.cfg.getPromise()));
            super.setBackwardAbs(this.cfg.isBackward());
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            super.setParamAbs(this.cfg.getParam());
            this.setDocLinkParentWindow(this.cfg);
            this.initListener(this.cfg);
        }
    }

    @Override
    public TaskResult initDevGraph() {
        if (!ExecPyUtils.execInitScript(this.cfg.getScriptFile(), this.getParamAbs(), "initDevGraph")) {
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            String errorMsg = ResourceUtil.getString("bizpackage.error.preset.execscriptfailed");
            result.setErrorLocaleDescription(errorMsg);
            return result;
        }
        return this.getDevGraphExecResult();
    }

    private void initListener(ConnectionGuideStepCfg conCfg) {
        this.conGuideLayout.getCheck().addItemListener(new CheckItemListener(conCfg));
        if (conCfg.isNeedAllCheck()) {
            List<JCheckBox> checks = this.conGuideLayout.getCheckBoxs();
            for (JCheckBox jCheckBox : checks) {
                jCheckBox.addItemListener(new CheckItemListener(conCfg));
            }
        }
    }

    private boolean excActionSubMaster() {
        boolean masterCheck = this.isMasterChecked();
        boolean subCheck = this.isAllSubChecked();
        if (!masterCheck && !subCheck) {
            this.manualCheckFlag = true;
            return false;
        }
        if (!masterCheck && subCheck) {
            return this.onlySubAction();
        }
        if (masterCheck && !subCheck) {
            return this.onlyMasterAction();
        }
        if (!this.manualCheckFlag) {
            this.setMasterCheck(false);
            this.setAllSubCheck(false);
            return false;
        }
        return true;
    }

    private boolean onlyMasterAction() {
        if (this.manualCheckFlag) {
            this.setAllSubCheck(true);
            this.manualCheckFlag = false;
            return true;
        }
        this.setMasterCheck(false);
        this.manualCheckFlag = true;
        return false;
    }

    private boolean onlySubAction() {
        if (this.manualCheckFlag) {
            this.setMasterCheck(true);
            this.manualCheckFlag = false;
            return true;
        }
        this.setAllSubCheck(false);
        this.manualCheckFlag = true;
        return false;
    }

    private boolean excActionMaster() {
        boolean masterCheck = this.isMasterChecked();
        if (!masterCheck) {
            if (!this.manualCheckFlag) {
                this.setAllSubCheck(false);
                this.manualCheckFlag = true;
            }
            return false;
        }
        if (this.manualCheckFlag) {
            this.setAllSubCheck(true);
            this.manualCheckFlag = true;
        }
        if (this.isAllSubChecked()) {
            this.manualCheckFlag = false;
            return true;
        }
        return false;
    }

    private boolean excActionSub() {
        boolean subCheck = this.isAllSubChecked();
        if (!subCheck) {
            if (!this.manualCheckFlag) {
                this.setMasterCheck(false);
                this.manualCheckFlag = true;
            }
            return false;
        }
        if (this.manualCheckFlag) {
            this.setMasterCheck(true);
            this.manualCheckFlag = false;
            if (this.isMasterChecked()) {
                return true;
            }
        }
        this.manualCheckFlag = true;
        return false;
    }

    private boolean excActionAll() {
        if (!this.conGuideLayout.getCheck().isSelected()) {
            return false;
        }
        List<JCheckBox> checks = this.conGuideLayout.getCheckBoxs();
        for (JCheckBox jCheckBox : checks) {
            if (jCheckBox.isSelected()) continue;
            return false;
        }
        return true;
    }

    private boolean isAllCheckedNew(ConnectionGuideStepCfg conCfg) {
        boolean subCheck = conCfg.isNeedSubCheck();
        boolean masterCheck = conCfg.isNeedMasterCheck();
        if (conCfg.isNeedAllCheck()) {
            if (subCheck && masterCheck) {
                return this.excActionSubMaster();
            }
            if (subCheck && !masterCheck) {
                return this.excActionSub();
            }
            if (!subCheck && masterCheck) {
                return this.excActionMaster();
            }
            return this.excActionAll();
        }
        return this.conGuideLayout.getCheck().isSelected();
    }

    private boolean isAllSubChecked() {
        List<JCheckBox> checks = this.conGuideLayout.getCheckBoxs();
        for (JCheckBox jCheckBox : checks) {
            if (jCheckBox.isSelected()) continue;
            return false;
        }
        return true;
    }

    private void setAllSubCheck(boolean state) {
        List<JCheckBox> checks = this.conGuideLayout.getCheckBoxs();
        for (JCheckBox jCheckBox : checks) {
            jCheckBox.setSelected(state);
        }
    }

    private boolean isMasterChecked() {
        return this.conGuideLayout.getCheck().isSelected();
    }

    private void setMasterCheck(boolean state) {
        this.conGuideLayout.getCheck().setSelected(state);
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        FlowWizardDialog wizardDialog;
        this.outputResult(status);
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(Navigation.NEXT);
        }
        if (BizPackageContext.getInstance().getWizard() instanceof GuideFlowWizardDialog) {
            wizardDialog = (GuideFlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(Navigation.NEXT);
        }
    }

    private void outputResult(AutoProcessStatus status) {
        String stepId = BizPackageContext.getInstance().getCurStepId();
        AutoProcessResult.getInstance().append(String.format(Locale.ROOT, "%s--------step: %s, result: %s", System.lineSeparator(), stepId, status.toString()));
    }

    private class CheckItemListener
    implements ItemListener {
        private ConnectionGuideStepCfg config = null;

        public CheckItemListener(ConnectionGuideStepCfg cfg) {
            this.setConfig(cfg);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ConnectionGuideStep.this.isAllCheckedNew(this.getConfig())) {
                ConnectionGuideStep.this.chgWizState(true);
            } else {
                ConnectionGuideStep.this.chgWizState(false);
            }
        }

        public void setConfig(ConnectionGuideStepCfg config) {
            this.config = config;
        }

        public ConnectionGuideStepCfg getConfig() {
            return this.config;
        }
    }
}

