/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.stop;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableData;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.TableDetailInfoDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.stop.StopHostIoStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.stop.StopHostIoStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.stop.comp.StopIoStatus;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopHostIoStep
extends AbstractBizStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopHostIoStep.class);
    private static final String PASSED_IMG = "success_old.gif";
    private static final String NOTPASSED_IMG = "failed_old.gif";
    private static final String LOADING_IMG = "loading.gif";
    private StopHostIoStepLayout layout;
    private StopHostIoStepCfg cfg;
    private ExecPyScriptTask ioStepTask;
    private String scriptPath;
    private TableItem table;
    private String pyName;
    private boolean isCheck = true;
    private boolean checkAllSucc = true;
    private boolean finish = true;
    private String lastColId = "";

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof StopHostIoStepCfg) {
            this.cfg = (StopHostIoStepCfg)stepConfig;
            this.layout = new StopHostIoStepLayout(this.cfg);
            this.scriptPath = this.getScriptPath();
            this.pyName = this.cfg.getScriptFile();
            this.table = this.cfg.getIoTable();
            super.setParamAbs(this.cfg.getParam());
            super.setBackwardAbs(this.cfg.isBackward());
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            this.layout.init(this.cfg);
            this.initListener();
            this.setDocLinkParentWindow(this.cfg);
        }
    }

    private void initListener() {
        this.layout.getCheckButton().addActionListener(new CheckBtnListener());
    }

    private void execOneCheck(final int curRowIndex) {
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StopHostIoStep.this.chgRowStatus(StopIoStatus.LOADING.getKey(), curRowIndex);
            }
        });
        TableRow row = (TableRow)this.table.getTableModel().getAllRows().get(curRowIndex);
        TableData oneRow = (TableData)row.getIdentifier();
        Map<String, String> id2Map = oneRow.getId2DataMap();
        JSONObject jsonData = new JSONObject(id2Map);
        this.getSsEnv().getDict().put("curData", jsonData.toString());
        this.ioStepTask.execFunc("checkByRow", this.getParamAbs());
        Object data = this.getSsEnv().getDict().get("retData");
        if (data == null) {
            LOGGER.error("get retData failed.  index=" + curRowIndex);
            this.chgRowStatus(StopIoStatus.WAITING.getKey(), curRowIndex);
            return;
        }
        String statusData = (String)data;
        JSONObject statusJson = new JSONObject(statusData);
        final String status = (String)statusJson.get(this.lastColId);
        if (status == null) {
            LOGGER.error("get retData status failed.  index=" + curRowIndex);
            this.chgRowStatus(StopIoStatus.WAITING.getKey(), curRowIndex);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StopHostIoStep.this.chgRowStatus(status, curRowIndex);
            }
        });
        if (!status.trim().equals(StopIoStatus.STOPPED.getKey())) {
            this.checkAllSucc = false;
        }
    }

    private void chgRowStatus(String value, int rowIndex) {
        int rowSize = this.table.getTableModel().getAllRows().size();
        int colSize = this.table.getTableModel().getAllColumnCount();
        if (rowIndex >= rowSize) {
            return;
        }
        TableRow row = (TableRow)this.table.getTableModel().getAllRows().get(rowIndex);
        this.setLastRowValue(row, colSize - 1, value);
        this.table.getIsmTable().updateUI();
    }

    private void initData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                Window parent = StopHostIoStep.this.getParentWindow();
                List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(StopHostIoStep.this.scriptPath, StopHostIoStep.this.pyName, "initData", StopHostIoStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(StopHostIoStep.this.getParentWindow(), result)) {
                    return;
                }
                StopHostIoStep.this.ioStepTask = result.getTask();
                if (null == StopHostIoStep.this.ioStepTask) {
                    DialogUtils.showErrorDialog((Window)StopHostIoStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                if (!((Boolean)StopHostIoStep.this.getSsEnv().getDict().get("succ")).booleanValue()) {
                    String errText = (String)StopHostIoStep.this.getSsEnv().getDict().get("errMsg");
                    DialogUtils.showErrorDialog((Window)StopHostIoStep.this.getParentWindow(), (String)errText);
                    return;
                }
                StopHostIoStep.this.initTableData();
            }
        });
    }

    private void reCheck() {
        this.backToWaitingTable();
        new StartCheckThread().start();
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    private void initTableData() {
        this.initFresh();
    }

    protected boolean init() {
        this.setCurStepID();
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        this.layout.init(this.cfg);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("table.getTableModel() =" + this.table.getTableModel().getAllRows().size());
        }
        this.isCheck = true;
        this.layout.getCheckButton().setText(ResourceUtil.getString("bizpack.wizard.stopiostep.check"));
        UCD.formatMnemonicDisplay((AbstractButton)this.layout.getCheckButton());
        super.setIndex(this.getStageIndex());
        this.initData();
        this.chgWizState(false);
        return true;
    }

    public boolean flowExiting() {
        if (!this.finish) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptrunning"));
            return false;
        }
        return this.cancel();
    }

    public boolean ending() {
        return true;
    }

    public void initFresh() {
        Map<String, Object> dict = BizPackageContext.getInstance().getJythonContext().getDict();
        this.lastColId = this.table.getColIdListOnly().get(this.table.getColIdListOnly().size() - 1);
        this.table.getTableModel().removeAll();
        String json = (String)dict.get("retData_" + this.table.getId());
        List<Map<String, String>> datas = this.table.json2TableData(json);
        for (Map<String, String> oneRowMap : datas) {
            TableData oneRowData = new TableData();
            oneRowData.setDataIdList(this.table.getColIdListOnly());
            oneRowData.setId2DataMap(oneRowMap);
            this.table.getTableModel().addRow(new TableRow[]{this.createTableRow(oneRowData)});
        }
        this.backToWaitingTable();
    }

    private void backToWaitingTable() {
        int rowSize = this.table.getTableModel().getAllRows().size();
        for (int i = 0; i < rowSize; ++i) {
            this.chgRowStatus(StopIoStatus.WAITING.getKey(), i);
        }
        this.checkAllSucc = true;
    }

    private TableRow<?, ?> createTableRow(TableData oneRow) {
        DefaultTableRow row = new DefaultTableRow(this.table.getColumnNames().length, (Object)oneRow, (Object)oneRow);
        List<String> dataIdList = oneRow.getDataIdList();
        Map<String, String> id2DataMap = oneRow.getId2DataMap();
        List<String> detailIdList = this.table.getDetailDialogIdList();
        int i = 0;
        for (String id : dataIdList) {
            String value = id2DataMap.get(id);
            if (detailIdList.contains(id)) {
                TableColumn columnData = this.table.getId2ColCfgMap().get(id);
                IsmTableCell.HyperlinkCell link = new IsmTableCell.HyperlinkCell(ResourceUtil.getString("bizpack.wizard.stopiostep.detail"), (ActionListener)new HyperLinkListener(columnData));
                row.setValueAt(i, (Object)link);
                ++i;
                continue;
            }
            if (null == value) {
                ++i;
                continue;
            }
            if (i == dataIdList.size() - 1) {
                this.setLastRowValue((TableRow<?, ?>)row, i, value);
                ++i;
                continue;
            }
            row.setValueAt(i, (Object)value);
            ++i;
        }
        return row;
    }

    private String tableData2json(TableData oneRow) {
        JSONObject tableData = new JSONObject(oneRow.getId2DataMap());
        return tableData.toString();
    }

    private String getTabelItemId(String id) {
        StringBuilder itemId = new StringBuilder();
        itemId.append("input");
        itemId.append('_');
        itemId.append(this.getId());
        itemId.append('_');
        itemId.append(id);
        return itemId.toString();
    }

    private void setLastRowValue(TableRow<?, ?> row, int colIndex, String value) {
        if (null == value || "".equals(value)) {
            return;
        }
        if (value.trim().equals(StopIoStatus.WAITING.getKey())) {
            row.setValueAt(colIndex, (Object)StopIoStatus.WAITING.toString());
            return;
        }
        if (value.trim().equals(StopIoStatus.LOADING.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(LOADING_IMG);
            IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, StopIoStatus.LOADING.toString());
            row.setValueAt(colIndex, (Object)cell);
            icon.setImageObserver((ImageObserver)this.table.getIsmTable());
        } else if (value.trim().equals(StopIoStatus.STOPPED.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(PASSED_IMG);
            row.setValueAt(colIndex, (Object)new IsmTableCell.IconCell((Icon)icon, StopIoStatus.STOPPED.toString()));
        } else if (value.trim().equals(StopIoStatus.RUNNING.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(NOTPASSED_IMG);
            row.setValueAt(colIndex, (Object)new IsmTableCell.IconCell((Icon)icon, StopIoStatus.RUNNING.toString()));
        }
    }

    private class HyperLinkListener
    implements ActionListener {
        private TableColumn columnData;

        public HyperLinkListener(TableColumn columnData) {
            this.columnData = columnData;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableDetailInfoDialog detailDialog = new TableDetailInfoDialog(this.columnData, StopHostIoStep.this.scriptPath, StopHostIoStep.this.getParentWindow());
            try {
                TableRow row = StopHostIoStep.this.table.getIsmTable().getMarkedRow();
                if (row == null) {
                    LOGGER.error("Getting marked row is null");
                    return;
                }
                TableData oneRow = (TableData)row.getIdentifier();
                StopHostIoStep.this.getSsEnv().getDict().put("input_changed_id", StopHostIoStep.this.getTabelItemId(StopHostIoStep.this.table.getId()));
                StopHostIoStep.this.getSsEnv().getDict().put(StopHostIoStep.this.getTabelItemId(StopHostIoStep.this.table.getId()), StopHostIoStep.this.tableData2json(oneRow));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("click hyperLink[" + StopHostIoStep.this.getTabelItemId(StopHostIoStep.this.table.getId()) + "]");
                }
                detailDialog.setVisible(true);
            }
            catch (Exception e1) {
                LOGGER.error("click hyperLink fail", (Throwable)e1);
            }
        }
    }

    private class StartCheckThread
    extends Thread {
        private StartCheckThread() {
        }

        @Override
        public void run() {
            StopHostIoStep.this.finish = false;
            StopHostIoStep.this.setRunningUiStatus();
            LOGGER.info("start check#######");
            if (null == StopHostIoStep.this.ioStepTask) {
                DialogUtils.showErrorDialog((Window)StopHostIoStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                return;
            }
            int rowSize = StopHostIoStep.this.table.getTableModel().getAllRows().size();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(" check table.getTableModel() =" + StopHostIoStep.this.table.getTableModel().getAllRows().size());
            }
            for (int i = 0; i < rowSize; ++i) {
                StopHostIoStep.this.execOneCheck(i);
            }
            if (StopHostIoStep.this.checkAllSucc) {
                StopHostIoStep.this.chgWizState(true);
            } else {
                StopHostIoStep.this.chgWizState(false);
            }
            StopHostIoStep.this.layout.getCheckButton().setEnabled(true);
            StopHostIoStep.this.finish = true;
        }
    }

    private class CheckBtnListener
    implements ActionListener {
        private CheckBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StopHostIoStep.this.layout.getCheckButton().setEnabled(false);
            FlowWizardState state = StopHostIoStep.this.getUIState(false, false);
            StopHostIoStep.this.changeUIState(state);
            if (StopHostIoStep.this.isCheck) {
                StopHostIoStep.this.layout.getCheckButton().setText(ResourceUtil.getString("bizpack.wizard.stopiostep.recheck"));
                UCD.formatMnemonicDisplay((AbstractButton)StopHostIoStep.this.layout.getCheckButton());
                StopHostIoStep.this.isCheck = false;
                new StartCheckThread().start();
            } else {
                StopHostIoStep.this.reCheck();
            }
            LOGGER.info("actionPerformed end");
        }
    }
}

