/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.stop;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.Dimension;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StopHostIoStepCfg
extends BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopHostIoStepCfg.class);
    private static final String HOST_TABLE = "host-table";
    private static final String COLUMN = "column";
    private static final String DIALOG_COLUMN = "dialog-column";
    private static final Dimension DEFAULT_DIALOG_SIZE = new Dimension(450, 530);
    private TableItem ioTable = new TableItem(this.getId());

    @Override
    public void loadConfig(Element node) {
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setPrompt(this.getAttribute(node, "prompt", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        String auto = this.getAttribute(node, "auto", "");
        if (auto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        String backwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(backwardStr);
        Element tableNodeElement = XmlUtils.getChild(node, HOST_TABLE);
        if (tableNodeElement == null) {
            return;
        }
        String itemId = this.getAttribute(tableNodeElement, "id", "");
        String name = this.getAttribute(tableNodeElement, "name", "");
        this.ioTable.setId(itemId);
        this.ioTable.setName(name);
        this.loadOneTableColumn(tableNodeElement, this.ioTable);
        this.parseCommon(node);
    }

    private void loadOneTableColumn(Element node, TableItem tableItem) {
        NodeList columnList = node.getElementsByTagName(COLUMN);
        if (columnList == null || columnList.getLength() == 0) {
            return;
        }
        int tableLength = columnList.getLength();
        List<TableColumn> columnIdList = tableItem.getColumnIdList();
        for (int index = 0; index < tableLength; ++index) {
            Element nodeElement = (Element)columnList.item(index);
            String itemId = this.getAttribute(nodeElement, "id", "");
            String name = this.getAttribute(nodeElement, "name", "");
            String visible = this.getAttribute(nodeElement, "visible", "");
            String showdialog = this.getAttribute(nodeElement, "showdialog", "");
            TableColumn selectTableColumn = new TableColumn();
            selectTableColumn.setId(itemId);
            selectTableColumn.setName(name);
            if (visible.trim().equalsIgnoreCase("false")) {
                selectTableColumn.setVisible(false);
            }
            if ("true".equals(showdialog.trim())) {
                TableItem detailTable = new TableItem(this.getId());
                this.loadShowDialogItem(node, detailTable);
                detailTable.setName(name);
                detailTable.setId(itemId);
                String script = this.getAttribute(nodeElement, "script", "");
                String param = this.getAttribute(node, "param", "");
                String sizeStr = this.getAttribute(nodeElement, "dialogsize", "");
                selectTableColumn.setScript(script);
                selectTableColumn.setParam(param);
                selectTableColumn.setHasDetailDialog(true);
                Dimension size = DEFAULT_DIALOG_SIZE;
                try {
                    if (!StringUtils.isNULLStr((String)sizeStr)) {
                        String[] sizeList = sizeStr.split(",");
                        int x = Integer.parseInt(sizeList[0].trim());
                        int y = Integer.parseInt(sizeList[1].trim());
                        size = new Dimension(x, y);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Load WizardSize ERR", (Throwable)e);
                    size = DEFAULT_DIALOG_SIZE;
                }
                selectTableColumn.setDialogSize(size);
                selectTableColumn.setDetailDialogTable(detailTable);
            }
            columnIdList.add(selectTableColumn);
        }
    }

    private void loadShowDialogItem(Element node, TableItem detailTable) {
        NodeList columnList = node.getElementsByTagName(DIALOG_COLUMN);
        if (columnList == null || columnList.getLength() == 0) {
            return;
        }
        int tableLength = columnList.getLength();
        List<TableColumn> columnIdList = detailTable.getColumnIdList();
        for (int index = 0; index < tableLength; ++index) {
            Element nodeElement = (Element)columnList.item(index);
            String itemId = this.getAttribute(nodeElement, "id", "");
            String name = this.getAttribute(nodeElement, "name", "");
            String visible = this.getAttribute(nodeElement, "visible", "");
            TableColumn selectTableColumn = new TableColumn();
            selectTableColumn.setId(itemId);
            selectTableColumn.setName(name);
            if (visible.trim().equalsIgnoreCase("false")) {
                selectTableColumn.setVisible(false);
            }
            columnIdList.add(selectTableColumn);
        }
    }

    public TableItem getIoTable() {
        return this.ioTable;
    }

    public void setIoTable(TableItem ioTable) {
        this.ioTable = ioTable;
    }
}

