/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui;

import com.huawei.ism.tool.base.ui.component.FuncItem;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class ToolUCD {
    public static final int HEAD_LOGO_BAR_BUTTON_FONT_COLOR = 0xFFFFFF;
    public static final Color LEFT_PANEL_COLOR = new Color(15725560);
    public static final int TASK_BAR_MARGIN_WIDTH = 18;
    public static final int TASK_BAR_HIGHT = 29;
    public static final int STATUS_BAR_HEIGHT = 26;
    public static final int TASK_BAR_PREFERED_LENGTH = 220;
    public static final int TASK_BAR_DIST_HIGHT = 0;
    public static final Font STANDARD_ZH_FONT = new Font("\u5b8b\u4f53", 0, 12);
    public static final Font STANDARD_EN_FONT = new Font("Arail", 0, 12);
    public static final int FUNC_ITEM_HEIGHT = 80;

    private ToolUCD() {
    }

    public static JPanel createVerticalRightPanel(JPanel panel, FuncItem ... items) {
        if (null == items) {
            return null;
        }
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(Color.WHITE);
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(25));
        hBox.add(ToolUCD.buildVerticalItemBox(items));
        panel.add(hBox);
        panel.add(Box.createHorizontalStrut(25));
        return panel;
    }

    public static Box buildVerticalItemBox(FuncItem ... items) {
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(25));
        for (FuncItem item : items) {
            item.setPreferredSize(new Dimension(800, 80));
            item.setMaximumSize(new Dimension(1500, 80));
            item.setOpaque(false);
            vBox.add(item);
            vBox.add(Box.createVerticalStrut(45));
        }
        vBox.add(Box.createVerticalGlue());
        vBox.add(Box.createVerticalStrut(40));
        return vBox;
    }

    public static void setStandardFont(JComponent ... components) {
    }

    public static void setFont(JComponent jComponent, Font enFont, Font zhFont) {
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        if (loc.getLanguage().equals(Locale.CHINA.getLanguage())) {
            jComponent.setFont(zhFont);
        } else {
            jComponent.setFont(enFont);
        }
    }

    public static void initGlobalFontSetting(Locale loc) {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return;
        }
        String family = null;
        family = loc.getLanguage().equals(Locale.CHINA.getLanguage()) ? STANDARD_ZH_FONT.getFamily() : STANDARD_EN_FONT.getFamily();
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            FontUIResource fuiRes = (FontUIResource)value;
            Font f = new Font(family, fuiRes.getStyle(), fuiRes.getSize());
            UIManager.put(key, new FontUIResource(f));
        }
    }
}

