/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui;

import com.huawei.ism.tool.base.ui.action.ToolAction;
import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UiMethod {
    private static final Logger log = LoggerFactory.getLogger(UiMethod.class);
    private static final int PWSL = 60;
    private static final Integer[] BUTTON_WIDTH_CHOICES = new Integer[]{50, 60, 70, 80, 90, 100, 110, 120, 130};
    private static final Integer ISMSERVICETOOLTEXT_WIDTH = 14;
    private static ImageIcon blackRec = ResourceUtil.getImage("wizard_rectangle.jpg");

    private UiMethod() {
    }

    public static void showProgressDialog(JDialog dialog, int seconds) {
        CloseProgressDialogThread thread = new CloseProgressDialogThread(dialog, seconds);
        thread.setUncaughtExceptionHandler((thd, throwable) -> log.error("thread {} execute error.", (Object)thread.getName(), (Object)throwable));
        thread.start();
        SwingUtilities.invokeLater(new ShowProgressDialogThread(dialog));
    }

    public static void setComponentSize(Dimension size, Component ... components) {
        for (Component component : components) {
            component.setPreferredSize(size);
            component.setMinimumSize(size);
            component.setMaximumSize(size);
        }
    }

    public static void setComponentProperty(String method, Object[] args, JComponent comps) {
        if (null == comps) {
            return;
        }
        ReflectionUtils.refInvoke(comps, method, args);
        Component[] components = comps.getComponents();
        if (null == components) {
            return;
        }
        for (Component com : components) {
            ReflectionUtils.refInvoke(com, method, args);
            if (!(com instanceof JComponent)) continue;
            UiMethod.setComponentProperty(method, args, (JComponent)com);
        }
    }

    public static void setBatchComponentProperty(String methodName, Object[] args, JComponent ... comps) {
        for (JComponent com : comps) {
            UiMethod.setComponentProperty(methodName, args, com);
        }
    }

    public static void setFont(JComponent jComponent, Font enFont, Font zhFont, Locale loc) {
        if (loc.getLanguage().equals(Locale.CHINA.getLanguage())) {
            jComponent.setFont(zhFont);
        } else {
            jComponent.setFont(enFont);
        }
    }

    public static Dimension computeButtonPreferredSize(JButton button) {
        JButton tmpBtn = new JButton(button.getText());
        Dimension dimension = tmpBtn.getPreferredSize();
        Integer[] widthChoices = BUTTON_WIDTH_CHOICES;
        int widthMultiple = 10;
        int height = 25;
        int preferredWidthIndex = UiMethod.findNearest(dimension.width, widthChoices);
        dimension.width = preferredWidthIndex >= 0 ? widthChoices[preferredWidthIndex] : (dimension.width + widthMultiple / 2) / widthMultiple * widthMultiple;
        dimension.height = height;
        return dimension;
    }

    private static Integer findNearest(Integer value, Integer[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (value > array[i]) continue;
            return i;
        }
        return -1;
    }

    public static void putScreenCenter(Window window) {
        Dimension location = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation(location.width / 2 - window.getWidth() / 2, location.height / 2 - window.getHeight() / 2);
        window.setLocationRelativeTo(null);
    }

    public static GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        return gbc;
    }

    public static JPanel createImportTextPanel(String text, JTextComponent pathTextField, JButton btnBrowse) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.insets.left = 0;
        JLabel label = new JLabel(text);
        gbc.fill = 1;
        gbc.insets.top = 0;
        panel.add((Component)label, gbc);
        gbc.insets.bottom = 0;
        ++gbc.gridy;
        gbc.weightx = 100.0;
        gbc.weighty = 1.0;
        panel.add((Component)pathTextField, gbc);
        gbc.weighty = 0.0;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.right = 0;
        panel.add((Component)btnBrowse, gbc);
        btnBrowse.setMnemonic('B');
        return panel;
    }

    public static JPanel createImportFilePanel(String borderTitle, String labelStr, JTextComponent filePath, JButton browseBtn) {
        JPanel panel = new JPanel();
        if (null != borderTitle) {
            TitledBorder border = new TitledBorder(borderTitle);
            panel.setBorder(border);
        }
        JLabel label = new JLabel(labelStr);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets.left = 12;
        gbc.weightx = 0.0;
        panel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.insets.top = 0;
        panel.add((Component)filePath, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        panel.add((Component)browseBtn, gbc);
        return panel;
    }

    public static JComponent createImportFileBox(String borderTitle, String labelStr, JTextComponent filePath, JButton browseBtn) {
        TitledBorder border = null;
        if (null != borderTitle) {
            border = new TitledBorder(borderTitle);
        }
        JComponent label = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)new JLabel(labelStr))});
        JComponent textAndBtn = UCD.buildHorizotalBox(null, (Component[])new Component[]{filePath, browseBtn});
        return UCD.buildVerticalBox((Border)border, (Component[])new Component[]{label, textAndBtn});
    }

    public static JLabel createHtmlLabel(String text) {
        return UiMethod.createHtmlLabel(text, 4);
    }

    public static JLabel createHtmlLabel(String text, int fontSize) {
        return new JLabel("<html><font size=" + fontSize + ">" + text + "</font></html>");
    }

    public static void setCloseWhenEscKeyPressed(final JDialog dialog) {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        dialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
    }

    public static void setButtonMnemonic(JButton button) {
        String text = button.getActionCommand();
        if (StringUtils.isChinese(text) && text.contains("(") && text.contains(")")) {
            String mnemonic = StringUtils.findMatchStr(text, "^.*\\((.*)\\).*$");
            button.setMnemonic(mnemonic.charAt(0));
        } else if (!StringUtils.isChinese(text)) {
            button.setMnemonic(text.charAt(0));
        }
    }

    public static void setBatchButtonMnemonic(JButton ... buttons) {
        for (JButton b : buttons) {
            UiMethod.setButtonMnemonic(b);
        }
    }

    public static Box createBtnBox(JButton btnConfirm, JButton btnCancel) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        btnConfirm.setMnemonic(79);
        box.add(btnConfirm);
        box.add(Box.createHorizontalStrut(4));
        btnCancel.setMnemonic(67);
        Dimension btnSize = new Dimension(80, 25);
        UiMethod.setComponentSize(btnSize, btnCancel, btnConfirm);
        box.add(btnCancel);
        return box;
    }

    public static JComponent buildCompsLeft(Component ... components) {
        return UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (Component[])components));
    }

    public static JComponent buildLeftLabel(String text) {
        JLabel label = new JLabel(text);
        return UiMethod.buildCompsLeft(label);
    }

    public static JComponent buildCompsLeft(int margin, Component ... components) {
        return UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (int)margin, (Component[])components));
    }

    public static JComponent buildCompsRight(Component ... components) {
        return UCD.buildHorizontalBoxRight((Component)UCD.buildHorizotalBox(null, (Component[])components));
    }

    public static JComponent buildCompsRight(int margin, Component ... components) {
        return UCD.buildHorizontalBoxRight((Component)UCD.buildHorizotalBox(null, (int)margin, (Component[])components));
    }

    public static Box createHorizontalBox(Component ... components) {
        Box box = Box.createHorizontalBox();
        for (Component com : components) {
            box.add(Box.createHorizontalStrut(12));
            box.add(com);
            box.add(Box.createHorizontalStrut(12));
        }
        return box;
    }

    public static JPanel createHorizontalPanel(JLabel label, JComponent comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        gbc.fill = 2;
        gbc.anchor = 22;
        gbc.insets.left = 0;
        panel.add((Component)comp, gbc);
        return panel;
    }

    public static Box createVerticalBox(JComponent ... components) {
        Box box = Box.createVerticalBox();
        for (JComponent com : components) {
            box.add(Box.createVerticalStrut(12));
            box.add(com);
            box.add(Box.createVerticalStrut(12));
        }
        return box;
    }

    public static JButton createButton(String name) {
        JButton button = new JButton(name);
        UiMethod.setButtonMnemonic(button);
        return button;
    }

    public static JButton createButton(String name, char mnemonic) {
        JButton button = new JButton(name);
        button.setMnemonic(mnemonic);
        UCD.formatMnemonicDisplay((AbstractButton)button);
        return button;
    }

    public static JButton createMenuButton(String btnName, final List<ToolAction> actions) {
        final JButton btn = new JButton(btnName){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics arg0) {
                super.paint(arg0);
                Icon arrow = UIManager.getIcon("Table.descendingSortIcon");
                int xValue = this.getWidth() - arrow.getIconWidth() - 8;
                int yValue = (this.getHeight() - arrow.getIconHeight()) / 2;
                arrow.paintIcon(this, arg0, xValue, yValue);
            }
        };
        btn.setToolTipText(btnName);
        btn.setFocusable(false);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                JPopupMenu popmenu = new JPopupMenu();
                for (ToolAction action : actions) {
                    popmenu.add(action);
                    popmenu.setEnabled(action.isAvailable());
                }
                popmenu.show(me.getComponent(), 0, btn.getY() + btn.getHeight() - 3);
            }
        });
        Dimension dim = UCD.computeButtonPreferredSize((AbstractButton)btn);
        dim.height = 25;
        dim.width += 12;
        btn.setMinimumSize(dim);
        btn.setPreferredSize(dim);
        btn.setMaximumSize(dim);
        return btn;
    }

    public static JLabel createLabel(String text) {
        JLabel lalbel = new JLabel(text + ":");
        return lalbel;
    }

    public static void setComponentSameWidth(JComponent comp1, JComponent comp2) {
        double width2;
        double width1 = comp1.getPreferredSize().getWidth();
        double width = width1 > (width2 = comp2.getPreferredSize().getWidth()) ? width1 : width2;
        comp2.setPreferredSize(new Dimension((int)width, comp2.getHeight()));
        comp2.setMinimumSize(new Dimension((int)width, comp2.getHeight()));
        comp1.setPreferredSize(new Dimension((int)width, comp1.getHeight()));
        comp1.setMinimumSize(new Dimension((int)width, comp1.getHeight()));
    }

    public static void setComponentSameSize(JComponent ... comps) {
        Dimension size = null;
        for (JComponent com : comps) {
            if (null == size) {
                size = com.getMaximumSize();
            }
            UiMethod.setComponentSize(size, com);
        }
    }

    public static void setComponentSameMaxWidthSize(JComponent ... comps) {
        Dimension size = null;
        for (JComponent com : comps) {
            if (null == size) {
                size = com.getMaximumSize();
            }
            if (size.width >= com.getMaximumSize().width) continue;
            size = com.getMaximumSize();
        }
        for (JComponent com : comps) {
            UiMethod.setComponentSize(size, com);
        }
    }

    public static JPanel createField(String label, JComponent component) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel(label));
        panel.add(component);
        return panel;
    }

    public static JEditorPane createLinkPane(String text) {
        JEditorPane editPane = UiMethod.createEditorPane();
        editPane.setText("<font face='' size='3'> <a href=\"\">" + text + "</a></font>");
        return editPane;
    }

    public static JEditorPane createEditorPane() {
        JEditorPane editPane = new JEditorPane();
        editPane.setContentType("text/html;charset=utf-8");
        editPane.setEditable(false);
        editPane.setFocusable(false);
        editPane.setEditable(false);
        editPane.setOpaque(false);
        return editPane;
    }

    public static JTextPane createTextPaneWithLeftIdent(String text, int leftIdent) {
        JTextPane textPane = new JTextPane();
        textPane.setFocusable(false);
        textPane.setEditable(false);
        textPane.setOpaque(false);
        textPane.setText(text);
        Style style = textPane.getStyle("default");
        StyleConstants.setFirstLineIndent(style, Float.valueOf(leftIdent).floatValue());
        return textPane;
    }

    public static JTextPane createTextPaneWithDefaultLeftIdent(String text) {
        return UiMethod.createTextPaneWithLeftIdent(text, 0);
    }

    public static JPanel createPanel(String panelBorderText) {
        JPanel panel = new JPanel();
        TitledBorder border = new TitledBorder(panelBorderText);
        panel.setBorder(border);
        return panel;
    }

    public static IsmTextField createDateTextField() {
        return IsmTextField.getNameTextField((String)"([0-9-:\\s])*", (String)"", (int)22, (int)ISMSERVICETOOLTEXT_WIDTH);
    }

    public static JComponent buildVerticalOppositionalPan(Component top, Component bottom) {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.add(top, "North");
        pan.add(bottom, "South");
        return pan;
    }

    public static JComponent buildVerticalOppositionalPan(Component top, Component bottom, String bottomLayoutPosition) {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.add(top, "North");
        pan.add(bottom, "Center");
        return pan;
    }

    public static IsmTextField createIpv4TextField() {
        return IsmTextField.getNameTextField((String)"([0-9]|\\.)*", (String)"", (int)15, (int)ISMSERVICETOOLTEXT_WIDTH);
    }

    public static IsmTextField createIpv6TextField() {
        return IsmTextField.getNameTextField((String)"([a-fA-F0-9]|:)*", (String)"", (int)45, (int)ISMSERVICETOOLTEXT_WIDTH);
    }

    public static IsmTextField createIpv4v6TextField() {
        return IsmTextField.getNameTextField((String)"([a-fA-F0-9]|:|\\.)*", (String)"", (int)45, (int)ISMSERVICETOOLTEXT_WIDTH);
    }

    public static IsmTextField createEmailTextField() {
        return IsmTextField.getNameTextField((String)"([a-zA-Z0-9]|[_@.])*", (String)"", (int)128, (int)ISMSERVICETOOLTEXT_WIDTH);
    }

    public static TaskResult asyncExecute(Window parent, ServiceTask task) {
        ProgressDialog progressDialog = new ProgressDialog(parent);
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        return taskExecutor.execute(task);
    }

    public static JPanel buildVerticalCheckboxPanel(JCheckBox ... box) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (JCheckBox cb : box) {
            panel.add(cb);
            panel.add(Box.createVerticalStrut(12));
        }
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    public static IsmTextField getUsernameFiled() {
        IsmTextField username = IsmTextField.getNameTextField((String)"^[a-zA-Z_][0-9a-zA-Z_-]*", (String)"", (int)60, (int)ISMSERVICETOOLTEXT_WIDTH);
        return username;
    }

    public static IsmTextField getSshPortFiled() {
        IsmTextField sshPort = IsmTextField.getNameTextField((String)"[0-9]{1,5}", (String)"", (int)60, (int)ISMSERVICETOOLTEXT_WIDTH);
        return sshPort;
    }

    public static JComponent createTextWithPicture(String info) {
        JLabel imgLabel = new JLabel(blackRec);
        imgLabel.setSize(blackRec.getIconWidth(), blackRec.getIconHeight());
        JComponent iconBox = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(6), imgLabel, Box.createVerticalGlue()});
        JComponent comp = UiMethod.buildCompsLeft(0, iconBox, Box.createHorizontalStrut(6), UiMethod.createJTextArea(info));
        return comp;
    }

    public static JPanel createSquareLayoutPanel(JComponent[] leftCompList, JComponent[] rightCompList, int ... markRow) {
        int compSize = leftCompList.length;
        if (compSize != rightCompList.length) {
            throw new IllegalArgumentException("Left componenet is not equal with right component.");
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets.top = 4;
        for (int i = 0; i < compSize; ++i) {
            if (i == compSize - 1) {
                gbc.insets.bottom = 0;
            }
            gbc.insets.left = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            JComponent leftComp = leftCompList[i];
            JComponent rightComp = rightCompList[i];
            gbc.insets.right = 12;
            panel.add((Component)UCD.buildHorizontalBoxRight((Component)leftComp), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.insets.right = 0;
            panel.add((Component)rightComp, gbc);
            UiMethod.addMarkStar(panel, gbc, i, markRow);
            ++gbc.gridy;
            gbc.insets.top = 0;
        }
        return panel;
    }

    private static void addMarkStar(JPanel panel, GridBagConstraints gbc, int index, int[] markRow) {
        if (null == markRow || markRow.length == 0) {
            return;
        }
        for (int row : markRow) {
            if (index != row) continue;
            JLabel starLabel = new JLabel("*");
            starLabel.setForeground(new Color(16729404));
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            gbc.insets.left = 4;
            panel.add((Component)starLabel, gbc);
        }
    }

    public static JComponent buildCrossBox(Component ... coms) {
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i = 0; i < coms.length; ++i) {
            Box hView = null;
            int next = i + 1;
            hView = next < coms.length ? UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{coms[i], coms[++i]})) : UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{coms[i], Box.createGlue()}));
            lines.add(hView);
        }
        lines.add(Box.createVerticalGlue());
        return UCD.buildVerticalBox(null, (Component[])lines.toArray(new JComponent[lines.size()]));
    }

    public static JComponent buildCompSpace(JComponent comp, Border border) {
        JComponent hComp = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), comp, Box.createHorizontalStrut(0)});
        JComponent vComp = UCD.buildVerticalBox((Border)border, (Component[])new Component[]{hComp, Box.createVerticalStrut(0)});
        return vComp;
    }

    public static JComponent buildFrameSpace(JComponent component, int margin) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(margin));
        hBox.add(component);
        hBox.add(Box.createHorizontalStrut(margin));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(margin));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(margin));
        return vBox;
    }

    public static JLabel createColonLabel(String text) {
        return new JLabel(text + ":");
    }

    public static IsmPasswordField getPasswordFiled() {
        IsmPasswordField password = new IsmPasswordField(ISMSERVICETOOLTEXT_WIDTH.intValue(), 60);
        password.getPasswordPopupInfo().removeAllInform();
        password.setMaxValidRestrict(60);
        return password;
    }

    public static IsmPasswordField getPasswordField(int length) {
        return UiMethod.getPasswordField(length, 60);
    }

    public static IsmPasswordField getPasswordField(int length, int column) {
        IsmPasswordField password = new IsmPasswordField(length, column);
        password.getPasswordPopupInfo().removeAllInform();
        return password;
    }

    public static JComponent buildOptionsPan(String ... infos) {
        Box comps = Box.createVerticalBox();
        for (int i = 0; i < infos.length; ++i) {
            comps.add(UiMethod.createTextWithPicture(infos[i]));
            if (i >= infos.length - 1) continue;
            comps.add(Box.createVerticalStrut(8));
        }
        return comps;
    }

    public static JTextArea createJTextArea(String pragraph) {
        JTextArea infoArea = new JTextArea();
        infoArea.setLineWrap(true);
        infoArea.setWrapStyleWord(true);
        infoArea.setFocusable(false);
        infoArea.setEditable(false);
        infoArea.setOpaque(false);
        infoArea.setBackground(UIManager.getColor("Panel.background"));
        infoArea.setText(pragraph);
        return infoArea;
    }

    public static boolean showInputDialog(JDialog parent, Locale loc, String title, String desc, List<JComponent> comps) {
        InputDialog inputDialog = new InputDialog(parent, loc, title, desc, comps);
        inputDialog.toFront();
        inputDialog.setVisible(true);
        return !inputDialog.isCancelClose();
    }

    public static void addTableLinkCellCursorPatch(final IsmTable ismTable) {
        ismTable.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int curRolloverRow = ismTable.rowAtPoint(mouseEvent.getPoint());
                if (-1 == curRolloverRow) {
                    ismTable.setCursor(new Cursor(0));
                    return;
                }
                int curRolloverColumn = ismTable.columnAtPoint(mouseEvent.getPoint());
                Object cell = ismTable.getValueAt(curRolloverRow, curRolloverColumn);
                boolean isActionValid = false;
                if (cell instanceof IsmTableCell.HyperlinkCell) {
                    isActionValid = true;
                }
                ismTable.setCursor(new Cursor(isActionValid ? 12 : 0));
            }
        });
    }

    static class InputDialog
    extends PublicDialog {
        private static final long serialVersionUID = -4821923950621684350L;
        private boolean cancelClose = true;

        public InputDialog(JDialog parent, Locale loc, String title, String desc, List<JComponent> comps) {
            super(parent, loc);
            this.setModal(true);
            this.setResizable(false);
            this.setTitle(title);
            this.initUI(desc, comps);
            this.initListener();
            this.pack();
            SwingUtil.putScreenCenter((Window)this);
        }

        private void initListener() {
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cancelClose = false;
                    this.dispose();
                }
            });
        }

        public boolean isCancelClose() {
            return this.cancelClose;
        }

        private void initUI(String desc, List<JComponent> comps) {
            JTextPane descPan = UiMethod.createTextPaneWithDefaultLeftIdent(desc);
            JComponent inputComps = UiMethod.buildCrossBox(comps.toArray(new JComponent[comps.size()]));
            JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{descPan, inputComps});
            this.getContentPanel().setLayout(new BorderLayout());
            this.getContentPanel().add((Component)UiMethod.buildFrameSpace(view, 12), "North");
        }
    }

    private static class ShowProgressDialogThread
    implements Runnable {
        private JDialog dialog = null;

        public ShowProgressDialogThread(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            this.dialog.setVisible(true);
        }
    }

    private static class CloseProgressDialogThread
    extends Thread {
        private JDialog dialog = null;
        private int seconds = 0;

        public CloseProgressDialogThread(JDialog dialog, int seconds) {
            this.dialog = dialog;
            this.seconds = seconds;
        }

        @Override
        public void run() {
            try {
                if (this.seconds < 1000) {
                    Thread.sleep((long)this.seconds * 1000L);
                } else {
                    Thread.sleep(1000000L);
                }
            }
            catch (InterruptedException e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("CloseProgressDialogThread sleep is interrupted." + e);
            }
            this.dialog.dispose();
        }
    }
}

