/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.checkboxtree;

import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckLabelPanel;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.ui.swing.TernaryCheckBox;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CheckTreeCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 276774752723956344L;
    private CheckTreeNode node = null;
    private JTree tree = null;
    private CheckLabelPanel chkPanel = null;

    public CheckTreeCellEditor(CheckLabelPanel panel) {
        super((JCheckBox)panel.getCheckBox());
        this.chkPanel = panel;
        panel.getCheckBox().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                TernaryCheckBox checkbox = (TernaryCheckBox)event.getSource();
                boolean isSelected = checkbox.isSelected();
                CheckTreeCellEditor.this.node.setSelected(isSelected);
                if (CheckTreeCellEditor.this.tree != null) {
                    CheckTreeCellEditor.this.tree.repaint();
                }
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = jTree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        CheckLabelPanel checkLabel = this.chkPanel;
        this.node = (CheckTreeNode)value;
        if (!this.node.isHasCheckBox()) {
            checkLabel = new CheckLabelPanel(false);
        }
        this.tree = jTree;
        TernaryCheckBox box = checkLabel.getCheckBox();
        box.setSelected(this.node.isSelected());
        box.setEnabled(this.node.isCheckEnable());
        checkLabel.getTreeLabel().setFont(jTree.getFont());
        checkLabel.getTreeLabel().setText(stringValue);
        checkLabel.getTreeLabel().setSelected(true);
        Icon icon = this.getLabelIcon(this.node);
        if (null != icon) {
            checkLabel.getTreeLabel().setIcon(icon);
        } else {
            checkLabel.getTreeLabel().setIcon(null);
        }
        return checkLabel;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.node != null) {
            return this.node.getUserObject();
        }
        return null;
    }

    protected Icon getLabelIcon(CheckTreeNode treNode) {
        return null;
    }
}

