/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.checkboxtree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;

public class CheckTreeNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private static final long serialVersionUID = 1L;
    protected boolean selected = false;
    protected boolean checkEnable = true;
    protected boolean expanded;
    protected String description;
    private boolean hilight;
    private String toolTips = this.toString();
    private int selectionMode;
    private boolean hasCheckBox = true;
    private boolean partSelect = false;

    public CheckTreeNode() {
        this(null);
    }

    public CheckTreeNode(Object userObject) {
        this(userObject, true, false);
    }

    public CheckTreeNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
        this.selected = isSelected;
        this.setSelectionMode(4);
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.setChildrenSelected(isSelected);
        this.setFatherSelected(isSelected);
    }

    public void setExpanded(boolean isExpanded) {
        this.expanded = isExpanded;
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)e.nextElement();
                node.setExpanded(isExpanded);
            }
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setCheckEnable(boolean isEnable) {
        this.checkEnable = isEnable;
    }

    public boolean isCheckEnable() {
        return this.checkEnable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setChildrenSelected(boolean isSelected) {
        this.selected = isSelected;
        if (this.selected) {
            this.setPartSelect(false);
        }
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)e.nextElement();
                node.setChildrenSelected(isSelected);
            }
        }
    }

    protected void setFatherSelected(boolean isSelected) {
        this.selected = isSelected;
        CheckTreeNode father = (CheckTreeNode)this.getParent();
        if (null != father) {
            boolean isFatherSelected = true;
            Enumeration e = father.children.elements();
            int notSelectCount = 0;
            int allSize = 0;
            while (e.hasMoreElements()) {
                CheckTreeNode child = (CheckTreeNode)e.nextElement();
                if (!child.selected) {
                    isFatherSelected = false;
                    ++notSelectCount;
                }
                ++allSize;
            }
            father.setFatherSelected(isFatherSelected);
            if (allSize != notSelectCount) {
                father.setPartSelect(allSize - notSelectCount != allSize);
            } else {
                father.setPartSelect(false);
            }
        }
    }

    public String getToolTips() {
        return this.toolTips;
    }

    public void setToolTips(String toolTips) {
        this.toolTips = toolTips;
    }

    public boolean isHasCheckBox() {
        return this.hasCheckBox;
    }

    public void setHasCheckBox(boolean hasCheckBox) {
        this.hasCheckBox = hasCheckBox;
    }

    public boolean isHilight() {
        return this.hilight;
    }

    public void setHilight(boolean hilight) {
        this.hilight = hilight;
    }

    public boolean isPartSelect() {
        return this.partSelect;
    }

    public void setPartSelect(boolean partSelect) {
        this.partSelect = partSelect;
    }
}

