/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.treetable;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.base.ui.component.treetable.TreeTableUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MutliHyperLinkCell {
    private static final long serialVersionUID = 1808111220086856741L;
    private static MutliHyperlinkRenderer render = new MutliHyperlinkRenderer();
    private Map<String, ActionListener> hyperLinkMap = new HashMap<String, ActionListener>();

    public TableCellRenderer getRender() {
        return render;
    }

    public void addHyperLinkCell(String text, ActionListener action) {
        this.hyperLinkMap.put(text, action);
    }

    public Map<String, ActionListener> getHyperActionMap() {
        return this.hyperLinkMap;
    }

    static class MutliHyperlinkRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        JPanel panel = new JPanel();

        public MutliHyperlinkRenderer() {
            this.panel.setOpaque(true);
            this.panel.setLayout(new BoxLayout(this.panel, 0));
        }

        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.panel.removeAll();
            if (!(table instanceof TreeTable)) {
                return null;
            }
            if (value instanceof MutliHyperLinkCell) {
                MutliHyperLinkCell cell = (MutliHyperLinkCell)value;
                Map<String, ActionListener> actionMap = cell.getHyperActionMap();
                for (Map.Entry<String, ActionListener> entry : actionMap.entrySet()) {
                    String text = entry.getKey();
                    this.panel.add(Box.createHorizontalStrut(12));
                    ToolHyperLinkLabel label = new ToolHyperLinkLabel(text);
                    this.panel.add(label);
                }
            }
            TreeTableUtils.setCompColor(this.panel, isSelected, (TreeTable)((Object)table), row);
            return this.panel;
        }
    }
}

