/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardTitlePane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WizardRootPaneUI
extends BasicRootPaneUI
implements Serializable {
    private static final long serialVersionUID = -6333312716713869858L;
    private static final String[] BORDERKEYS = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int[] CURSOR_MAPPING = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private transient MouseInputListener mouseInputListener;
    private transient LayoutManager layoutManager;
    private transient LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private JComponent titleComponent = null;
    private boolean showHelp = true;
    private boolean showAbout = false;
    private boolean showMinimize = false;
    private boolean showMaxsize = false;
    private boolean showSetting = false;

    public boolean isShowAbout() {
        return this.showAbout;
    }

    public void setShowAbout(boolean showAbout) {
        this.showAbout = showAbout;
    }

    public boolean isShowMinimize() {
        return this.showMinimize;
    }

    public void setShowMinimize(boolean showMinimize) {
        this.showMinimize = showMinimize;
    }

    public void setShowHelp(boolean showHelp) {
        this.showHelp = showHelp;
    }

    public boolean isShowMaxsize() {
        return this.showMaxsize;
    }

    public void setShowMaxsize(boolean showMaxsize) {
        this.showMaxsize = showMaxsize;
    }

    public boolean isShowSetting() {
        return this.showSetting;
    }

    public void setShowSetting(boolean showSetting) {
        this.showSetting = showSetting;
    }

    public void setAboutAction(Action action) {
        if (null == this.titleComponent) {
            return;
        }
        ((WizardTitlePane)this.titleComponent).setAboutAction(action);
    }

    public void setSettingAction(Action action) {
        if (this.titleComponent != null) {
            ((WizardTitlePane)this.titleComponent).setSettingAction(action);
        }
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpCallBack) {
        if (null == this.titleComponent) {
            return;
        }
        ((WizardTitlePane)this.titleComponent).setHelpActionObserver(helpCallBack);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WizardRootPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)CommonUtil.convertObject((Object)jComponent, JRootPane.class);
        if (this.root.getWindowDecorationStyle() != 0) {
            this.installClientDecorations(this.root);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    void installBorder(JRootPane rootPane) {
        int style = rootPane.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(rootPane);
        } else {
            LookAndFeel.installBorder(rootPane, BORDERKEYS[style]);
        }
    }

    private void uninstallBorder(JRootPane rootPane) {
        LookAndFeel.uninstallBorder(rootPane);
    }

    private void installWindowListeners(Component parentComp) {
        this.window = parentComp instanceof Window ? (Window)parentComp : SwingUtilities.getWindowAncestor(parentComp);
        if (null != this.window) {
            if (null == this.mouseInputListener) {
                this.mouseInputListener = this.createWindowMouseInputListener();
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (null != this.window) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane aRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManagerOnRootPane();
        }
        this.savedOldLayout = aRootPane.getLayout();
        aRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane aRootPane) {
        if (this.savedOldLayout != null) {
            aRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane aRootPane) {
        this.installBorder(aRootPane);
        this.titleComponent = new WizardTitlePane(aRootPane, this.showHelp, this.showAbout, this.showMinimize, this.showMaxsize, this.showSetting);
        this.setTitlePane(aRootPane, this.titleComponent);
        this.installWindowListeners(aRootPane.getParent());
        this.installLayout(aRootPane);
        if (this.window != null) {
            aRootPane.revalidate();
            aRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane aRootPane) {
        this.uninstallBorder(aRootPane);
        this.uninstallWindowListeners();
        this.setTitlePane(aRootPane, null);
        this.uninstallLayout(aRootPane);
        int style = aRootPane.getWindowDecorationStyle();
        if (style == 0) {
            aRootPane.repaint();
            aRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new WindowMouseInputHandler();
    }

    private LayoutManager createLayoutManagerOnRootPane() {
        return new MetalRootLayoutManager();
    }

    private void setTitlePane(JRootPane rootPane, JComponent titleJpane) {
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titleJpane != null) {
            layeredPane.add((Component)titleJpane, JLayeredPane.FRAME_CONTENT_LAYER);
            titleJpane.setVisible(true);
        }
        this.titlePane = titleJpane;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent changeEvent) {
        super.propertyChange(changeEvent);
        String propertyName = changeEvent.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane rootPane = (JRootPane)changeEvent.getSource();
            int style = rootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(rootPane);
            if (style != 0) {
                this.installClientDecorations(rootPane);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners();
            if (((JRootPane)changeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root.getParent());
            }
        }
    }

    private class WindowMouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindowAction;
        private int dragActionCursor;
        private int dragActionOffsetX;
        private int dragActionOffsetY;
        private int dragWindowWidth;
        private int dragWindowHeight;

        private WindowMouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JRootPane windowRootPane = WizardRootPaneUI.this.getRootPane();
            int noneRootPane = 0;
            if (windowRootPane.getWindowDecorationStyle() == noneRootPane) {
                return;
            }
            Point dragWindowOffset = mouseEvent.getPoint();
            Window eventSourceWindow = (Window)mouseEvent.getSource();
            if (null == eventSourceWindow) {
                return;
            }
            eventSourceWindow.toFront();
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(eventSourceWindow, dragWindowOffset, WizardRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (eventSourceWindow instanceof Frame) {
                frame = (Frame)eventSourceWindow;
            } else if (eventSourceWindow instanceof Dialog) {
                dialog = (Dialog)eventSourceWindow;
            }
            int frameState = frame != null ? frame.getExtendedState() : 0;
            this.pressMouse(dragWindowOffset, eventSourceWindow, convertedDragWindowOffset, frame, dialog, frameState);
        }

        private void pressMouse(Point dragWindowOffset, Window window, Point convertedDragWindowOffset, Frame frame, Dialog dialog, int frameState) {
            boolean isDialogResizeable;
            JComponent titleJPane = WizardRootPaneUI.this.getTitlePane();
            boolean bl = isDialogResizeable = dialog != null && dialog.isResizable();
            if (titleJPane != null && titleJPane.contains(convertedDragWindowOffset)) {
                this.reduceDepth(dragWindowOffset, window, frame, dialog, frameState);
            } else if (frame != null && frame.isResizable() && (frameState & 6) == 0 || isDialogResizeable) {
                this.dragActionOffsetX = dragWindowOffset.x;
                this.dragActionOffsetY = dragWindowOffset.y;
                this.dragWindowWidth = window.getWidth();
                this.dragWindowHeight = window.getHeight();
                this.dragActionCursor = this.getCursor(this.calculateCorner(window, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        private void reduceDepth(Point dragWindowOffset, Window window, Frame frame, Dialog dialog, int frameState) {
            boolean isActiveArea;
            boolean bl = isActiveArea = dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < window.getWidth() - 5;
            if ((frame != null && (frameState & 6) == 0 || dialog != null) && isActiveArea) {
                this.isMovingWindowAction = true;
                this.dragActionOffsetX = dragWindowOffset.x;
                this.dragActionOffsetY = dragWindowOffset.y;
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.dragActionCursor != 0 && WizardRootPaneUI.this.window != null && !WizardRootPaneUI.this.window.isValid()) {
                WizardRootPaneUI.this.window.validate();
                WizardRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindowAction = false;
            this.dragActionCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            boolean isFramResizeable;
            JRootPane rootPabe = WizardRootPaneUI.this.getRootPane();
            if (rootPabe.getWindowDecorationStyle() == 0) {
                return;
            }
            Window evSource = (Window)ev.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (evSource instanceof Frame) {
                frame = (Frame)evSource;
            } else if (evSource instanceof Dialog) {
                dialog = (Dialog)evSource;
            }
            int cursor = this.getCursor(this.calculateCorner(evSource, ev.getX(), ev.getY()));
            boolean bl = isFramResizeable = frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0;
            if (cursor != 0 && (isFramResizeable || dialog != null && dialog.isResizable())) {
                evSource.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                evSource.setCursor(WizardRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle paneBounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            int correction;
            paneBounds.x += deltaX;
            paneBounds.y += deltaY;
            paneBounds.width += deltaWidth;
            paneBounds.height += deltaHeight;
            if (min == null) {
                return;
            }
            if (paneBounds.width < min.width) {
                correction = min.width - paneBounds.width;
                if (deltaX != 0) {
                    paneBounds.x -= correction;
                }
                paneBounds.width = min.width;
            }
            if (paneBounds.height < min.height) {
                correction = min.height - paneBounds.height;
                if (deltaY != 0) {
                    paneBounds.y -= correction;
                }
                paneBounds.height = min.height;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Window eventSource = (Window)event.getSource();
            Point pt = event.getPoint();
            if (this.isMovingWindowAction) {
                Point eventLocationOnScreen = event.getLocationOnScreen();
                eventSource.setLocation(eventLocationOnScreen.x - this.dragActionOffsetX, eventLocationOnScreen.y - this.dragActionOffsetY);
            } else if (this.dragActionCursor == 0) {
                return;
            }
            Rectangle rectangle = eventSource.getBounds();
            Rectangle startBounds = new Rectangle(rectangle);
            Dimension min = eventSource.getMinimumSize();
            this.adjustPosition(pt, rectangle, min);
            if (!rectangle.equals(startBounds)) {
                eventSource.setBounds(rectangle);
                if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                    eventSource.validate();
                    WizardRootPaneUI.this.getRootPane().repaint();
                }
            }
        }

        private void adjustPosition(Point point, Rectangle rectangle, Dimension min) {
            switch (this.dragActionCursor) {
                case 11: {
                    this.adjust(rectangle, min, 0, 0, point.x + (this.dragWindowWidth - this.dragActionOffsetX) - rectangle.width, 0);
                    break;
                }
                case 9: {
                    this.adjust(rectangle, min, 0, 0, 0, point.y + (this.dragWindowHeight - this.dragActionOffsetY) - rectangle.height);
                    break;
                }
                case 8: {
                    this.adjust(rectangle, min, 0, point.y - this.dragActionOffsetY, 0, -(point.y - this.dragActionOffsetY));
                    break;
                }
                case 10: {
                    this.adjust(rectangle, min, point.x - this.dragActionOffsetX, 0, -(point.x - this.dragActionOffsetX), 0);
                    break;
                }
                case 7: {
                    this.adjust(rectangle, min, 0, point.y - this.dragActionOffsetY, point.x + (this.dragWindowWidth - this.dragActionOffsetX) - rectangle.width, -(point.y - this.dragActionOffsetY));
                    break;
                }
                case 5: {
                    this.adjust(rectangle, min, 0, 0, point.x + (this.dragWindowWidth - this.dragActionOffsetX) - rectangle.width, point.y + (this.dragWindowHeight - this.dragActionOffsetY) - rectangle.height);
                    break;
                }
                case 6: {
                    this.adjust(rectangle, min, point.x - this.dragActionOffsetX, point.y - this.dragActionOffsetY, -(point.x - this.dragActionOffsetX), -(point.y - this.dragActionOffsetY));
                    break;
                }
                case 4: {
                    this.adjust(rectangle, min, point.x - this.dragActionOffsetX, 0, -(point.x - this.dragActionOffsetX), point.y + (this.dragWindowHeight - this.dragActionOffsetY) - rectangle.height);
                    break;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            Window win = (Window)ev.getSource();
            WizardRootPaneUI.this.lastCursor = win.getCursor();
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            Window win = (Window)ev.getSource();
            win.setCursor(WizardRootPaneUI.this.lastCursor);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Window eventSource = (Window)event.getSource();
            if (!(eventSource instanceof Frame)) {
                return;
            }
            Frame frame = (Frame)eventSource;
            Point convertedPoint = SwingUtilities.convertPoint(eventSource, event.getPoint(), WizardRootPaneUI.this.getTitlePane());
            int state = frame.getExtendedState();
            JComponent component = WizardRootPaneUI.this.getTitlePane();
            if (null == component || !component.contains(convertedPoint)) {
                return;
            }
            if (event.getClickCount() % 2 == 0 && (event.getModifiers() & 0x10) != 0) {
                if (!frame.isResizable()) {
                    return;
                }
                IsmPlafUtils.setFrameMaxBounds((Frame)frame);
                if ((state & 6) != 0) {
                    frame.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(state | 6);
                }
            }
        }

        private int calculateCorner(Window window, int xSpot, int ySpot) {
            Insets insets = window.getInsets();
            int xPosition = this.calculatePositionOnWidth(xSpot - insets.left, window.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePositionOnWidth(ySpot - insets.top, window.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return CURSOR_MAPPING[corner];
        }

        private int calculatePositionOnWidth(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class MetalRootLayoutManager
    implements LayoutManager2 {
        private MetalRootLayoutManager() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension cpd = null;
            int cpdWidth = 0;
            int cpdHeight = 0;
            Dimension mbd = null;
            int mbdWidth = 0;
            int mbdHeight = 0;
            Dimension tpd = null;
            int tpdWidth = 0;
            int tpdHeight = 0;
            if (parent instanceof JRootPane) {
                JRootPane root = (JRootPane)parent;
                cpd = this.createCpdData(root);
                mbd = this.createMbdData(mbd, root);
                tpd = this.createTpdData(tpd, root);
                if (cpd != null) {
                    cpdWidth = cpd.width;
                    cpdHeight = cpd.height;
                }
                if (mbd != null) {
                    mbdWidth = mbd.width;
                    mbdHeight = mbd.height;
                }
                if (tpd != null) {
                    tpdWidth = tpd.width;
                    tpdHeight = tpd.height;
                }
            }
            Insets insets = parent.getInsets();
            return new Dimension(Math.max(Math.max(cpdWidth, mbdWidth), tpdWidth) + insets.left + insets.right, cpdHeight + mbdHeight + tpdHeight + insets.top + insets.bottom);
        }

        private Dimension createTpdData(Dimension tpd, JRootPane root) {
            JComponent titlePane;
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof WizardRootPaneUI && (titlePane = ((WizardRootPaneUI)root.getUI()).getTitlePane()) != null) {
                tpd = titlePane.getPreferredSize();
            }
            return tpd;
        }

        private Dimension createMbdData(Dimension mbd, JRootPane root) {
            if (root.getJMenuBar() != null) {
                mbd = root.getJMenuBar().getPreferredSize();
            }
            return mbd;
        }

        private Dimension createCpdData(JRootPane root) {
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            return cpd;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            Dimension tpd = null;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets parentInsets = parent.getInsets();
            JRootPane root = (JRootPane)CommonUtil.convertObject((Object)parent, JRootPane.class);
            Container container = root.getContentPane();
            Dimension dimension = cpd = container != null ? container.getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof WizardRootPaneUI && (titlePane = ((WizardRootPaneUI)root.getUI()).getTitlePane()) != null) {
                tpd = titlePane.getMinimumSize();
            }
            if (tpd != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + parentInsets.left + parentInsets.right, cpHeight + mbHeight + tpHeight + parentInsets.top + parentInsets.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container targetContainer) {
            int maxLayoutWidth;
            int maxLayoutHeight;
            JComponent titlePane;
            Dimension contentPaneDimension = null;
            Dimension jMenuBarDimension = null;
            Dimension titlePaneDimension = null;
            int contentPaneWidth = Integer.MAX_VALUE;
            int contentPaneHeight = Integer.MAX_VALUE;
            int jMenuBarWidth = Integer.MAX_VALUE;
            int jMenuBarHeight = Integer.MAX_VALUE;
            int titlePaneWidth = Integer.MAX_VALUE;
            int titlePaneHeight = Integer.MAX_VALUE;
            Insets insets = targetContainer.getInsets();
            JRootPane root = (JRootPane)CommonUtil.convertObject((Object)targetContainer, JRootPane.class);
            if (root.getContentPane() != null && (contentPaneDimension = root.getContentPane().getMaximumSize()) != null) {
                contentPaneWidth = contentPaneDimension.width;
                contentPaneHeight = contentPaneDimension.height;
            }
            if (root.getJMenuBar() != null && (jMenuBarDimension = root.getJMenuBar().getMaximumSize()) != null) {
                jMenuBarWidth = jMenuBarDimension.width;
                jMenuBarHeight = jMenuBarDimension.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof WizardRootPaneUI && (titlePane = ((WizardRootPaneUI)root.getUI()).getTitlePane()) != null) {
                titlePaneDimension = titlePane.getMaximumSize();
            }
            if (titlePaneDimension != null) {
                titlePaneWidth = titlePaneDimension.width;
                titlePaneHeight = titlePaneDimension.height;
            }
            if ((maxLayoutHeight = Math.max(Math.max(contentPaneHeight, jMenuBarHeight), titlePaneHeight)) != Integer.MAX_VALUE) {
                maxLayoutHeight = contentPaneHeight + jMenuBarHeight + titlePaneHeight + insets.top + insets.bottom;
            }
            if ((maxLayoutWidth = Math.max(Math.max(contentPaneWidth, jMenuBarWidth), titlePaneWidth)) != Integer.MAX_VALUE) {
                maxLayoutWidth += insets.left + insets.right;
            }
            return new Dimension(maxLayoutWidth, maxLayoutHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JRootPane jRootPane = (JRootPane)CommonUtil.convertObject((Object)parent, JRootPane.class);
            Rectangle bounds = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int nextY = 0;
            int layoutWidth = bounds.width - insets.right - insets.left;
            int layoutHeight = bounds.height - insets.top - insets.bottom;
            JComponent titlePane = null;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, layoutWidth, layoutHeight);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, layoutWidth, layoutHeight);
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof WizardRootPaneUI) {
                titlePane = ((WizardRootPaneUI)jRootPane.getUI()).getTitlePane();
            }
            if (titlePane != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, layoutWidth, tpHeight);
                nextY += tpHeight;
            }
            if (jRootPane.getJMenuBar() != null) {
                Dimension mbd = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, nextY, layoutWidth, mbd.height);
                nextY += mbd.height;
            }
            if (jRootPane.getContentPane() != null) {
                jRootPane.getContentPane().setBounds(0, nextY, layoutWidth, layoutHeight < nextY ? 0 : layoutHeight - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

