/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.ui.UiConstants;
import com.huawei.ism.tool.base.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.util.CommonUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class WizardStepItemUI
extends BasicPanelUI {
    private static final WizardStepItemUI INSTANCE = new WizardStepItemUI();
    private static final Color LINE_COLOR = new Color(4144962);
    private static final int LINE_UNDER_TEXT = 4;

    public static ComponentUI createUI(JComponent x) {
        return INSTANCE;
    }

    @Override
    public void paint(Graphics gra, JComponent arg1) {
        if (!(arg1 instanceof WizardStepItem)) {
            return;
        }
        WizardStepItem stepItem = (WizardStepItem)arg1;
        boolean isCurrent = stepItem.isCurrent();
        if (null != stepItem.descriptionTextArea) {
            stepItem.descriptionTextArea.setVisible(isCurrent);
            stepItem.descriptionTextArea.setForeground(isCurrent ? WizardConstants.WIZARD_CURRENT_STEP_DESCRIPTION_FONT_COLOR : WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
        }
        if (isCurrent) {
            stepItem.setBackground(UiConstants.PANEL_COLOR);
            stepItem.stepPpanel.setBackground(UiConstants.PANEL_COLOR);
            stepItem.setLabelTextColor(UIManager.getColor("oem.color"));
            this.checkPpanel(gra, stepItem);
        } else {
            stepItem.setBackground(WizardConstants.WIZARD_BACKGROUND);
            Graphics2D g2d = (Graphics2D)CommonUtil.convertObject((Object)gra, Graphics2D.class);
            ImageIcon icon = ResourceUtil.getImage("wizard_leftpane_bg.png");
            g2d.drawImage(icon.getImage(), 0, 0, arg1.getWidth(), arg1.getHeight(), arg1);
            stepItem.stepPpanel.setBackground(WizardConstants.WIZARD_BACKGROUND);
            stepItem.setLabelTextColor(WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
            g2d.setColor(LINE_COLOR);
            g2d.drawLine(0, stepItem.getHeight() - 1, stepItem.getWidth(), stepItem.getHeight() - 1);
        }
    }

    void checkPpanel(Graphics gra, WizardStepItem stepItem) {
        Color oldColor = gra.getColor();
        Graphics2D g2d = (Graphics2D)CommonUtil.convertObject((Object)gra, Graphics2D.class);
        g2d.setColor(new Color(4144962));
        g2d.fillRect(0, stepItem.getHeight() - 2, stepItem.getWidth(), stepItem.getHeight());
        ImageIcon shadowIcon = ResourceUtil.getImage("wizard_current_step_shadow.png");
        int shadowHeight = shadowIcon.getIconHeight();
        g2d.drawImage(shadowIcon.getImage(), 0, stepItem.getHeight() - shadowHeight, stepItem.getWidth(), shadowHeight, stepItem);
        float[] dash = new float[]{2.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        g2d.setStroke(stroke);
        if (null != stepItem.descriptionTextArea) {
            g2d.setColor(UIManager.getColor("oem.color"));
            Point location = stepItem.stepPpanel.getLocation();
            int lx = location.x;
            int ly = location.y;
            Dimension size = stepItem.stepPpanel.getPreferredSize();
            int height = (int)size.getHeight();
            int lineWidth = (int)stepItem.getPreferredSize().getWidth() - 10 - 15;
            g2d.drawLine(lx, ly + height + 4, lx + lineWidth, ly + height + 4);
        }
        g2d.setColor(oldColor);
    }

    @Override
    public Dimension getPreferredSize(JComponent com) {
        return this.calcSize(com);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(214, 55);
    }

    private Dimension calcSize(JComponent com) {
        Dimension defeaultSize = new Dimension(214, 55);
        if (!(com instanceof WizardStepItem)) {
            return defeaultSize;
        }
        WizardStepItem stepItem = (WizardStepItem)com;
        if (stepItem.isCurrent()) {
            double height = 55.0;
            JTextArea textArea = stepItem.descriptionTextArea;
            if (null != textArea) {
                height += textArea.getPreferredSize().getHeight();
            }
            defeaultSize.setSize(defeaultSize.getWidth(), height);
            return defeaultSize;
        }
        return defeaultSize;
    }
}

