/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.file;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileTypeUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileTypeUtils.class);
    private Map<String, String[]> blackFileTypeMap = new HashMap<String, String[]>();
    private Map<String, String> whiteFileTypeMap = new HashMap<String, String>();
    private static FileTypeUtils instance = null;
    public static final String FILETYPE_PROPERTIES = "/config/filetypes.xml";
    private static final FileTypeUtils DINSTANCE = new FileTypeUtils(false, "/config/filetypes.xml");
    private static final Object LOCK = new Object();
    private static String sFileTypeProperties = "";
    private static final String FILE_SUFFIX = "filesuffix";
    private static final String NO_FILE_TYPE = "noFileType";

    private FileTypeUtils(boolean subtools, String filename) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("subtools=" + subtools + ",filename=" + filename);
        }
        this.getAllFileType(subtools, filename);
    }

    public static FileTypeUtils getInstance() {
        return FileTypeUtils.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileTypeUtils init() {
        String sfileTypePropertiesNew = null;
        File file = null;
        sfileTypePropertiesNew = ApplicationContext.getInstance().getWorkPath() + File.separator + "cfg" + File.separator + "filetypes.xml";
        file = new File(sfileTypePropertiesNew);
        if (!file.exists()) {
            LOGGER.warn("subtools can not find filetypes.xml,use the default filetypes.xml");
            return DINSTANCE;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!sfileTypePropertiesNew.equals(sFileTypeProperties)) {
                String sfilename = sFileTypeProperties = sfileTypePropertiesNew;
                instance = new FileTypeUtils(true, sfilename);
                return instance;
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllFileType(boolean subtools, String filename) {
        InputStream inputStream = null;
        this.blackFileTypeMap.clear();
        this.whiteFileTypeMap.clear();
        try {
            if (subtools && filename != null && !"".equals(filename) && (inputStream = StreamUtils.createInputStream(new File(filename))) != null) {
                LOGGER.info("success to load toolkit filetypes.xml");
            }
            if (inputStream == null && (inputStream = FileTypeUtils.class.getResourceAsStream(filename)) != null) {
                LOGGER.info("success to load filetypes.xml");
            }
            Document doc = XmlUtils.parseDocument(inputStream);
            Element root = doc.getDocumentElement();
            this.readBlackList(root);
            this.readWhiteList(root);
        }
        catch (Throwable e) {
            try {
                LOGGER.error("fail to load filetypes.xml", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, inputStream);
        }
        StreamUtils.closeStream(null, inputStream);
    }

    private void readWhiteList(Element root) {
        Element itemElement = XmlUtils.getChild(root, "whitefiletype");
        if (null != itemElement) {
            for (Element item : XmlUtils.getChildren(itemElement, "type")) {
                String name = item.getAttribute("name");
                String sametype = item.getAttribute("filetype");
                this.whiteFileTypeMap.put(name, sametype);
            }
        }
    }

    private void readBlackList(Element root) {
        Element itemElement = XmlUtils.getChild(root, "filetype");
        if (null != itemElement) {
            for (Element item : XmlUtils.getChildren(itemElement, "type")) {
                String sametype = item.getAttribute("sametype");
                String[] sametypes = sametype.split(",");
                for (Element sitem : XmlUtils.getChildren(item, "code")) {
                    String filecode = sitem.getAttribute("filecode");
                    if (filecode == null || "".equals(filecode)) continue;
                    this.blackFileTypeMap.put(filecode, sametypes);
                }
            }
        }
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getFileCode(FileInputStream inputStream) {
        String fileCode = null;
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] bytes = new byte[10];
            if (inputStream.read(bytes, 0, bytes.length) != -1) {
                fileCode = FileTypeUtils.bytesToHexString(bytes);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not exist");
        }
        catch (IOException e2) {
            LOGGER.error("read failed", (Throwable)e2);
        }
        return fileCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileType(String filePath) {
        ArrayList<String> realfiletypes = new ArrayList<String>();
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            String fileCode = FileTypeUtils.getFileCode(is);
            if (fileCode == null) {
                ArrayList<String> arrayList = realfiletypes;
                return arrayList;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("fileCode=" + fileCode + ",filePath=" + filePath);
            }
            for (String key : this.blackFileTypeMap.keySet()) {
                if (!fileCode.toLowerCase(Locale.ENGLISH).startsWith(key.toLowerCase(Locale.ENGLISH))) continue;
                String[] types = this.blackFileTypeMap.get(key);
                Collections.addAll(realfiletypes, types);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not exist");
        }
        catch (Exception e2) {
            LOGGER.error("read failed", (Throwable)e2);
        }
        finally {
            StreamUtils.closeStream(null, is);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("filetype=" + realfiletypes + ",filePath=" + filePath);
        }
        return realfiletypes;
    }

    public Map<String, Object> getFileTypeIndex(String filePath) {
        File file = new File(filePath);
        String filename = file.getName();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean noFileType = false;
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            noFileType = true;
            index = 0;
        } else {
            ++index;
        }
        String filesuffix = filename.substring(index, filename.length()).toLowerCase(Locale.ENGLISH);
        ret.put(NO_FILE_TYPE, noFileType);
        ret.put(FILE_SUFFIX, filesuffix);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("filename=" + filename + ",filesuffix=" + filesuffix);
        }
        return ret;
    }

    public boolean matchFileType(String filePath) {
        if (filePath == null) {
            return false;
        }
        Map<String, Object> ret = this.getFileTypeIndex(filePath);
        boolean noFileType = (Boolean)ret.get(NO_FILE_TYPE);
        String filesuffix = (String)ret.get(FILE_SUFFIX);
        if (this.noFileTypeCheck(noFileType)) {
            return true;
        }
        if (this.whiteTypeCheck(filesuffix)) {
            return true;
        }
        List<String> realfiletypes = this.getFileType(filePath);
        if (this.noBlackTypeCheck(filesuffix, realfiletypes)) {
            return true;
        }
        if (realfiletypes.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("ismatch=false");
            }
            return false;
        }
        return this.isMatchType(filesuffix, realfiletypes);
    }

    private boolean isMatchType(String filesuffix, List<String> realfiletypes) {
        boolean ismatch = false;
        for (String realtype : realfiletypes) {
            if (!filesuffix.equals(realtype = realtype.toLowerCase(Locale.ENGLISH))) continue;
            ismatch = true;
            break;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ismatch=" + ismatch);
        }
        return ismatch;
    }

    private boolean noBlackTypeCheck(String filesuffix, List<String> realfiletypes) {
        boolean iswhiletype = false;
        if (realfiletypes.isEmpty()) {
            boolean ischecktype = false;
            for (Map.Entry<String, String[]> blackFileType : this.blackFileTypeMap.entrySet()) {
                String[] filetypes;
                for (String filetype : filetypes = blackFileType.getValue()) {
                    if (!filesuffix.equals(filetype = filetype.toLowerCase(Locale.ENGLISH))) continue;
                    ischecktype = true;
                }
            }
            if (!ischecktype) {
                iswhiletype = true;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("filetype not found in xml configuration. iswhiletype=" + iswhiletype);
                }
                return iswhiletype;
            }
        }
        return iswhiletype;
    }

    private boolean noFileTypeCheck(boolean noFileType) {
        boolean iswhiletype = false;
        if (noFileType) {
            iswhiletype = true;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("noFileType=" + noFileType);
            }
        }
        return iswhiletype;
    }

    private boolean whiteTypeCheck(String filesuffix) {
        boolean iswhiletype = false;
        for (Map.Entry<String, String> whitetype : this.whiteFileTypeMap.entrySet()) {
            String filetype = whitetype.getValue();
            if (!filesuffix.equals(filetype = filetype.toLowerCase(Locale.ENGLISH))) continue;
            iswhiletype = true;
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("iswhiletype=" + iswhiletype);
        }
        return iswhiletype;
    }

    public Map<String, String[]> getBlackFileTypeMap() {
        return this.blackFileTypeMap;
    }

    public void setBlackFileTypeMap(Map<String, String[]> blackFileTypeMap) {
        this.blackFileTypeMap = blackFileTypeMap;
    }

    public Map<String, String> getWhiteFileTypeMap() {
        return this.whiteFileTypeMap;
    }

    public void setWhiteFileTypeMap(Map<String, String> whiteFileTypeMap) {
        this.whiteFileTypeMap = whiteFileTypeMap;
    }
}

