/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.wizard;

import com.huawei.ism.tool.base.flow.FlowFactory;
import com.huawei.ism.tool.base.flow.ui.Title;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRadioButton;

public class FlowSelectionDialog
extends PublicDialog {
    private static final long serialVersionUID = -2357810741444385535L;
    private transient List<FlowFactory> factoryList = new ArrayList<FlowFactory>();
    private Locale loc = null;
    private IFlowSelectListener selectListener = null;
    private transient FlowFactory selectedFactory = null;
    private JFrame parent = null;
    private String helpDir = null;

    public FlowSelectionDialog(JFrame parent, String title, Locale loc, ClassLoader clsLoader, List<KeyValue<InputStream, InputStream>> flowList, String helpDir) {
        this(parent, title, loc, clsLoader, null, flowList, helpDir);
    }

    public FlowSelectionDialog(JFrame parent, String title, Locale loc, ClassLoader clsLoader, IFlowSelectListener selectListener, List<KeyValue<InputStream, InputStream>> flowList, String helpDir) {
        super(parent, loc);
        this.parent = parent;
        this.loc = loc;
        this.selectListener = selectListener;
        this.helpDir = helpDir;
        for (KeyValue<InputStream, InputStream> flow : flowList) {
            this.factoryList.add(new FlowFactory(flow.getKey(), flow.getValue(), clsLoader, loc));
        }
        this.setResizable(false);
        this.setHelpButtonVisiable(false);
        this.setAppButtonVisible(false);
        this.setTitle(title);
        this.setModal(true);
        if (flowList.size() > 1) {
            this.initUI();
            this.initListeners();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(false);
            return;
        }
        if (this.factoryList.size() > 1) {
            super.setVisible(true);
        } else if (this.factoryList.size() == 1) {
            this.showFlow(this.factoryList.get(0));
        }
    }

    private void showFlow(FlowFactory flowFactory) {
        FlowWizardDialog wizard = new FlowWizardDialog((Window)this.parent, this.loc, flowFactory, this.helpDir);
        if (null != this.selectListener) {
            this.selectListener.fireFlowSelected(wizard);
        }
        wizard.setSize(this.getSize());
        wizard.setLocation(this.getLocation());
        wizard.setVisible(true);
    }

    private void initUI() {
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)UiMethod.buildFrameSpace(this.buildFlowSelectPanel(), 12), "North");
    }

    private JComponent buildFlowSelectPanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        Component[] compArr = new JComponent[this.factoryList.size() * 3];
        int ind = 0;
        for (FlowFactory flowFactory : this.factoryList) {
            Title t = flowFactory.getFlowTitle();
            if (null == t) continue;
            JRadioButton rdBtn = new JRadioButton(t.getName(this.loc));
            btnGroup.add(rdBtn);
            this.bindSelectListener(rdBtn, flowFactory);
            compArr[ind++] = UCD.buildHorizotalBox(null, (Component[])new Component[]{rdBtn, Box.createHorizontalGlue()});
            IsmTextArea descTxt = UCD.createTextArea((String)t.getDesc(this.loc));
            compArr[ind++] = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(12), descTxt});
            compArr[ind++] = Box.createVerticalStrut(12);
        }
        btnGroup.getElements().nextElement().setSelected(true);
        this.selectedFactory = this.factoryList.get(0);
        return UCD.buildVerticalBox(null, (Component[])compArr);
    }

    private void bindSelectListener(JRadioButton rdBtn, final FlowFactory flowFactory) {
        rdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                FlowSelectionDialog.this.selectedFactory = flowFactory;
            }
        });
    }

    private void initListeners() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                FlowSelectionDialog.this.doOk();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                FlowSelectionDialog.this.dispose();
            }
        });
    }

    private void doOk() {
        this.setVisible(false);
        this.dispose();
        this.showFlow(this.selectedFactory);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.factoryList = new ArrayList<FlowFactory>();
    }

    public static interface IFlowSelectListener
    extends Serializable {
        public void fireFlowSelected(FlowWizardDialog var1);
    }
}

