/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import java.text.Normalizer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeveloperModeCheck {
    private static final Logger log = LoggerFactory.getLogger(DeveloperModeCheck.class);
    private static final int DEFAULT_TIMEOUT = 15;
    private static final String[] DEVELOPER_MODLE_CMD = new String[]{"change user_mode current_mode user_mode=developer", "developer"};

    private DeveloperModeCheck() {
    }

    public static TaskResult checkDeveloperPwd(ICliConnection con, DevNode devNode) {
        TaskResult result = new TaskResult();
        try {
            result.setResultObject((Object)devNode);
            result.setResult(TaskResult.Result.FAILED);
            String sshResult = "";
            for (String cmd : DEVELOPER_MODLE_CMD) {
                sshResult = con.execCmdWithTimout(cmd, 15);
                if ((sshResult = Normalizer.normalize(sshResult, Normalizer.Form.NFKC)).trim().toLowerCase(Locale.ENGLISH).contains("password:")) {
                    result = DeveloperModeCheck.checkPassword(con, result, devNode);
                    break;
                }
                if (sshResult.trim().toLowerCase(Locale.ENGLISH).endsWith("(y/n)")) {
                    con.execCmd("y");
                    result = DeveloperModeCheck.checkPassword(con, result, devNode);
                    break;
                }
                result.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.notfound"));
                result.setErrorId("devicemanager.layout.device.add.deviceadddialog.developer.notfound");
            }
        }
        catch (Exception e) {
            log.error("check developer error. devnode : " + StringUtils.getCleanMessage((String)devNode.getIp()), (Throwable)e);
        }
        return result;
    }

    private static TaskResult checkPassword(ICliConnection con, TaskResult result, DevNode devNode) throws ToolException {
        String debugPwd = devNode.getDeveloperPwd();
        String cmdResult = con.execCmdNoLogTimout(debugPwd, 15);
        if (cmdResult == null) {
            cmdResult = "";
        }
        if ((cmdResult = Normalizer.normalize(cmdResult, Normalizer.Form.NFKC)).trim().toLowerCase(Locale.ENGLISH).contains("developer:")) {
            result.setResult(TaskResult.Result.SUCCESS);
            cmdResult = con.execCmd("exit");
        } else {
            result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.developer.error");
            result.setErrorId("devicemanager.layout.device.add.deviceadddialog.developer.error");
            for (int i = 0; i < 3; ++i) {
                if (cmdResult.trim().endsWith(">")) continue;
                cmdResult = con.execCmd("exit");
            }
        }
        log.info("check command result : {}", (Object)cmdResult);
        return result;
    }
}

