/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.utils.StarterType;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class SolarisHostServiceImpl
extends HostService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SolarisHostServiceImpl.class);
    private static final String SOLARIS_FC_COMMAND = "fcinfo hba-port";
    private static final String SOLARIS_FC_KEY_WORD = "HBA Port WWN";
    private static final String SOLARIS_FC_REG_EXP = "[0-9|a-f]{16}";
    private static final String SOLARIS_ISCSI_COMMAND = "iscsiadm list initiator-node";
    private static final String SOLARIS_ISCSI_KEY_WORD = "Initiator node name";
    private static final String SOLARIS_ISCSI_REG_EXP = "iqn.(\\d{4}-\\d{2}.*)";

    @Override
    public Launcher queryWwn(ICliConnection con, DevNode devNode) {
        HashMap<StarterType, List<String>> hashMap = new HashMap<StarterType, List<String>>();
        WwnUtil.buildWwnData(hashMap, StarterType.FC, SOLARIS_FC_COMMAND, SOLARIS_FC_KEY_WORD, SOLARIS_FC_REG_EXP);
        WwnUtil.buildWwnData(hashMap, StarterType.ISCSI, SOLARIS_ISCSI_COMMAND, SOLARIS_ISCSI_KEY_WORD, SOLARIS_ISCSI_REG_EXP);
        Launcher launcher = new Launcher();
        StringBuffer resultCollect = new StringBuffer();
        try {
            WwnUtil.getAluaWwn(con, hashMap, launcher, resultCollect);
        }
        catch (Exception e) {
            launcher.getOtherDataMap().put("queryWwnSuccess", false);
            LOGGER.error("Get Solaris wwn error:" + e);
            WwnUtil.setFailedInLauncher(launcher);
        }
        WwnUtil.setResult2Launcher(launcher, resultCollect);
        return launcher;
    }
}

