/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.INodeMgrService;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.INodeObserverChk;
import com.huawei.ism.tool.devicemanager.service.pub.DeviceManageImpl;
import com.huawei.ism.tool.devicemanager.ui.mainframe.DeviceManagementPanel;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.pubservice.common.ICloudServiceManage;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;

public final class DefaultNodeProviderImpl
implements INodeMgrService,
ICloudServiceManage {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DefaultNodeProviderImpl.class);
    private static DefaultNodeProviderImpl instance = null;
    private List<DevNode> nodePool = new ArrayList<DevNode>();
    private List<INodeObserver> observerPool = new ArrayList<INodeObserver>();

    private DefaultNodeProviderImpl() {
    }

    public static synchronized DefaultNodeProviderImpl getInstance() {
        if (null == instance) {
            instance = new DefaultNodeProviderImpl();
        }
        return instance;
    }

    public synchronized DevNode findDevNode(String deviceSn) {
        List<DevNode> nodeList = this.getNodeList();
        for (DevNode dv : nodeList) {
            if (!dv.getDeviceSerialNumber().equalsIgnoreCase(deviceSn)) continue;
            return dv;
        }
        return null;
    }

    @Override
    public synchronized List<DevNode> getNodeList() {
        return new ArrayList<DevNode>(this.nodePool);
    }

    public synchronized List<DevNode> getHostNodeList() {
        ArrayList<DevNode> hostDevs = new ArrayList<DevNode>();
        for (DevNode node : this.nodePool) {
            if (!ItDeviceType.Host.equals((Object)node.getItDeviceType())) continue;
            hostDevs.add(node);
        }
        return hostDevs;
    }

    public synchronized List<DevNode> getHostDbNodeList() {
        ArrayList<DevNode> hostDbDevs = new ArrayList<DevNode>();
        for (DevNode node : this.nodePool) {
            if (!ItDeviceType.Host.equals((Object)node.getItDeviceType()) && !ItDeviceType.Database.equals((Object)node.getItDeviceType())) continue;
            hostDbDevs.add(node);
        }
        return hostDbDevs;
    }

    public synchronized void removeNode(String nodeSn) throws ToolException {
        DevNode node = this.findDevNode(nodeSn);
        this.removeNode(node);
    }

    public synchronized void removeNode(DevNode node) throws ToolException {
        this.nodePool.remove(node);
        DeviceLocator.removeDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev((DevNode)node));
        this.notifyDelete(node);
        SshConnectionManager.removeDevRUser((String)node.getDevKey());
    }

    public synchronized void removeNodes(List<DevNode> nodes) throws ToolException {
        this.nodePool.removeAll(nodes);
        for (DevNode d : nodes) {
            this.notifyDelete(d);
            DeviceLocator.removeDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev((DevNode)d));
            LogUtils.addOperaLog("operalog.name.remdevice", d, "");
            SshKnownHostsManager.removeHost((String)d.getIp());
            RestConnectionManager.releaseFceConnection(d);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("[Delete Device >> " + d + "][Success]");
        }
    }

    public synchronized void addNode(DevNode node) throws ToolException {
        if (node instanceof AiDevNode && this.nodePool.stream().anyMatch(cacheNode -> cacheNode instanceof AiDevNode)) {
            throw new ToolException("current.support.one.ai.node");
        }
        if (!this.nodePool.contains(node)) {
            this.nodePool.add(node);
            DeviceLocator.addOrMdyDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev((DevNode)node));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Add device >> {}][Success]", (Object)StringUtils.getCleanMessage((String)node.toString()));
            }
            this.notifyAddNode(node);
        }
    }

    public synchronized void addNodes(Collection<DevNode> nodes) throws ToolException {
        for (DevNode node : nodes) {
            if (this.nodePool.contains(node)) continue;
            this.nodePool.add(node);
            DeviceLocator.addOrMdyDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev((DevNode)node));
            List<INodeObserver> observersList = this.getAllNodeObservers();
            for (INodeObserver observers : observersList) {
                try {
                    if (observers instanceof DeviceManagementPanel) continue;
                    observers.fireNodeAdd(node);
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("fire node add error.", (Throwable)e);
                }
            }
            LogUtils.addOperaLog("operalog.name.impdevice", node, "");
        }
    }

    @Override
    public synchronized void addNodesForUpgradeInstall(Collection<DevNode> nodes) throws ToolException {
        for (DevNode node : nodes) {
            if (this.nodePool.contains(node)) continue;
            this.nodePool.add(node);
            DeviceLocator.addOrMdyDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev((DevNode)node));
            List<INodeObserver> observersList = this.getAllNodeObservers();
            for (INodeObserver observers : observersList) {
                try {
                    observers.fireNodeAdd(node);
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("fire node add error.", (Throwable)e);
                }
            }
        }
    }

    public synchronized void modifyDevice(DevNode node) throws ToolException {
        for (DevNode devNode : this.nodePool) {
            DeviceType devType1;
            String deviceSerialNumber = devNode.getDeviceSerialNumber();
            String deviceSerialNumber2 = node.getDeviceSerialNumber();
            String devIp = devNode.getIp();
            String devIp1 = node.getIp();
            if (!deviceSerialNumber.equals(deviceSerialNumber2) || !devIp.equals(devIp1)) continue;
            DeviceType devType = devNode.getDeviceType();
            if (devType.equals((Object)(devType1 = node.getDeviceType()))) {
                DeviceLocator.addOrMdyDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev((DevNode)node));
                this.updateDevNode(devNode, node);
                this.notifyModify(devNode);
            } else {
                this.removeNode(devNode);
                this.addNode(node);
            }
            if (!LOGGER.isInfoEnabled()) break;
            LOGGER.info("[Modify device >> " + devNode + " to :" + node + "][Success]");
            break;
        }
    }

    private void updateDevNode(DevNode changeDev, DevNode sourceDev) {
        if (changeDev == sourceDev) {
            LOGGER.info("change dev==source dev,no modify....");
            return;
        }
        changeDev.setProductVersion(sourceDev.getProductVersion());
        changeDev.setHotPatchVersion(sourceDev.getHotPatchVersion());
        changeDev.setDeviceName(sourceDev.getDeviceName());
        changeDev.setIp(sourceDev.getIp());
        changeDev.setPeerIp(sourceDev.getPeerIp());
        changeDev.setPort(sourceDev.getPort());
        changeDev.setSudoGrab(sourceDev.isSudoGrab());
        String debugPwd = sourceDev.getDeveloperPwd();
        changeDev.setDeveloperPwd(debugPwd);
        for (String otherIP : sourceDev.getIpList()) {
            changeDev.setActiveIp(otherIP);
        }
        if (sourceDev.isFusionCube()) {
            changeDev.setFusionCubeSSHPort(sourceDev.getFusionCubeSSHPort());
            if (Objects.nonNull(sourceDev.getFusionCubeLoginUser())) {
                changeDev.setFusionCubeLoginUser(new User(sourceDev.getFusionCubeLoginUser()));
            }
            if (Objects.nonNull(sourceDev.getRootUser())) {
                changeDev.setRootUser(new User(sourceDev.getRootUser()));
            }
            if (Objects.nonNull(sourceDev.getFusionCubeUser())) {
                changeDev.setFusionCubeUser(new User(sourceDev.getFusionCubeUser()));
            }
        }
        User user = changeDev.getLoginUser();
        user.setUserName(sourceDev.getLoginUser().getUserName());
        String pwd = sourceDev.getLoginUser().getPassword();
        user.setPassword(pwd);
        user.setPort(sourceDev.getLoginUser().getPort());
        PriKeyInfo info = sourceDev.getPriKey();
        PriKeyInfo info2 = null;
        if (null != info) {
            info2 = new PriKeyInfo();
            info2.setKeyName(info.getKeyName());
            info2.setKeyPath(info.getKeyPath());
            info2.setKeyPwd(info.getKeyPwd());
        }
        changeDev.setPriKey(info2);
        changeDev.setRemoteSNs(sourceDev.getRemoteSNs());
    }

    @Override
    public synchronized boolean isContainsNode(DevNode node) {
        if (null == node) {
            return false;
        }
        for (DevNode nodeT : this.nodePool) {
            if (!nodeT.equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addNodeObservers(INodeObserver observer) {
        if (observer instanceof DeviceManageImpl.DevNodeObservers) {
            DeviceManageImpl.DevNodeObservers obs = (DeviceManageImpl.DevNodeObservers)observer;
            this.clearOldObserver(obs);
        } else {
            this.clearOldObserver(observer.getClass());
        }
        this.observerPool.add(observer);
    }

    public synchronized void addInfoGrabNodeObservers(INodeObserver observer) {
        this.observerPool.add(observer);
    }

    private synchronized void clearOldObserver(DeviceManageImpl.DevNodeObservers obs) {
        Iterator<INodeObserver> iter = this.observerPool.iterator();
        String obClsName = obs.getObserver().getClass().getName();
        while (iter.hasNext()) {
            DeviceManageImpl.DevNodeObservers obIt;
            INodeObserver ob = iter.next();
            if (!(ob instanceof DeviceManageImpl.DevNodeObservers) || !(obIt = (DeviceManageImpl.DevNodeObservers)ob).getObserver().getClass().getName().equals(obClsName)) continue;
            iter.remove();
        }
    }

    private synchronized void clearOldObserver(Class<? extends INodeObserver> clazz) {
        Iterator<INodeObserver> iter = this.observerPool.iterator();
        String obClsName = clazz.getName();
        while (iter.hasNext()) {
            INodeObserver ob = iter.next();
            Class<?> cls = ob.getClass();
            String clsName = cls.getName();
            if (!clsName.equals(obClsName)) continue;
            iter.remove();
        }
    }

    @Override
    public synchronized List<INodeObserver> getAllNodeObservers() {
        return new ArrayList<INodeObserver>(this.observerPool);
    }

    @Override
    public synchronized void removeAllNodeObservers(INodeObserver observer) {
        this.observerPool.clear();
    }

    private void notifyAddNode(DevNode dev) {
        List<INodeObserver> observersList = this.getAllNodeObservers();
        for (INodeObserver observers : observersList) {
            try {
                observers.fireNodeAdd(dev);
                ToolLoggerFactory.getLogger(this.getClass()).info("fireNodeAdd listener Name:" + observers.getClass().getName());
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("fire node add error.", (Throwable)e);
            }
        }
    }

    private void notifyModify(DevNode dev) {
        List<INodeObserver> observersList = this.getAllNodeObservers();
        for (INodeObserver observers : observersList) {
            try {
                observers.fireNodeModify(dev);
            }
            catch (ToolException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("fire node add error.", (Throwable)e);
            }
        }
    }

    private void notifyDelete(DevNode dev) {
        List<INodeObserver> observersList = this.getAllNodeObservers();
        for (INodeObserver observers : observersList) {
            try {
                observers.fireNodeDelete(dev);
            }
            catch (ToolException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("fire node add error.", (Throwable)e);
            }
        }
    }

    @Override
    public void removeNodeObserver(Class<? extends INodeObserver> clazz) {
        this.clearOldObserver(clazz);
    }

    public String getClientID() {
        throw new UnsupportedOperationException();
    }

    public String[] fireNodeAddChk(DevNode dev) throws ToolException {
        List<INodeObserver> observersList = this.getAllNodeObservers();
        for (INodeObserver observers : observersList) {
            if (!(observers instanceof INodeObserverChk)) continue;
            INodeObserverChk observer = (INodeObserverChk)observers;
            String[] ret = observer.fireNodeAddChk(dev);
            return ret;
        }
        return new String[0];
    }

    public Optional<AiDevNode> findDmeWithA800Sn(String a800Sn) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> node instanceof AiDevNode).map(AiDevNode.class::cast).filter(node -> DefaultNodeProviderImpl.isA800Match(a800Sn, node)).findFirst();
    }

    private static boolean isA800Match(String sn, AiDevNode node) {
        return node.getA800Nodes().stream().anyMatch(a800 -> a800.getDeviceSerialNumber().equals(sn));
    }
}

