/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedDialogProxy;
import com.huawei.ism.tool.devicemanager.ui.former.XmlFormer;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceChooserService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class SceneDeviceImpl
extends JDialog
implements IDeviceChooserService {
    private static final long serialVersionUID = 3512773579360286623L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneDeviceImpl.class);

    public void showDeviceChooserDialog(Window parent, boolean isEdit) {
        LOGGER.info("enter show device chooserDialog.");
        try {
            ApplicationContext.getInstance().setEdit(isEdit);
            DeviceSceneContext.getInstance().setSingleDev(false);
            ScenePreparedDialogProxy proxy = new ScenePreparedDialogProxy(parent, isEdit);
            proxy.openDialog();
        }
        catch (Exception e) {
            LOGGER.error("show device chooser Dialog error.", (Throwable)e);
        }
    }

    public void setToolList(List<String> subItemTools) {
        DeviceSceneContext.getInstance().setToolList(subItemTools);
    }

    public void setSceneMsg(JSONObject sceneJson) {
        DeviceSceneContext.getInstance().setSceneJson(sceneJson);
    }

    public void showSingleDeviceChooserDialog(Window parent, boolean isEdit) {
        ApplicationContext.getInstance().setEdit(isEdit);
        DeviceSceneContext.getInstance().setSingleDev(true);
        ScenePreparedDialogProxy proxy = new ScenePreparedDialogProxy(parent, isEdit);
        proxy.openDialog();
    }

    public Map<String, String> scenePanelInitOver() {
        LOGGER.info("enter scenePanel init over.");
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            if (!LocalHostUtil.isRunInSvp()) {
                LOGGER.info("can not refresh panel status");
                return ret;
            }
            DevNode curDev = DeviceSceneContext.getInstance().getCurSvpNode();
            ArrayList<DevNode> devs = new ArrayList<DevNode>();
            devs.add(curDev);
            XmlFormer xmlFormer = new XmlFormer();
            List<Map<String, String>> listMap = xmlFormer.injectDeviceData(devs);
            TaskResult result = SceneXmlData.getInstance().writeDevData2File(devs, listMap);
            if (result.getResult() != TaskResult.Result.SUCCESS) {
                LOGGER.error("write scene device xml error.");
            }
            String svpVersion = LocalHostUtil.getSvpVersion();
            UpgradeSceneData sceneData = this.getSceneSettingData(curDev);
            if (null != sceneData && !StringUtils.isNULLStr((String)sceneData.getTargetVersion())) {
                String targetVersion = sceneData.getTargetVersion();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("targetVersion=" + targetVersion);
                }
                if (!StringUtils.isNULLStr((String)(svpVersion = this.getVrcVersion(svpVersion))) && svpVersion.compareTo(targetVersion) >= 0) {
                    LOGGER.info("disable svp upgrade step");
                    ret.put("disabledStep", "Upadate");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("refresh panel status error.", (Throwable)e);
            return ret;
        }
        LOGGER.info("exit scenepanel init.");
        return ret;
    }

    private String getVrcVersion(String version) {
        int index;
        String result = version;
        if (!StringUtils.isNULLStr((String)result) && (index = result.indexOf("SPH")) != -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    private UpgradeSceneData getSceneSettingData(DevNode devNode) {
        try {
            SceneDataSerialize dataOperate = new SceneDataSerialize();
            Map upgradeSettings = (Map)dataOperate.deserialize();
            if (null == upgradeSettings) {
                LOGGER.info("the scenedata is empty.");
                return null;
            }
            String key = devNode.getIp() + "_" + devNode.getDeviceSerialNumber();
            UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
            if (null == data) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("scenedata can not find the key=" + key);
                }
                return null;
            }
            return data;
        }
        catch (Exception e) {
            LOGGER.error("getSceneSettingData error", (Throwable)e);
            return null;
        }
    }
}

