/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.implement.DevQueryTask;
import com.huawei.ism.tool.devicemanager.service.implement.XlsTemplateResolver;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceListExportOperator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.swing.JFrame;
import org.slf4j.Logger;

public class XlsToXml {
    private static final Logger LOGGER;
    private final ExecutorService exs = ThreadPoolHelper.getFixedNumThreadPool((int)20, (String)"QueryDevInfoPool");
    private final XlsTemplateResolver resolver = new XlsTemplateResolver();
    private List<DevNode> devs = new ArrayList<DevNode>();
    private File xmlFile = new File("DevList.xml");

    public File convertFile(final File file, JFrame frame) {
        LOGGER.info("entrance converter !!!~~~~");
        AsyncExcutor.execute((Window)frame, (Callable[])new Callable[]{new Callable<Object>(){

            @Override
            public Object call() {
                List devList = XlsToXml.this.parseDevs(file);
                try {
                    DeviceListExportOperator deviceListExportOperator = new DeviceListExportOperator(XlsToXml.this.xmlFile.getCanonicalPath(), devList);
                    deviceListExportOperator.export();
                }
                catch (IOException e) {
                    LOGGER.error("get path fail!", (Throwable)e);
                }
                return null;
            }
        }});
        return this.xmlFile;
    }

    private List<DevNode> parseDevs(File file) {
        ArrayList<Future<DevNode>> futures = new ArrayList<Future<DevNode>>();
        List<Object> tasks = new ArrayList();
        try {
            tasks = this.resolver.parseXls2Tasks(file);
            if (tasks == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("parseXls2Tasks err", (Throwable)e);
        }
        for (DevQueryTask devQueryTask : tasks) {
            Future<DevNode> devQueryFuture = this.exs.submit(devQueryTask);
            futures.add(devQueryFuture);
        }
        for (Future future : futures) {
            DevNode dev = null;
            try {
                dev = (DevNode)future.get();
                if (null == dev) continue;
                this.devs.add(dev);
            }
            catch (Exception e) {
                LOGGER.error("query dev error", (Throwable)e);
            }
        }
        return this.devs;
    }

    public List<String> getIP() {
        return XlsTemplateResolver.getIP();
    }

    static {
        ClassLoader cl = XlsToXml.class.getClassLoader();
        if (null == cl) {
            throw new NullPointerException("Classloader is null");
        }
        cl.getResource("log4j.properties");
        LOGGER = ToolLoggerFactory.getLogger(XlsToXml.class);
    }
}

