/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.devicemanager.service.AlarmMonitorService;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.mainframe.DeviceManagementPanel;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.devicemanager.utils.DeviceForbidLoginUtil;
import com.huawei.ism.tool.devicemanager.utils.HostKeyCheckUtils;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IAlarmMonitorService;
import com.huawei.ism.tool.framework.pubservice.common.ISceneService;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class DelDeviceAction
extends ToolAction {
    private static final long serialVersionUID = 1878757876890919815L;
    private DeviceManagementPanel panel = null;

    public DelDeviceAction(DeviceManagementPanel panel) {
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (DeviceContext.checkMarkedDevInTask(this.panel, ResourceUtil.getString((String)"devicemanager.layout.device.delete.devintask"))) {
            return;
        }
        if (this.checkMarkedDevInAlarm()) {
            return;
        }
        if (this.checkMartedDevInSenceTask()) {
            DialogUtils.showInfoDialog((Frame)this.panel.getParentJFrame(), (String)ResourceUtil.getString((String)"devicemanager.layout.device.delete.devinsencetask"));
            return;
        }
        if (!this.confirmDelete()) {
            return;
        }
        List allMarketRows = this.panel.getDeviceTable().getMarkedRows();
        ArrayList<DevNode> removed = new ArrayList<DevNode>();
        for (TableRow row : allMarketRows) {
            Object obj = row.getIdentifier();
            if (!(obj instanceof DevNode)) continue;
            DevNode node = (DevNode)obj;
            removed.add(node);
        }
        try {
            DefaultNodeProviderImpl.getInstance().removeNodes(removed);
        }
        catch (Exception exp) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("", (Throwable)exp);
        }
        HostKeyCheckUtils.deleteFingerPrint(removed);
        this.panel.removeDevices(allMarketRows);
    }

    private boolean checkMartedDevInSenceTask() {
        try {
            ISceneService getSceneContextService = (ISceneService)PublicServiceManage.getInstance().getService(ISceneService.class);
            if (null == getSceneContextService) {
                return false;
            }
            if (!getSceneContextService.isPrepareStepStatus()) {
                return false;
            }
            List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> devsXML = SceneXmlData.getInstance().loadSceneFromFile();
            if (null == (devsXML = DeviceForbidLoginUtil.filterForbidDevContainsShowErrMsg(devsXML))) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("the devInfo get from xml is null.");
                return false;
            }
            List allMarketRows = this.panel.getDeviceTable().getMarkedRows();
            for (TableRow row : allMarketRows) {
                Object obj = row.getIdentifier();
                if (!(obj instanceof DevNode)) continue;
                DevNode node = (DevNode)obj;
                for (com.huawei.ism.tool.framework.pubservice.entity.DevNode tagertNode : devsXML) {
                    if (!tagertNode.getDeviceSerialNumber().equalsIgnoreCase(node.getDeviceSerialNumber())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("checkMartedDevInSenceTask failed." + e);
        }
        return false;
    }

    private boolean checkMarkedDevInAlarm() {
        IAlarmMonitorService alarmMonitorService = (IAlarmMonitorService)PublicServiceManage.getInstance().getService(IAlarmMonitorService.class);
        AlarmMonitorService.getInstance().setAlarmMonitorService(alarmMonitorService);
        if (AlarmMonitorService.getInstance() == null || alarmMonitorService == null) {
            return false;
        }
        List allMarketRows = this.panel.getDeviceTable().getMarkedRows();
        for (TableRow row : allMarketRows) {
            Object obj = row.getIdentifier();
            if (!(obj instanceof DevNode)) continue;
            DevNode node = (DevNode)obj;
            if (!AlarmMonitorService.getInstance().isDevNodeInMonitored(node)) continue;
            DialogUtils.showInfoDialog((Frame)this.panel.getParentJFrame(), (String)ResourceUtil.getString((String)"devicemanager.action.device.delete.deldeviceaction.deviceinmonitor"));
            return true;
        }
        return false;
    }

    private boolean confirmDelete() {
        if (ApplicationContext.getInstance().isJunit()) {
            return true;
        }
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)this.panel.getParentJFrame(), (String)ResourceUtil.getString((String)"devicemanager.layout.device.delete.confirm"));
        return 0 == warningDialog.getValue();
    }

    public boolean isAvailable() {
        return null != this.getUserObject();
    }
}

