/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.devicemanager.service.pub.DevInfoXlsParser;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceToolAction;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public class DownLoadAction
extends DeviceToolAction {
    public static final String TEMPLATE_FILE_NAME = "DeviceList_Template.xls";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DownLoadAction.class);
    private static final String SAVEPATH_DEFAULT_ID = "Import_saveresult_path";
    private Window parent = null;

    public DownLoadAction(Window parent) {
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.abstractActionPerformed(event);
    }

    @Override
    protected void abstractActionPerformed(ActionEvent event) {
        boolean result = this.savaTemplate2Local();
        if (result) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.save.success"));
        }
        LogUtils.addImportLog("devicemanager.layout.device.import.downloadtemplate", "Smartkit", result);
    }

    private boolean savaTemplate2Local() {
        String defaultFileName;
        String suffix;
        String title = ResourceUtil.getString((String)"devicemanager.layout.device.downloadtemplate.path");
        String filePath = ToolFileChooser.getSaveFilePath((String)title, (String)(suffix = "xls"), (Window)this.parent, (String)(defaultFileName = TEMPLATE_FILE_NAME), (String)SAVEPATH_DEFAULT_ID);
        if (null == filePath) {
            return false;
        }
        boolean result = this.writeTemplateFile2Local(filePath);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeTemplateFile2Local(String filePath) {
        block12: {
            boolean bl;
            InputStream ins = DevInfoXlsParser.getTemplateFile();
            FileOutputStream outs = null;
            try {
                if (null == ins) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.templatefile.not.found"));
                    boolean bl2 = false;
                    return bl2;
                }
                if (!FileUtils.isDiskSpaceFull((String)filePath, (InputStream)ins)) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.save.error"));
                    boolean bl3 = false;
                    StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
                    return bl3;
                }
                outs = new FileOutputStream(new File(filePath));
                byte[] b = new byte[1024];
                int size = 0;
                while ((size = ins.read(b, 0, 1024)) != -1) {
                    ((OutputStream)outs).write(b, 0, size);
                }
                bl = true;
                StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
            }
            catch (RuntimeException e) {
                LOGGER.error("Save template file runtime exception.", (Throwable)e);
                break block12;
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(DownLoadAction.class).error("Save template file error.", (Throwable)e);
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.save.error"));
                break block12;
            }
            finally {
                StreamUtils.closeStream(outs, (InputStream)ins);
            }
            return bl;
        }
        return false;
    }

    public boolean isAvailable() {
        return true;
    }
}

