/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.service.DebugCheck;
import com.huawei.ism.tool.devicemanager.service.DeveloperModeCheck;
import com.huawei.ism.tool.devicemanager.ui.dialog.DebugPsdAddLayout;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import org.slf4j.LoggerFactory;

public class DebugPsdAddDialog
extends JDialog {
    private static final long serialVersionUID = -9101382609927938262L;
    private DebugPsdAddLayout layout = null;
    private Window parent;
    private String result;
    private DevNode devNode;

    public DebugPsdAddDialog(Window parent, DevNode devNode) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_DebugPsdDialog");
        this.toFront();
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        SwingUtil.putParentCenter((Window)this, (Window)parent);
        this.parent = parent;
        this.devNode = devNode;
    }

    public void init() {
        if (this.layout != null) {
            this.layout.getDeveloperPwd().setText("");
            return;
        }
        this.layout = new DebugPsdAddLayout();
        this.add(this.layout);
        this.layout.getOkBtn().addActionListener(new OkAction());
        this.layout.getCancelBtn().addActionListener(new CancelAction());
        this.setTitle(ResourceUtil.getString((String)"toolbox.login.developer"));
        this.getRootPane().setDefaultButton(this.layout.getOkBtn());
        this.setMinimumSize(new Dimension(300, 300));
    }

    public void showDialog() {
        this.init();
        this.setModal(true);
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
        this.setVisible(true);
    }

    public String getDebugPassword() {
        if (this.devNode != null && !StringUtils.isNULLStr((String)this.devNode.getDeveloperPwd())) {
            return this.devNode.getDeveloperPwd();
        }
        this.showDialog();
        return this.result;
    }

    private void showMessage(String message) {
        this.layout.getMessageLabel().setText(ResourceUtil.getString((String)message));
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DebugPsdAddDialog.this.layout.getMessageLabel().setText("");
            }
        }, 5000L);
    }

    private class DebugPwdChecker
    extends ServiceTask {
        private DebugPwdChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected TaskResult doTask() {
            TaskResult taskResult;
            ICliConnection con;
            block5: {
                con = null;
                con = SshConnectionManager.getSshConnection((DevNode)DebugPsdAddDialog.this.devNode, null, (boolean)true, (boolean)true);
                TaskResult ret = DeveloperModeCheck.checkDeveloperPwd(con, DebugPsdAddDialog.this.devNode);
                if (!TaskResult.Result.SUCCESS.equals((Object)ret.getResult())) break block5;
                TaskResult taskResult2 = ret;
                SshConnectionManager.releaseConnection((ICliConnection)con);
                return taskResult2;
            }
            try {
                taskResult = DebugCheck.checkDebugPwd(con, DebugPsdAddDialog.this.devNode);
            }
            catch (Exception e) {
                try {
                    DebugPsdAddDialog.this.showMessage("devicemanager.layout.device.operate.failed");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("check debug pssword error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SshConnectionManager.releaseConnection(con);
                    throw throwable;
                }
                SshConnectionManager.releaseConnection((ICliConnection)con);
                return null;
            }
            SshConnectionManager.releaseConnection((ICliConnection)con);
            return taskResult;
        }
    }

    private class OkAction
    implements ActionListener {
        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DebugPsdAddDialog.this.result = String.valueOf(DebugPsdAddDialog.this.layout.getDeveloperPwd().getPassword());
            if (this.isPwdValid(DebugPsdAddDialog.this.result)) {
                DebugPsdAddDialog.this.dispose();
            }
        }

        public boolean isPwdValid(String pwd) {
            if (StringUtils.isNULLStr((String)pwd)) {
                DebugPsdAddDialog.this.showMessage("devicemanager.layout.device.add.deviceadddialog.devicePwdNull");
                return false;
            }
            DebugPsdAddDialog.this.devNode.setDeveloperPwd(pwd);
            TaskResult tResult = UiMethod.asyncExecute((Window)DebugPsdAddDialog.this.parent, (ServiceTask)new DebugPwdChecker());
            if (tResult != null && TaskResult.Result.SUCCESS.equals((Object)tResult.getResult())) {
                return true;
            }
            DebugPsdAddDialog.this.devNode.setDeveloperPwd("");
            if (tResult != null && TaskResult.Result.FAILED.equals((Object)tResult.getResult())) {
                DebugPsdAddDialog.this.showMessage("toolbox.login.error.developer");
            }
            return false;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WarningDialog ignoreDialog = DialogUtils.showYesNoDialog((Window)DebugPsdAddDialog.this, (String)ResourceUtil.getString((String)"device.setdialog.eure.exit"));
            int userChoice = ignoreDialog.getValue();
            if (0 == userChoice) {
                DebugPsdAddDialog.this.result = "";
                DebugPsdAddDialog.this.dispose();
            }
        }
    }
}

