/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicemanager.service.DeviceManageService;
import com.huawei.ism.tool.devicemanager.service.IDeviceManageService;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.pub.DevInfoXlsParser;
import com.huawei.ism.tool.devicemanager.ui.action.DownLoadAction;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.SelKeyAction;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.action.support.TableMultiInfoDialog;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.AuthSettingDilaog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddIpCheck;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceModifyDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceTypePaneLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.ShowDebugDevDialog;
import com.huawei.ism.tool.devicemanager.ui.scnen.A3000SupportSceneEnum;
import com.huawei.ism.tool.devicemanager.ui.scnen.CubeSupportSceneEnum;
import com.huawei.ism.tool.devicemanager.utils.AuthType;
import com.huawei.ism.tool.devicemanager.utils.CertCheckCfmUtils;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.devicemanager.utils.HostKeyCheckUtils;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.devicemanager.utils.ProductParser;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import com.huawei.ism.tool.obase.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.dialogs.DisclaimerDialog;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.SecurityConfigUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAddDialog
extends JDialog
implements IAutoProcess {
    private static final Logger log = LoggerFactory.getLogger(DeviceAddDialog.class);
    public static final String TEMPLATE_FILE_NAME = "DeviceList_Template.xls";
    protected static final int COMMON_BASIC_VIEW_STATE = 1;
    private static final long serialVersionUID = 1L;
    private static final int WIDTH_EN = 490;
    private static final String SAVEPATH_DEFAULT_ID = "Import_saveresult_path_Plat";
    private static final String ROOT_USER = "root";
    private static final int COMMON_CONFIG_VIEW_STATE = 2;
    private static final int FUSIONCUBE_VIEW_STATE = 3;
    private static final int A3000_VIEW_STATE = 4;
    private static final String OPEN_API_USER = "openapi";
    protected DeviceAddLayout layout = null;
    private File selectFile = null;
    private transient IDeviceManageService deviceManageService = null;
    private transient InfoTips tips;
    private Set<SettingType> supportTypes = new HashSet<SettingType>();
    private Window parent;
    private boolean checkRootPw = true;
    private ConcurrentHashMap<String, String> failedDeviceMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> ipCheckInfoMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> needDebugPasswdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> hostKeyCheckMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> certFailMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DevNode> securityAlgorithmFailDev = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> reConfirmAddMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, String> ipRangeOkMap = new ConcurrentHashMap();
    private DeviceDialogType dialogType = DeviceDialogType.StorageOnly;
    private DeviceManageSetting manageSetting;
    private List<ItDeviceType> needSwitchRootDevType = new ArrayList<ItDeviceType>();
    private DevNode currNode = null;
    private boolean forceDebugPwd = false;
    private boolean needIpRange = true;
    private static final int REMOVE_DEV = 0;
    private static final int ADD_DEV = 1;
    private static final int CHECK_FAIL = 2;
    private boolean isForceRootOnHost;
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips) {
        this(parent1, nodeTypeQueryIntf, tips, SettingType.Socks5Proxy, SettingType.SshForward);
    }

    public void addDevTypeSwitchRoot(ItDeviceType devType) {
        if (log.isInfoEnabled()) {
            log.info("add dev type:" + devType);
        }
        if (null != devType) {
            this.needSwitchRootDevType.add(devType);
        }
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, SettingType ... supportTypes) {
        this(parent1, nodeTypeQueryIntf, tips, DeviceDialogType.StorageOnly, supportTypes);
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, DeviceDialogType dlgType, boolean forceDebugPwd, boolean needIpRange, SettingType ... supportTypes) {
        super(parent1);
        this.supportTypes.addAll(Arrays.asList(supportTypes));
        this.parent = parent1;
        this.tips = tips;
        this.deviceManageService = new DeviceManageService(nodeTypeQueryIntf);
        this.dialogType = dlgType;
        this.forceDebugPwd = forceDebugPwd;
        this.needIpRange = needIpRange;
        this.init();
        boolean hasDevTypePane = !DeviceDialogType.StorageOnly.equals((Object)this.dialogType);
        this.layout.getDevTypePane().setVisible(hasDevTypePane);
        DeviceContext.setChooseDevType(hasDevTypePane);
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, DeviceDialogType dlgType, SettingType ... supportTypes) {
        super(parent1);
        this.supportTypes.addAll(Arrays.asList(supportTypes));
        this.parent = parent1;
        this.tips = tips;
        this.deviceManageService = new DeviceManageService(nodeTypeQueryIntf);
        this.dialogType = dlgType;
        this.init();
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (this.isFusionCubeEnable(sceneJson)) {
            this.initManageSetting();
            this.layout.fillDevTypePane(this.manageSetting);
            DeviceContext.setChooseDevType(true);
        } else if (this.isA3000Enable(sceneJson)) {
            this.initManageSetting();
            this.layout.fillDevTypePane(this.manageSetting);
            DeviceContext.setChooseDevType(true);
        } else {
            boolean hasDevTypePane = !DeviceDialogType.StorageOnly.equals((Object)this.dialogType);
            this.layout.getDevTypePane().setVisible(hasDevTypePane);
            DeviceContext.setChooseDevType(hasDevTypePane);
        }
    }

    private boolean isFusionCubeEnable(JSONObject sceneJson) {
        String mainScene = this.getMainScene(sceneJson);
        String subScene = this.getSubScene(sceneJson);
        return CubeSupportSceneEnum.isSceneSupportCube(mainScene, subScene);
    }

    private boolean isA3000Enable(JSONObject sceneJson) {
        String mainScene = this.getMainScene(sceneJson);
        String subScene = this.getSubScene(sceneJson);
        return A3000SupportSceneEnum.isSceneSupportA3000(mainScene, subScene);
    }

    private String getSubScene(JSONObject sceneJson) {
        return Objects.nonNull(sceneJson) ? sceneJson.getStringOrDefault("subScene", "") : "";
    }

    private String getMainScene(JSONObject sceneJson) {
        return Objects.nonNull(sceneJson) ? sceneJson.getStringOrDefault("mainScene", "") : "";
    }

    private void initManageSetting() {
        log.info("initManageSetting : FS, FusionCube");
        this.manageSetting = new DeviceManageSetting(true, true, true);
        ArrayList<ItDeviceType> itDeviceList = new ArrayList<ItDeviceType>();
        HashMap<ItDeviceType, Object> deviceTypeView = new HashMap<ItDeviceType, Object>();
        itDeviceList.addAll(Arrays.asList(ItDeviceType.Storage, ItDeviceType.FUSIONCUBE));
        deviceTypeView.put(ItDeviceType.Storage, null);
        deviceTypeView.put(ItDeviceType.FUSIONCUBE, null);
        this.manageSetting.setItDeviceList(itDeviceList);
        this.manageSetting.setDeviceTypel2(deviceTypeView);
    }

    public void changeRootLoginPloicy() {
        if (ItDeviceType.Host.equals((Object)this.getTypeSelectPanel().getItDevTypeEnum())) {
            this.layout.getRootPwCheck().setEnabled(!this.isForceRootOnHost);
        }
    }

    public void setForceRootOnHost(boolean forceroot) {
        this.isForceRootOnHost = forceroot;
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, DeviceManageSetting manageSetting, SettingType ... supportTypes) {
        super(parent1);
        ArrayList<SettingType> tmpList = new ArrayList<SettingType>(Arrays.asList(supportTypes));
        tmpList.remove(SettingType.Socks5Proxy);
        this.supportTypes.addAll(tmpList);
        this.deviceManageService = new DeviceManageService(nodeTypeQueryIntf);
        this.dialogType = DeviceDialogType.All;
        this.parent = parent1;
        this.tips = tips;
        this.manageSetting = manageSetting;
        this.init();
        this.layout.fillDevTypePane(this.manageSetting);
        DeviceContext.setChooseDevType(true);
    }

    public void setDeveloperSelected(boolean selected) {
        this.layout.getDeveloperCheck().setSelected(selected);
        this.layout.setDeveloperSelected(selected);
    }

    public void setForwardEnabled(boolean enabled) {
        this.layout.getSelectSshForward().setEnabled(enabled);
        if (!enabled) {
            this.supportTypes.remove(SettingType.SshForward);
        } else {
            this.supportTypes.add(SettingType.SshForward);
        }
    }

    public void setSocks5Enabled(boolean enabled) {
        this.layout.getSelectSocks5().setEnabled(enabled);
        if (!enabled) {
            this.supportTypes.remove(SettingType.Socks5Proxy);
        } else {
            this.supportTypes.add(SettingType.Socks5Proxy);
        }
    }

    public void setNoProxyEnabled(boolean enabled) {
        this.layout.getSelectNoProxy().setEnabled(enabled);
    }

    private void init() {
        boolean noProxy;
        this.layout = new DeviceAddLayout();
        this.needSwitchRootDevType.add(ItDeviceType.UltraPath);
        this.needSwitchRootDevType.add(ItDeviceType.Host);
        this.needSwitchRootDevType.add(ItDeviceType.FUIONSTOR_EXP_NEW_NODE);
        this.layout.setCompName();
        this.add(this.layout);
        if (this.forceDebugPwd) {
            this.layout.forceDebug();
        }
        if (!this.needIpRange) {
            this.layout.diableIpRange();
        }
        if (com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().isEnglishEnv()) {
            this.setMinimumSize(new Dimension(490, 580));
        } else {
            this.setMinimumSize(new Dimension(400, 580));
        }
        String path = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getWorkPath();
        if (null == path) {
            throw new NullPointerException("Path is mull");
        }
        int index = path.lastIndexOf("\\");
        String toolTypeName = path.substring(index + 1, path.length());
        ApplicationContext.getInstance().setToolTypeName(toolTypeName);
        this.initState();
        this.initSocks5Data();
        this.initSshData();
        this.initLisnter();
        this.initLisnter2();
        this.getRootPane().setDefaultButton(this.layout.getNextBtn());
        this.setModal(true);
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
        boolean bl = noProxy = !this.supportTypes.contains(SettingType.Socks5Proxy) && !this.supportTypes.contains(SettingType.SshForward);
        if (noProxy) {
            this.layout.getProxySelectPan().setVisible(false);
        }
    }

    public void transState() {
        if (this.layout.getTabState() == 1) {
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.title"));
            this.layout.getLastBtn().setVisible(false);
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.nextbtn"));
            this.layout.getBasicJpane().setVisible(true);
            this.layout.getSetlink().setVisible(true);
            this.layout.getProxySelectPan().setVisible(true);
            this.layout.getCfgJpane().setVisible(false);
            this.layout.getFusionCubeLayout().setVisible(false);
            this.layout.getA3000Layout().setVisible(false);
        } else if (this.layout.getTabState() == 2) {
            this.layout.updateLayout();
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.title1"));
            this.layout.getLastBtn().setVisible(true);
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
            this.layout.getBasicJpane().setVisible(false);
            this.layout.getCfgJpane().setVisible(true);
            this.layout.getFusionCubeLayout().setVisible(false);
            this.layout.getA3000Layout().setVisible(false);
            this.layout.getUsername().requestFocus();
            this.layout.setKeyInfoVisible();
        } else if (this.layout.getTabState() == 4) {
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.a3000.title"));
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
            this.layout.getLastBtn().setVisible(false);
            this.layout.getCfgJpane().setVisible(false);
            this.layout.getBasicJpane().setVisible(false);
            this.layout.getFusionCubeLayout().setVisible(false);
            this.layout.getA3000Layout().setVisible(true);
        } else {
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.title"));
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
            this.layout.getLastBtn().setVisible(false);
            this.layout.getCfgJpane().setVisible(false);
            this.layout.getBasicJpane().setVisible(false);
            this.layout.getFusionCubeLayout().setVisible(true);
            this.layout.getA3000Layout().setVisible(false);
        }
    }

    private void initState() {
        this.transState();
        this.layout.setIsDebugPwVisible(this.getTypeSelectPanel());
        this.resetRootVisible();
        this.layout.getSelectNoProxy().setEnabled(this.isNeedProxy());
        this.layout.getSelectSshForward().setEnabled(this.needSshForward());
        this.layout.getSelectSocks5().setEnabled(this.needSocks5());
        if (null == this.manageSetting) {
            this.manageSetting = null == SceneAddDeviceAction.getSetting() ? new DeviceManageSetting(this.layout.getDeveloperPwd().isVisible(), this.layout.getSelectSshForward().isEnabled(), this.layout.getSelectSocks5().isEnabled()) : SceneAddDeviceAction.getSetting();
        }
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.layout.getNextBtn()});
    }

    protected void resetRootVisible() {
        this.layout.setDPARootPwVisible(this.getTypeSelectPanel());
    }

    protected DeviceTypePaneLayout getTypeSelectPanel() {
        return this.layout.getDevTypePane();
    }

    protected boolean needSocks5() {
        return this.supportTypes.contains(SettingType.Socks5Proxy);
    }

    protected boolean needSshForward() {
        return this.supportTypes.contains(SettingType.SshForward);
    }

    protected boolean isNeedProxy() {
        return this.supportTypes.contains(SettingType.Socks5Proxy) || this.supportTypes.contains(SettingType.SshForward);
    }

    private void addRootPwCheckListener() {
        JCheckBox rootPwCheck = this.layout.getRootPwCheck();
        rootPwCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceAddDialog.this.layout.setrootPwEnabled(DeviceAddDialog.this.layout.getRootPwCheck().isSelected());
                if (!DeviceAddDialog.this.layout.getDevTypePane().getItDevType().getSelectedItem().equals(ItDeviceType.Storage)) {
                    DeviceAddDialog.this.checkRootPw = DeviceAddDialog.this.layout.getRootPwCheck().isSelected();
                }
            }
        });
    }

    private void initLisnter() {
        this.layout.getUsername().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (DeviceAddDialog.this.needCheckSwitchRoot()) {
                    if (DeviceAddDialog.this.layout.getUsername().getText().isEmpty() || DeviceAddDialog.ROOT_USER.equalsIgnoreCase(DeviceAddDialog.this.layout.getUsername().getText())) {
                        DeviceAddDialog.this.layout.setRootPwEnableForLastbtn(false, false);
                    } else {
                        DeviceAddDialog.this.layout.setRootPwEnableForLastbtn(true, DeviceAddDialog.this.checkRootPw);
                    }
                }
            }
        });
        this.addRootPwCheckListener();
        JRadioButton assipra = this.layout.getAssignIpRadio();
        assipra.addChangeListener(event -> UiMethod.setBatchComponentProperty((String)"setEnabled", (Object[])new Object[]{this.layout.getAssignIpRadio().isSelected()}, (JComponent[])new JComponent[]{this.layout.getAssignIpPan()}));
        JRadioButton assiprara = this.layout.getAssignIpRangeRadio();
        assiprara.addChangeListener(event -> UiMethod.setBatchComponentProperty((String)"setEnabled", (Object[])new Object[]{this.layout.getAssignIpRangeRadio().isSelected()}, (JComponent[])new JComponent[]{this.layout.getAssignIpRangePan()}));
        this.addProxyListener();
        this.addLinkListener();
        this.addNavigationBarListener();
        this.addDeviceTypeListener();
        this.addBatchImportListener();
        this.addSelectFileListener();
        this.addImportFileListener();
        this.addDownLoadTemplateListener();
        this.addBatchImportRadioListener();
    }

    private void addProxyListener() {
        JRadioButton sshFor = this.layout.getSelectSshForward();
        sshFor.getModel().addActionListener(new ForwardAction());
        sshFor.addChangeListener(event -> {
            this.layout.getSshRouteList().setEnabled(sshFor.isSelected());
            this.layout.getSshCfgLink().setEnabled(sshFor.isSelected());
        });
        JRadioButton socks = this.layout.getSelectSocks5();
        socks.getModel().addActionListener(new SelectSockes5Action());
        socks.addChangeListener(event -> {
            this.layout.getSocks5List().setEnabled(socks.isSelected());
            this.layout.getSocks5CfgLink().setEnabled(socks.isSelected());
        });
    }

    private void addLinkListener() {
        ToolHyperLinkLabel sockLink = this.layout.getSocks5CfgLink();
        sockLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = -7793742090785827906L;

            public void clickLink(MouseEvent e) {
                SettingService.showSettingDialog(DeviceAddDialog.this, SettingType.Socks5Proxy);
                DeviceAddDialog.this.initSocks5Data();
                if (0 == DeviceAddDialog.this.layout.getSocks5List().getModel().getSize()) {
                    DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"device.adddialog.proxysetting.nosocks5"));
                    DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
                }
            }
        });
        ToolHyperLinkLabel sshLink = this.layout.getSshCfgLink();
        sshLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = 3195294537969274123L;

            public void clickLink(MouseEvent e) {
                SettingService.showSettingDialog(DeviceAddDialog.this, SettingType.SshForward);
                DeviceAddDialog.this.initSshData();
                if (0 == DeviceAddDialog.this.layout.getSshRouteList().getModel().getSize()) {
                    DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"device.adddialog.proxysetting.nomoreroute"));
                    DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
                }
            }
        });
        ToolHyperLinkLabel viewLine = this.layout.getViewLine();
        viewLine.addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void clickLink(MouseEvent e) {
                ShowDebugDevDialog dialog = new ShowDebugDevDialog((Window)DeviceAddDialog.this);
                dialog.setVisible(true);
            }
        });
    }

    private void addNavigationBarListener() {
        this.layout.getLastBtn().addActionListener(event -> {
            this.layout.setTabState(1);
            this.initState();
        });
        this.layout.getNextBtn().addActionListener(new NextAction());
        this.layout.getCancelBtn().addActionListener(event -> this.dispose());
    }

    private void addDeviceTypeListener() {
        this.layout.getDevTypePane().addDeviceTypeItemChangeListener(itDeviceType -> {
            if (ItDeviceType.FUSIONCUBE.equals((Object)itDeviceType)) {
                this.layout.setTabState(3);
                this.transState();
                this.layout.getFusionCubeLayout().getDeviceTypePaneLayout().getItDevType().setSelectedItem(itDeviceType);
            } else if (ItDeviceType.A3000.equals((Object)itDeviceType)) {
                this.layout.setTabState(4);
                this.transState();
                this.layout.getA3000Layout().getDeviceTypePaneLayout().getItDevType().setSelectedItem(itDeviceType);
            } else {
                this.layout.setTabState(1);
                this.transState();
            }
        });
        this.layout.getDevTypePane().getl2Type().addItemListener(event -> {
            Object devType = this.layout.getDevTypePane().getl2Type().getSelectedItem();
            boolean isWindows = devType != null && devType.toString().equals("Windows");
            this.layout.showPort(!isWindows);
            this.layout.enableCustAuth(!isWindows);
            this.layout.getProxySelectPan().setVisible(!isWindows);
            this.layout.setIsDebugPwVisible(this.layout.getDevTypePane());
        });
        this.layout.getFusionCubeLayout().getDeviceTypePaneLayout().addDeviceTypeItemChangeListener(itDeviceType -> {
            if (ItDeviceType.A3000.equals((Object)itDeviceType)) {
                this.layout.setTabState(4);
                this.transState();
                this.layout.getDevTypePane().getItDevType().setSelectedItem(itDeviceType);
            } else if (!ItDeviceType.FUSIONCUBE.equals((Object)itDeviceType)) {
                this.layout.setTabState(1);
                this.transState();
                this.layout.getDevTypePane().getItDevType().setSelectedItem(itDeviceType);
            }
        });
        this.layout.getA3000Layout().getDeviceTypePaneLayout().addDeviceTypeItemChangeListener(itDeviceType -> {
            if (ItDeviceType.FUSIONCUBE.equals((Object)itDeviceType)) {
                this.layout.setTabState(3);
                this.transState();
                this.layout.getDevTypePane().getItDevType().setSelectedItem(itDeviceType);
            } else if (!ItDeviceType.A3000.equals((Object)itDeviceType)) {
                this.layout.setTabState(1);
                this.transState();
                this.layout.getDevTypePane().getItDevType().setSelectedItem(itDeviceType);
            }
        });
    }

    private void addBatchImportRadioListener() {
        this.layout.getBatchImportBtnRadio().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()) {
                    DeviceAddDialog.this.batchImportChange(Color.white, false);
                } else if (null != DeviceAddDialog.this.manageSetting) {
                    DeviceAddDialog.this.layout.getSelectUploadFile().setBackground(new Color(243, 243, 243));
                    DeviceAddDialog.this.layout.getNextBtn().setVisible(true);
                    DeviceAddDialog.this.layout.getSelectNoProxy().setEnabled(DeviceAddDialog.this.manageSetting.isNeedSocks5() || DeviceAddDialog.this.manageSetting.isNeedForward());
                    DeviceAddDialog.this.layout.getSelectSocks5().setEnabled(DeviceAddDialog.this.manageSetting.isNeedSocks5());
                    DeviceAddDialog.this.layout.getSelectSshForward().setEnabled(DeviceAddDialog.this.manageSetting.isNeedForward());
                    DeviceAddDialog.this.layout.getSetlink().setEnabled(true);
                } else {
                    DeviceAddDialog.this.batchImportChange(new Color(243, 243, 243), true);
                }
            }
        });
    }

    private void batchImportChange(Color color, boolean enabled) {
        this.layout.getSelectUploadFile().setBackground(color);
        this.layout.getNextBtn().setVisible(enabled);
        this.layout.getSelectNoProxy().setEnabled(enabled);
        this.layout.getSelectSocks5().setEnabled(enabled);
        this.layout.getSelectSshForward().setEnabled(enabled);
        this.layout.getSetlink().setEnabled(enabled);
    }

    public DeviceAddLayout getMainLayout() {
        return this.layout;
    }

    private boolean executeAddDev(DevInfoXlsParser parser) throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        Collection<DevNode> parseDevs = parser.parseFile(new File(FilePathUtils.filterPath((String)this.getMainLayout().getSelectUploadFile().getText())));
        ArrayList<Callable<DevNode>> calls = new ArrayList<Callable<DevNode>>();
        this.checkParsedDevice(parseDevs, calls);
        List<DevNode> deviceAdded = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (deviceAdded.size() + calls.size() > 256) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.device_sum_limit_info"));
            return true;
        }
        if (!parseDevs.isEmpty()) {
            this.asyncAddDevices(calls, this);
        }
        return false;
    }

    private void checkParsedDevice(Collection<DevNode> parseDevs, List<Callable<DevNode>> calls) {
        if (parseDevs == null) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"toolbox.proy.errormsg"));
            return;
        }
        if (parseDevs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"device.import.success.nodevice"));
            return;
        }
        Map<ItDeviceType, List<String>> supportedTyeMap = this.layout.getDevTypePane().getDeviceTypel2();
        for (DevNode device : parseDevs) {
            device.setUid();
            if (!NetUtil.isValidIP((String)device.getIp())) {
                this.ipCheckInfoMap.put(device.getIp(), ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror"));
                continue;
            }
            if (device.isFusionCube() && Objects.isNull(device.getRootUser())) {
                this.failedDeviceMap.put(device.getIp(), ResourceUtil.getString((String)"devicemanager.layout.device.add.device.miss.root.cube"));
                continue;
            }
            if (this.isDeviceSupported(calls, device, supportedTyeMap)) continue;
            this.add2FailList(device.getUid(), ResourceUtil.getStringWithParams((String)"devicemanger.import.devtype.not.support.tip", (Object[])new Object[]{device.getUid(), device.getItDeviceType(), device.getDevTypeLevel2()}));
        }
    }

    protected boolean isDeviceSupported(List<Callable<DevNode>> calls, DevNode device, Map<ItDeviceType, List<String>> supportedTyeMap) {
        boolean isSupported = false;
        for (Map.Entry<ItDeviceType, List<String>> entry : supportedTyeMap.entrySet()) {
            if (this.dialogType.equals((Object)DeviceDialogType.StorageOnly)) {
                if (!ItDeviceType.Storage.equals((Object)device.getItDeviceType()) && !ItDeviceType.COMPUTE_STORAGE.equals((Object)device.getStorageDeviceType()) && !ItDeviceType.FUSIONCUBE.equals((Object)device.getItDeviceType())) continue;
                calls.add(new FetchDevNodeCall(device));
                isSupported = true;
                break;
            }
            if (!entry.getKey().equals((Object)device.getItDeviceType()) || device.getDevTypeLevel2() != null && entry.getValue() != null && !entry.getValue().contains(device.getDevTypeLevel2().toString())) continue;
            calls.add(new FetchDevNodeCall(device));
            isSupported = true;
            break;
        }
        return isSupported;
    }

    private void addImportFileListener() {
        this.layout.getImportButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceAddDialog.this.ipCheckInfoMap.clear();
                DevInfoXlsParser parser = new DevInfoXlsParser();
                ProgressDialog dialog = new ProgressDialog((Window)DeviceAddDialog.this);
                AsyncExcutor.submit(() -> {
                    boolean isErrorHappened = false;
                    try {
                        if (DeviceAddDialog.this.executeAddDev(parser)) {
                            Boolean bl = false;
                            return bl;
                        }
                    }
                    catch (com.huawei.ism.tool.framework.platform.exception.ToolException te) {
                        DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)(StringUtils.isNULLStr((String)te.getErrorId()) ? "toolbox.proy.errormsg" : te.getErrorId())));
                        isErrorHappened = true;
                    }
                    catch (Exception ee) {
                        log.error("parse file error", (Throwable)ee);
                        DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"toolbox.proy.errormsg"));
                        isErrorHappened = true;
                    }
                    finally {
                        dialog.setVisible(false);
                        if (!isErrorHappened) {
                            DeviceAddDialog.this.setVisible(false);
                        }
                    }
                    return isErrorHappened;
                });
                UiMethod.putScreenCenter((Window)dialog);
                dialog.setVisible(true);
            }
        });
    }

    public static boolean checkHasRootPW(Collection<DevNode> parseDevs, Window parent) {
        ArrayList<ArrayList<Object>> resultList = new ArrayList<ArrayList<Object>>();
        for (DevNode devNode : parseDevs) {
            String loginUserName = devNode.getLoginUser().getUserName();
            com.huawei.ism.tool.framework.pubservice.entity.User adminUser = devNode.getAdminUser();
            String devTypeLevel2Str = devNode.getDevTypeLevel2().toString();
            boolean isNotRootAndNoRootPW = !StringUtils.isNULLStr((String)loginUserName) && !ROOT_USER.equals(loginUserName) && (adminUser == null || adminUser.getPassword() == null);
            boolean bl = "VMware".equalsIgnoreCase(devTypeLevel2Str) || "ESXi".equalsIgnoreCase(devTypeLevel2Str) || "Windows".equalsIgnoreCase(devTypeLevel2Str);
            DeviceAddDialog.hostAndRoute(resultList, devNode, isNotRootAndNoRootPW, bl);
        }
        if (!resultList.isEmpty()) {
            String title = ResourceUtil.getString((String)"toolbox.showinfo.title");
            String[] tableTitles = new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.ip"), ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceType0")};
            String[] msg = new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.batch.import.root.check.msg")};
            String helpInfo = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.batch.import.root.check.helpinfo");
            ArrayList<DefaultTableRow> tableRows = new ArrayList<DefaultTableRow>();
            for (ArrayList arrayList : resultList) {
                DefaultTableRow tableRow = new DefaultTableRow(2, (Object)"", (Object)StringUtils.getNoStripUUID());
                tableRow.setValues((List)arrayList);
                tableRows.add(tableRow);
            }
            TableMultiInfoDialog multiInfoDialog = new TableMultiInfoDialog(parent, title, tableTitles, msg, helpInfo);
            multiInfoDialog.getTopModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
            multiInfoDialog.setVisible(true);
            return multiInfoDialog.isOkPerformed();
        }
        return true;
    }

    private static void hostAndRoute(List<ArrayList<Object>> resultList, DevNode devNode, boolean isNotRootAndNoRootPW, boolean isPassedHostDevType) {
        if (ItDeviceType.Host.equals((Object)devNode.getItDeviceType()) || ItDeviceType.UltraPath.equals((Object)devNode.getItDeviceType())) {
            if (isPassedHostDevType) {
                return;
            }
            if (isNotRootAndNoRootPW) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(devNode.getIp());
                list.add((String)devNode.getDevTypeLevel2());
                resultList.add(list);
            }
        } else if (ItDeviceType.Database.equals((Object)devNode.getItDeviceType()) && !devNode.isUseJdbc() && isNotRootAndNoRootPW) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(devNode.getIp());
            list.add((String)devNode.getDevTypeLevel2());
            resultList.add(list);
        }
    }

    private void addDownLoadTemplateListener() {
        this.layout.getDownloadLabel().addMouseListener((MouseListener)new DownLoadActionAdapter(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeTemplateFile2Local(String filePath) {
        block10: {
            boolean bl;
            InputStream ins = DevInfoXlsParser.getTemplateFile();
            FileOutputStream outs = null;
            try {
                if (null == ins) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.templatefile.not.found"));
                    log.info("Can not find Template file");
                    boolean bl2 = false;
                    return bl2;
                }
                if (!FileUtils.isDiskSpaceFull((String)filePath, (InputStream)ins)) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.error"));
                    boolean bl3 = false;
                    StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
                    return bl3;
                }
                outs = new FileOutputStream(new File(filePath));
                byte[] b = new byte[1024];
                int size = 0;
                while ((size = ins.read(b, 0, 1024)) != -1) {
                    ((OutputStream)outs).write(b, 0, size);
                }
                bl = true;
                StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(DownLoadAction.class).error("Save template file error.");
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.error"));
                break block10;
            }
            finally {
                StreamUtils.closeStream(outs, (InputStream)ins);
            }
            return bl;
        }
        return false;
    }

    private void addSelectFileListener() {
        this.layout.getSelectUploadFile().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()) {
                    return;
                }
                String title = ResourceUtil.getString((String)"devicemanager.layout.device.import");
                File tempFile = DeviceAddDialog.this.getFileFromFileChooser(new String[]{"xls", "xlsx"}, title);
                if (null != tempFile) {
                    DeviceAddDialog.this.selectFile = tempFile;
                    DeviceAddDialog.this.layout.getSelectUploadFile().setText(FilePathUtils.getCanonicalPath((File)DeviceAddDialog.this.selectFile));
                    DeviceAddDialog.this.layout.getSelectUploadFile().setToolTipText(FilePathUtils.getCanonicalPath((File)DeviceAddDialog.this.selectFile));
                    DeviceAddDialog.this.layout.getSelectUploadFile().setForeground(new JLabel().getForeground());
                    DeviceAddDialog.this.layout.getImportButton().setEnabled(true);
                }
            }
        });
    }

    private File getFileFromFileChooser(String[] exts, String title) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        StringBuilder extsDesc = new StringBuilder();
        for (String ext : exts) {
            extsDesc.append("*.").append(ext).append(";");
        }
        extParams.put("description", extsDesc.toString());
        extParams.put("PathId", "select_file_flag");
        extParams.put("title", title);
        File importFile = ToolFileChooser.selectFile((Window)this, (String[])exts, (int)0, (boolean)true, extParams);
        return importFile;
    }

    private void addBatchImportListener() {
        JRadioButton batchImportBtnRadio = this.layout.getBatchImportBtnRadio();
        batchImportBtnRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UiMethod.setBatchComponentProperty((String)"setEnabled", (Object[])new Object[]{DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()}, (JComponent[])new JComponent[]{DeviceAddDialog.this.layout.getBatchImportPan()});
                DeviceAddDialog.this.layout.updateImportBtnStatus();
            }
        });
    }

    private void initLisnter2() {
        JCheckBox developerCheck = this.layout.getDeveloperCheck();
        developerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceAddDialog.this.layout.setDeveloperSelected(DeviceAddDialog.this.layout.getDeveloperCheck().isSelected());
            }
        });
        ToolHyperLinkLabel setLink = this.layout.getSetlink();
        setLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            public void clickLink(MouseEvent e) {
                AuthSettingDilaog dialog = new AuthSettingDilaog(DeviceAddDialog.this);
                dialog.setVisible(true);
            }
        });
        JButton selbtn = this.layout.getKeySelBtn();
        selbtn.addActionListener(new SelKeyAction(this, this.layout.getKeyCombo()));
        new AutoProcessObserver((IAutoProcess)this);
        this.addComponentListener((ComponentListener)new AutoProcessListener((IAutoProcess)this));
    }

    protected boolean needCheckSwitchRoot() {
        boolean isEnable = false;
        Object object = this.layout.getDevTypePane().getl2Type().getSelectedItem();
        if (object != null && (object.toString().equalsIgnoreCase("VMware") || object.toString().equalsIgnoreCase("ESXi") || object.toString().equalsIgnoreCase("Windows"))) {
            return false;
        }
        for (ItDeviceType itDeviceType : this.needSwitchRootDevType) {
            if (!itDeviceType.equals(this.layout.getDevTypePane().getItDevType().getSelectedItem())) continue;
            isEnable = true;
            break;
        }
        return isEnable;
    }

    private void initSocks5Data() {
        this.layout.getSocks5List().removeAllItems();
        List<Socks5Proxy> proxys = SettingService.getProxies();
        for (Socks5Proxy proxy : proxys) {
            this.layout.getSocks5List().addItem(proxy);
        }
    }

    private void initSshData() {
        this.layout.getSshRouteList().removeAllItems();
        KeyOrderedHashMap<String, List<MultiRouteNode>> sshList = SettingService.getSshForwards();
        List keys = sshList.keyList();
        for (String key : keys) {
            this.layout.getSshRouteList().addItem(key);
        }
    }

    protected void processAdd() {
        ItDeviceType deviceType = (ItDeviceType)this.getTypeSelectPanel().getItDevType().getSelectedItem();
        if (this.layout.getAssignIpRadio().isSelected() || ItDeviceType.FUSIONCUBE.equals((Object)deviceType) || ItDeviceType.A3000.equals((Object)deviceType)) {
            this.asSyncGetNode();
        } else if (this.layout.getAssignIpRangeRadio().isSelected()) {
            this.addIpRange();
        }
    }

    private void addIpRange() {
        String startIpAddress = this.layout.getStartIpAddress().getText();
        String endIpAddress = this.layout.getEndIpAddress().getText();
        if (!this.checkUserInputInfo()) {
            return;
        }
        this.setVisible(false);
        this.fetchDevices(startIpAddress, endIpAddress);
    }

    private void fetchDevices(String startIpAddress, String endIpAddress) {
        ArrayList<Callable<DevNode>> calls = new ArrayList<Callable<DevNode>>();
        List<String> ips = DeviceAddIpCheck.getInstance().constructIpSegs(startIpAddress, endIpAddress);
        for (String ip : ips) {
            DevNode device = this.createDev(ip);
            device.setCertCheckSelectFlag(this.layout.getYesAndNoButtonPanel().isSelectedYes());
            calls.add(new FetchDevNodeCall(device));
        }
        this.asyncAddDevices(calls, null);
    }

    private void asyncAddDevices(List<Callable<DevNode>> calls, Window pnt) {
        long startTime = System.currentTimeMillis();
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        ThreadPoolHelper.concurrentExecuteWithProcessBar((Window)(pnt == null ? this.parent : pnt), (JProgressBar)progressBar, calls);
        long finishTime = System.currentTimeMillis();
        this.recordAddTime(finishTime - startTime);
        this.showBatchFailedNode();
        boolean isCertOk = this.showBatchCertFailedNode();
        boolean saveHostKey = this.saveFingerPrintDialog();
        boolean reConfirmAdd = this.reConfirmInfoDialog();
        this.processBatchResult(isCertOk, saveHostKey, reConfirmAdd);
        this.showDebugPasswdUnfilledTip();
        this.addOkDevices();
        this.clearTempData();
        this.showDisclaimerDialog(pnt);
        this.securityAlgorithmFailDev.clear();
    }

    private void showDisclaimerDialog(Window parent) {
        if (this.securityAlgorithmFailDev.isEmpty() || !SecurityConfigUtil.isOnlySecurityAlgorithm()) {
            return;
        }
        DisclaimerDialog dialog = new DisclaimerDialog(parent, DisclaimerDialog.DisclaimerScene.DEVICE_ADD);
        dialog.setVisible(true);
        if (dialog.isAccepted()) {
            SecurityConfigUtil.modifySecurityAlgorithmConfig((boolean)true);
            LogUtils.addOperaLog("systemconfig.security.config.algorithm.selected", this.securityAlgorithmFailDev.values().stream().findFirst().get(), "");
            List<Callable<DevNode>> calls = this.securityAlgorithmFailDev.values().stream().map(x$0 -> new FetchDevNodeCall((DevNode)x$0)).collect(Collectors.toList());
            this.asyncAddDevices(calls, parent);
        }
    }

    private void processBatchResult(boolean isCertOk, boolean isHostKeyOk, boolean reConfirmAdd) {
        ConcurrentHashMap<DevNode, String> needAdd = new ConcurrentHashMap<DevNode, String>();
        ConcurrentHashMap<DevNode, String> notNeddAdd = new ConcurrentHashMap<DevNode, String>();
        if (reConfirmAdd) {
            needAdd.putAll(this.reConfirmAddMap);
        } else {
            notNeddAdd.putAll(this.reConfirmAddMap);
        }
        if (isHostKeyOk) {
            needAdd.putAll(this.hostKeyCheckMap);
        } else {
            notNeddAdd.putAll(this.hostKeyCheckMap);
        }
        if (isCertOk) {
            needAdd.putAll(this.certFailMap);
        } else {
            notNeddAdd.putAll(this.certFailMap);
        }
        for (DevNode curNode : notNeddAdd.keySet()) {
            this.checkDeldevNodes(curNode);
            needAdd.remove(curNode);
        }
        for (DevNode curNode : needAdd.keySet()) {
            this.checkAdddevNodes(curNode);
        }
    }

    private void addOkDevices() {
        for (DevNode curNode : this.ipRangeOkMap.keySet()) {
            this.checkAdddevNodes(curNode);
        }
    }

    private void clearTempData() {
        this.failedDeviceMap.clear();
        this.certFailMap.clear();
        this.hostKeyCheckMap.clear();
        this.reConfirmAddMap.clear();
        this.ipRangeOkMap.clear();
        this.needDebugPasswdMap.clear();
    }

    private void showDebugPasswdUnfilledTip() {
        if (!this.needDebugPasswdMap.isEmpty()) {
            SubDialogUtils.showMultiInfoDialog(this.parent, this.changeMap2UIArray(this.needDebugPasswdMap), true, ResourceUtil.getString((String)"devicemanager.layout.device.batch.need.debug.passwd"));
        }
    }

    private boolean saveFingerPrintDialog() {
        if (!this.hostKeyCheckMap.isEmpty()) {
            String userAlertinfo;
            ArrayList failFPDev = (ArrayList)this.changeMap2UIArray(this.hostKeyCheckMap);
            boolean isOKSelected = SubDialogUtils.showMultiInfoDialog(this.parent, failFPDev, true, userAlertinfo = ResourceUtil.getString((String)"ssh.adddevice.batch.alert"));
            if (isOKSelected) {
                Map<String, String> currHostkeyMap = this.convert2PropMap(this.hostKeyCheckMap);
                HostKeyCheckUtils.setFingerPrintProps(currHostkeyMap);
                return true;
            }
            for (DevNode curNode : this.hostKeyCheckMap.keySet()) {
                this.reConfirmAddMap.remove(curNode);
            }
            return false;
        }
        return false;
    }

    private boolean reConfirmInfoDialog() {
        if (!this.reConfirmAddMap.isEmpty()) {
            String userAlertinfo;
            ArrayList reConfirmAddFPDev = (ArrayList)this.changeMap2UIArray(this.reConfirmAddMap);
            boolean isOKSelected = SubDialogUtils.showMultiInfoDialog(this.parent, reConfirmAddFPDev, true, userAlertinfo = ResourceUtil.getString((String)"partial.support.adddevice.alert"));
            return isOKSelected;
        }
        return false;
    }

    private void checkAdddevNodes(DevNode curNode) {
        if (!DefaultNodeProviderImpl.getInstance().getNodeList().contains(curNode)) {
            this.deviceManageService.addDevNodeToDM(curNode);
        }
    }

    private void checkDeldevNodes(DevNode curNode) {
        if (DefaultNodeProviderImpl.getInstance().getNodeList().contains(curNode)) {
            try {
                DefaultNodeProviderImpl.getInstance().removeNode(curNode);
            }
            catch (ToolException e) {
                log.error("Exception happened in :", (Throwable)e);
            }
        }
    }

    private Map<String, String> convert2PropMap(ConcurrentHashMap<DevNode, String> hostKeyCheckHashMap) {
        HashMap<String, String> currResultMap = new HashMap<String, String>();
        for (Map.Entry<DevNode, String> entry : hostKeyCheckHashMap.entrySet()) {
            String currFPAllDesc = entry.getValue();
            int startIndex = currFPAllDesc.indexOf(":") + 1;
            int endIndex = currFPAllDesc.indexOf(",");
            endIndex = endIndex > 0 ? endIndex : currFPAllDesc.indexOf(".");
            String currFingerPrint = currFPAllDesc.substring(startIndex, endIndex);
            currResultMap.put(entry.getKey().getUid(), currFingerPrint);
        }
        return currResultMap;
    }

    private boolean showBatchCertFailedNode() {
        boolean isOKSelected;
        ArrayList failCertDev = (ArrayList)this.changeMap2UIArray(this.certFailMap);
        String userAlertinfo = ResourceUtil.getString((String)"certifcate.check.batch.invalid");
        if (!failCertDev.isEmpty() && !(isOKSelected = SubDialogUtils.showMultiInfoDialog(this.parent, failCertDev, true, userAlertinfo))) {
            for (DevNode curNode : this.certFailMap.keySet()) {
                this.hostKeyCheckMap.remove(curNode);
                this.reConfirmAddMap.remove(curNode);
            }
            return false;
        }
        CertCheckCfmUtils.setCertConfirmProps(this.trustDeviceCert(this.certFailMap));
        return true;
    }

    private Map<String, String> trustDeviceCert(ConcurrentHashMap<DevNode, String> certFailHashMap) {
        HashMap<String, String> trustCertMap = new HashMap<String, String>();
        for (DevNode curNode : certFailHashMap.keySet()) {
            trustCertMap.put(curNode.getDeviceSerialNumber(), String.valueOf(true));
        }
        return trustCertMap;
    }

    private void showBatchFailedNode() {
        ArrayList<List<Object>> failRet = new ArrayList<List<Object>>();
        this.addFailedNode(failRet, this.ipCheckInfoMap);
        this.addFailedNode(failRet, this.failedDeviceMap);
        this.handleFailedNode(failRet);
    }

    private void handleFailedNode(List<List<Object>> failRet) {
        if (!failRet.isEmpty()) {
            SubDialogUtils.showMultiInfoDialog(this.parent, ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.batcherror"), new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.ip"), ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.reason")}, failRet);
        }
    }

    private void addFailedNode(List<List<Object>> failRet, ConcurrentHashMap<String, String> failedDeviceHashMap) {
        for (Map.Entry<String, String> i : failedDeviceHashMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(i.getKey());
            tmp.add(i.getValue());
            failRet.add(tmp);
        }
    }

    private List<ArrayList<Object>> changeMap2UIArray(ConcurrentHashMap<DevNode, String> currMap) {
        ArrayList<ArrayList<Object>> failCertDev = new ArrayList<ArrayList<Object>>();
        for (Map.Entry<DevNode, String> i : currMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(i.getKey().getIp());
            tmp.add(i.getValue());
            failCertDev.add(tmp);
        }
        return failCertDev;
    }

    private DevNode createDev(String ip) {
        Object item;
        DevNode device = new DevNode();
        String username = this.layout.getUsername().getText();
        String password = String.valueOf(this.layout.getPassword().getPassword());
        int port = Integer.parseInt(this.layout.getPort().getText());
        device.setIp(ip);
        User user = new User(username, password);
        if (OPEN_API_USER.equals(username)) {
            device.setMetaVisionUser(user);
        }
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
        device.setLoginUser(user);
        device.setPort(port);
        device.setPriKey(this.layout.getCurKey());
        if (this.layout.getRootPwCheck().isSelected() && this.layout.getRootPwCheck().isVisible()) {
            this.setRootUser(device, port);
        }
        if (this.layout.getDeveloperCheck().isSelected()) {
            String devpwd = String.valueOf(this.layout.getDeveloperPwd().getPassword());
            device.setDeveloperPwd(devpwd);
            devpwd = null;
        }
        if (this.layout.getSelectSshForward().isSelected()) {
            item = this.layout.getSshRouteList().getItemAt(this.layout.getSshRouteList().getSelectedIndex());
            List nodes = (List)SettingService.getSshForwards().get(item);
            device.setSshName((String)item);
            device.setSshForwardList(nodes);
        }
        if (this.layout.getSelectSocks5().isSelected()) {
            item = this.layout.getSocks5List().getItemAt(this.layout.getSocks5List().getSelectedIndex());
            Socks5Proxy proxy = (Socks5Proxy)item;
            device.setSocks5Proxy(proxy);
        }
        ItDeviceType itDevTye = (ItDeviceType)this.getTypeSelectPanel().getItDevType().getSelectedItem();
        if (!DeviceDialogType.StorageOnly.equals((Object)this.dialogType)) {
            DeviceType dveType = (DeviceType)this.getTypeSelectPanel().getl2Type().getSelectedItem();
            device.setDevTypeLevel2(dveType);
            device.setItDeviceType(itDevTye);
        }
        if (itDevTye.equals((Object)ItDeviceType.COMPUTE_STORAGE)) {
            device.setItDeviceType(itDevTye);
            ComputeStorageDevNode computeStorageDevNode = new ComputeStorageDevNode();
            computeStorageDevNode.setOpenapiUser(user);
            computeStorageDevNode.setFcvIp(ip);
            device.setComputeStorageDevNode(computeStorageDevNode);
        }
        return device;
    }

    private DevNode createFusionCubeDev(String ip) {
        DevNode device = new DevNode();
        String password = String.valueOf(this.layout.getFusionCubeLayout().getDmPassword().getPassword());
        device.setIp(ip);
        User user = new User(this.layout.getFusionCubeLayout().getDmUsername().getText(), password);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
        device.setLoginUser(user);
        device.setPort(Integer.parseInt(this.layout.getFusionCubeLayout().getDmPort().getText()));
        String sshPassword = String.valueOf(this.layout.getFusionCubeLayout().getSshUserPassword().getPassword());
        device.setFusionCubeLoginUser(new User(this.layout.getFusionCubeLayout().getSshUsername().getText(), sshPassword));
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)sshPassword);
        String rootPassword = String.valueOf(this.layout.getFusionCubeLayout().getRootPassword().getPassword());
        device.setRootUser(new User(ROOT_USER, Base64EncodeUtils.encode((String)rootPassword)));
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)rootPassword);
        device.setFusionCubeSSHPort(Integer.parseInt(this.layout.getFusionCubeLayout().getSshPort().getText()));
        device.setItDeviceType(ItDeviceType.FUSIONCUBE);
        return device;
    }

    private DevNode createA3000Dev(String ip) {
        DevNode device = new DevNode();
        String password = String.valueOf(this.layout.getA3000Layout().getA3000Password().getPassword());
        device.setIp(ip);
        User user = new User(this.layout.getA3000Layout().getA3000LoginUser().getText(), password);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
        device.setLoginUser(user);
        device.setA3000LoginUser(user);
        device.setMetaVisionUser(user);
        device.setPort(Integer.parseInt(this.layout.getA3000Layout().getA3000Port().getText()));
        device.setItDeviceType(ItDeviceType.A3000);
        return device;
    }

    private void setRootUser(DevNode device, int port) {
        char[] pwdChars = this.layout.getRootPw().getPassword();
        String rootUserpdw = Base64EncodeUtils.encode((String)new String(pwdChars));
        Arrays.fill(pwdChars, ' ');
        if (!StringUtils.isNULLStr((String)rootUserpdw)) {
            User rUser = new User(ROOT_USER, rootUserpdw, port);
            device.setRootUser(rUser);
        }
    }

    private void add2FailList(String ip, String reason) {
        this.failedDeviceMap.put(ip, reason);
    }

    private void add2HostKeyMap(DevNode devNode, String reason) {
        this.hostKeyCheckMap.put(devNode, reason);
    }

    private void add2needDebugPasswdMap(DevNode devNode, String reason) {
        this.needDebugPasswdMap.put(devNode, reason);
    }

    private void add2CertFailMap(DevNode devNode, String reason) {
        this.certFailMap.put(devNode, reason);
    }

    private void add2ReConfirmAddMap(DevNode devNode, String reason) {
        this.reConfirmAddMap.put(devNode, reason);
    }

    private void add2IPRangeOkMap(DevNode devNode) {
        this.ipRangeOkMap.put(devNode, "IP Range OK");
    }

    private void asSyncGetNode() {
        if (!this.checkUserInputInfo()) {
            return;
        }
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)this, null, 290);
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor((ProgressDialog)progressDialog);
        this.setVisible(false);
        DeviceTypeQueryTask queryTypeTask = new DeviceTypeQueryTask((ProgressDialog)progressDialog);
        TaskResult result = taskExecutor.execute((ServiceTask)queryTypeTask);
        result = DeviceQueryErrorParser.parseErrorInfo(result);
        if (null != result) {
            if (result.getResult() == TaskResult.Result.FAILED) {
                if (SecurityConfigUtil.isOnlySecurityAlgorithm() && "ssh.connect.security.algorithm.error".equals(result.getErrorId())) {
                    DisclaimerDialog dialog = this.createDisclaimerDialog();
                    this.disclaimerDialogAction((DevNode)result.getResultObject(), dialog);
                    return;
                }
                this.dispose();
                this.initState();
                DialogUtils.showInfoDialog((Window)this.parent, (String)result.getErrorLocaleDescription());
                this.setVisible(true);
            } else {
                if (!this.busiCheckOne()) {
                    return;
                }
                if (this.checkDevCert(result)) {
                    if (!this.checkHostFingerPrint(result)) {
                        return;
                    }
                    if (!this.checkReConfirmAdd(result)) {
                        return;
                    }
                    if (result.getResultObject() != null && this.needDebugPasswd(result.getResultObject())) {
                        this.informDebugPasswdEntrance((DevNode)result.getResultObject());
                    }
                }
            }
        }
        log.error("queryTypeTask result is null");
    }

    private DisclaimerDialog createDisclaimerDialog() {
        DisclaimerDialog dialog = new DisclaimerDialog((Window)this, DisclaimerDialog.DisclaimerScene.DEVICE_ADD);
        dialog.setVisible(true);
        return dialog;
    }

    private void disclaimerDialogAction(DevNode node, DisclaimerDialog dialog) {
        if (dialog.isAccepted()) {
            SecurityConfigUtil.modifySecurityAlgorithmConfig((boolean)true);
            LogUtils.addOperaLog("systemconfig.security.config.algorithm.selected", node, "");
            this.asSyncGetNode();
        } else {
            dialog.dispose();
            this.dispose();
            this.initState();
            this.setVisible(true);
        }
    }

    private boolean needDialog() {
        return "true".equals(UserOpDataSaveUtil.getToolIniProp((String)"tool.debug.password.tips"));
    }

    private void informDebugPasswdEntrance(DevNode deviceNode) {
        boolean fromToolBox = ContextUtil.isInToolBox();
        if (fromToolBox || this.needDialog()) {
            String res = fromToolBox ? ResourceUtil.getString((String)"devicemanager.inform.debug.password.not.entered.fromtoolbox") : ResourceUtil.getString((String)"devicemanager.inform.debug.password.not.entered");
            DeviceModifyDialog deviceModifyDialog = new DeviceModifyDialog((Window)this, deviceNode, res);
            deviceModifyDialog.setModal(true);
            if (StringUtils.isNULLStr((String)deviceNode.getLoginUser().getPassword()) && null != deviceNode.getPriKey()) {
                deviceModifyDialog.setPasswordDisable();
            }
            deviceModifyDialog.setDebugPasswdFocused();
            deviceModifyDialog.setVisible(true);
        }
    }

    private boolean needDebugPasswd(Object resultObject) {
        DevNode deviceNode = (DevNode)resultObject;
        ProductParser parser = new ProductParser();
        Map<String, String> showInfos = parser.parse();
        if (StringUtils.isNULLStr((String)deviceNode.getDeveloperPwd()) && showInfos.containsKey(deviceNode.getDeviceType().toString())) {
            String softwareVersions = showInfos.get(deviceNode.getDeviceType().toString());
            for (String version : softwareVersions.split(",")) {
                if (!deviceNode.getProductVersion().contains(version)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean busiCheckOne() {
        boolean ispass = true;
        try {
            int checkflag;
            String[] ret = DefaultNodeProviderImpl.getInstance().fireNodeAddChk(this.currNode);
            if (ret.length > 0 && ((checkflag = Integer.parseInt(ret[0])) == 0 || checkflag == 2)) {
                DialogUtils.showInfoDialog((Window)this.parent, (String)ret[1]);
                ispass = false;
            }
        }
        catch (ToolException e) {
            log.error("fire node check fail.", (Throwable)e);
            String msg = ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.can.not.query.dev.type");
            DialogUtils.showInfoDialog((Window)this.parent, (String)msg);
            ispass = false;
        }
        return ispass;
    }

    private boolean checkDevCert(TaskResult result) {
        if (null != result && result.isNeedCertWarn()) {
            WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"certifcate.check.invalid"));
            int userChoice = wd.getValue();
            try {
                if (0 != userChoice) {
                    DefaultNodeProviderImpl.getInstance().removeNode(this.currNode);
                    log.info("remove untrusted dev: {} ", (Object)this.currNode.getUid());
                    this.dispose();
                    return false;
                }
                CertCheckCfmUtils.setCertConfirmProp(this.currNode.getDeviceSerialNumber(), String.valueOf(true));
                this.currNode.setVerifyCertificate(false);
                log.info("choose to add untrusted dev: {}", (Object)this.currNode.getUid());
            }
            catch (Exception e) {
                log.error("add dev error!", (Throwable)e);
            }
        }
        return true;
    }

    private boolean checkReConfirmAdd(TaskResult result) {
        if (result.hasConfirmInfo()) {
            String currAlertInfo = result.getAddConfirmInfo();
            WarningDialog warn = DialogUtils.showYesNoDialog((Window)this.parent, (String)currAlertInfo, (boolean)true);
            if (0 == warn.getValue()) {
                this.checkAdddevNodes(this.currNode);
                this.dispose();
                return true;
            }
            this.checkDeldevNodes(this.currNode);
            this.dispose();
            return false;
        }
        this.checkAdddevNodes(this.currNode);
        this.dispose();
        return true;
    }

    private boolean checkHostFingerPrint(TaskResult result) {
        String currIp = this.layout.getIpAddress().getText();
        if (!SshKnownHostsManager.isHostAdded((String)currIp) || !SshKnownHostsManager.getHostKeyInfo((String)currIp).equals(result.getPublicKeyInfo())) {
            return this.showFingerPrintCheckDialog(result);
        }
        return true;
    }

    private boolean showFingerPrintCheckDialog(TaskResult result) {
        if (result.getFingerPrint() == null) {
            this.checkReConfirmAdd(result);
            log.info("FingerPrint is null");
            return false;
        }
        if (!ApplicationContext.getInstance().isVerifySshHostKeyForStorage()) {
            return true;
        }
        String currAlertInfo = ResourceUtil.getStringWithParams((String)"ssh.adddevice.publickey.info.alert", (Object[])new Object[]{result.getFingerPrint()});
        WarningDialog warn = DialogUtils.showYesNoDialog((Window)this.parent, (String)currAlertInfo, (String)ResourceUtil.getString((String)"ssh.adddevice.publickey.info.trusting"), (String)ResourceUtil.getString((String)"ssh.adddevice.publickey.info.ignore"), (int)60, (int)60);
        if (0 == warn.getValue() && !VerifyUtil.isEmpty((String)result.getPublicKeyInfo())) {
            SshKnownHostsManager.cacheHostKey((String)this.layout.getIpAddress().getText(), (String)result.getPublicKeyInfo());
            SshKnownHostsManager.cacheHostKeyInfoVerifyFlag((String)this.layout.getIpAddress().getText(), (boolean)true);
            this.currNode.setVerifySshHostKey(true);
            this.currNode.setSshHostKey(result.getPublicKeyInfo());
            HashMap<String, String> currResultMap = new HashMap<String, String>();
            currResultMap.put(this.layout.getIpAddress().getText(), result.getFingerPrint());
            HostKeyCheckUtils.setFingerPrintProps(currResultMap);
            return true;
        }
        this.checkDeldevNodes(this.currNode);
        return false;
    }

    private TaskResult getDevice(ProgressDialog progressDialog) {
        DevNode devNode;
        ItDeviceType deviceType = (ItDeviceType)this.getTypeSelectPanel().getItDevType().getSelectedItem();
        if (ItDeviceType.FUSIONCUBE.equals((Object)deviceType)) {
            devNode = this.layout.getFusionCubeLayout().createFusionCubeDev();
            devNode.setCertCheckSelectFlag(this.layout.getFusionCubeLayout().getYesAndNoButtonPanel().isSelectedYes());
        } else if (ItDeviceType.A3000.equals((Object)deviceType)) {
            devNode = this.createA3000Dev(this.layout.getA3000Layout().getIpAddress().getText());
            devNode.setCertCheckSelectFlag(this.layout.getA3000Layout().getYesAndNoButtonPanel().isSelectedYes());
        } else {
            devNode = this.createDev(this.layout.getIpAddress().getText());
            devNode.setCertCheckSelectFlag(this.layout.getYesAndNoButtonPanel().isSelectedYes());
        }
        devNode.setOnlySecurityAlgorithm(SecurityConfigUtil.isOnlySecurityAlgorithm());
        long startTime = System.currentTimeMillis();
        TaskResult result = this.deviceManageService.addDeviceParallel(progressDialog, devNode, true);
        this.recordAddTime(devNode, startTime, result);
        this.currNode = devNode;
        return this.handleTaskResult(devNode, result);
    }

    private TaskResult handleTaskResult(DevNode dev, TaskResult result) {
        if (null == result) {
            log.error("Result is null");
            TaskResult ret = new TaskResult();
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)dev);
            return ret;
        }
        if (result.getResultObject() == null) {
            result.setResultObject((Object)dev);
        }
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            LogUtils.addOperaLog("operalog.name.adddevice", dev, result, "");
        } else {
            LogUtils.addOperaLog("operalog.name.adddevice", dev, result, result.getErrorId());
        }
        return result;
    }

    private void recordAddTime(DevNode dev, long sTime, TaskResult result) {
        log.info(com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)("add dev version:" + dev.getProductVersion() + " devIp" + dev.getUid() + " takes time:" + (System.currentTimeMillis() - sTime) + " taskResult:" + (result == null ? null : result.getResult()))));
    }

    private void recordAddTime(long time) {
        StringBuilder failVersion = new StringBuilder();
        String ipRangeNotOkVersion = this.getDeviceIp(this.hostKeyCheckMap);
        String ipRangeOkVersion = this.getDeviceIp(this.ipRangeOkMap);
        for (Map.Entry<String, String> i : this.failedDeviceMap.entrySet()) {
            failVersion.append(i.getKey()).append(",");
        }
        log.info("add dev versions:" + " success versions:" + ipRangeNotOkVersion + ipRangeOkVersion + " fail versions:" + failVersion + " taskResult:" + time);
    }

    private String getDeviceIp(Map<DevNode, String> devMaps) {
        StringBuilder builder = new StringBuilder();
        for (DevNode dev : devMaps.keySet()) {
            builder.append(dev.getUid()).append(",");
        }
        return builder.toString().isEmpty() ? " " : builder.toString();
    }

    private boolean checkUserInputInfo() {
        ItDeviceType deviceType = (ItDeviceType)this.layout.getDevTypePane().getItDevType().getSelectedItem();
        if (ItDeviceType.FUSIONCUBE.equals((Object)deviceType)) {
            return this.validFusionCubeInput();
        }
        if (ItDeviceType.A3000.equals((Object)deviceType)) {
            return this.validA3000Input();
        }
        String username = this.layout.getUsername().getText();
        String ipAddress = this.layout.getIpAddress().getText();
        String port = this.layout.getPort().getText();
        boolean hasNull = this.isHasNullProp(username, String.valueOf(this.layout.getPassword().getPassword()), port);
        if (!this.checkIsLogOnRoot(username)) {
            return false;
        }
        if (hasNull) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)(this.layout.getAuthType().equals((Object)AuthType.KEY) ? "devicemanager.layout.device.add.deviceadddialog.deviceinfoblank.key" : "devicemanager.layout.device.add.deviceadddialog.deviceinfoblank")));
            return false;
        }
        if (this.layout.keyInfoVisible() && ResourceUtil.getString((String)"device.adddialog.key.bank").equals(this.layout.getKeyCombo().getSelectedItem().toString())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"device.adddialog.key.select.null"));
            return false;
        }
        if (this.layout.getDeveloperCheck().isSelected()) {
            String devPass = String.valueOf(this.layout.getDeveloperPwd().getPassword());
            boolean isNullStr = StringUtils.isNULLStr((String)devPass);
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)devPass);
            if (isNullStr) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.inputnull"));
                return false;
            }
        }
        if (!this.isRootPwdValid()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.switch.need.root.pwd.info"));
            return false;
        }
        if (Integer.parseInt(port) > 65535 || Integer.parseInt(port) <= 0) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
            return false;
        }
        DevNode node = new DevNode();
        node.setIp(ipAddress);
        if (this.deviceManageService.isDevNodeExist(node)) {
            String msg = ResourceUtil.getStringWithParams((String)this.tips.getDuplicateTipsKey(), (Object[])new Object[]{ipAddress});
            DialogUtils.showInfoDialog((JDialog)this, (String)msg);
            return false;
        }
        return true;
    }

    private boolean validFusionCubeInput() {
        boolean validEmptyInputRet;
        boolean bl = validEmptyInputRet = SwingUtil.validateHintTextInput(this.layout.getFusionCubeLayout().getTextChecktInputs(), (Window)this) && SwingUtil.validatePwdInput(this.layout.getFusionCubeLayout().getPasswordCheckInputs(), (Window)this);
        if (!validEmptyInputRet) {
            return false;
        }
        String sshPort = this.layout.getFusionCubeLayout().getSshPort().getText();
        if (Integer.parseInt(sshPort) > 65535 || Integer.parseInt(sshPort) <= 0) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
            return false;
        }
        return true;
    }

    private boolean validA3000Input() {
        boolean validEmptyInputRet;
        boolean bl = validEmptyInputRet = SwingUtil.validateHintTextInput(this.layout.getA3000Layout().getHintTextCheckInputs(), (Window)this) && SwingUtil.validatePwdInput(this.layout.getA3000Layout().getPasswordCheckInputs(), (Window)this);
        if (!validEmptyInputRet) {
            return false;
        }
        String openApiPort = this.layout.getA3000Layout().getA3000Port().getText();
        if (Integer.parseInt(openApiPort) > 65535 || Integer.parseInt(openApiPort) <= 0) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
            return false;
        }
        return true;
    }

    public boolean checkIsLogOnRoot(String username) {
        if (ItDeviceType.Host.equals((Object)this.layout.getDevTypePane().getItDevTypeEnum()) || ItDeviceType.FUIONSTOR_EXP_NEW_NODE.equals((Object)this.layout.getDevTypePane().getItDevTypeEnum())) {
            Object object = this.layout.getDevTypePane().getl2Type().getSelectedItem();
            if (object == null || object.toString().equalsIgnoreCase("Windows")) {
                return true;
            }
            boolean isVMware = object.toString().equalsIgnoreCase("VMware");
            if (isVMware && !ROOT_USER.equals(username)) {
                return this.checkVMwareLog();
            }
        }
        return true;
    }

    private boolean checkVMwareLog() {
        String toolName = ApplicationContext.getInstance().getToolTypeName();
        log.info("toolName:" + toolName);
        if ("inspector".equals(toolName)) {
            WarningDialog warning = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.root.prompt1.username.txt.inspector"));
            return warning.getValue() == 0;
        }
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.root.prompt1.username.txt"));
        return false;
    }

    private boolean isRootPwdValid() {
        char[] pwdChars;
        String pass;
        return !this.layout.getRootPwCheck().isSelected() || !this.layout.getRootPwCheck().isVisible() || !StringUtils.hasNULLStr((String[])new String[]{pass = Base64EncodeUtils.encode((String)new String(pwdChars = this.layout.getRootPw().getPassword()))});
    }

    private boolean isHasNullProp(String username, String password, String port) {
        boolean hasNull = this.layout.getAuthType().equals((Object)AuthType.KEY) ? StringUtils.hasNULLStr((String[])new String[]{username, port}) : StringUtils.hasNULLStr((String[])new String[]{username, password, port});
        return hasNull;
    }

    public void setAuthType(AuthType selType) {
        this.layout.setAuthType(selType);
    }

    public AuthType getAuthType() {
        return this.layout.getAuthType();
    }

    public void onStepDialogDisplayed() {
        AutoProcessConfig config = AutoProcessConfig.getInstance();
        this.layout.getIpAddress().setText(config.getIp());
        this.layout.getNextBtn().doClick();
        this.layout.getUsername().setText(config.getUserName());
        this.layout.getPassword().setText(config.getUserPassword());
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    public void onStepFinished(AutoProcessStatus status) {
        this.layout.getNextBtn().doClick();
    }

    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    public static class InfoTips {
        private String duplicateTipsKey;

        public InfoTips(String duplicateTipsKey) {
            this.duplicateTipsKey = duplicateTipsKey;
        }

        public String getDuplicateTipsKey() {
            return this.duplicateTipsKey;
        }
    }

    private class DeviceTypeQueryTask
    extends ServiceTask {
        private ProgressDialog progressDialog;

        public DeviceTypeQueryTask(ProgressDialog progressDialog) {
            this.progressDialog = progressDialog;
        }

        protected TaskResult doTask() {
            return DeviceAddDialog.this.getDevice(this.progressDialog);
        }
    }

    protected class FetchDevNodeCall
    implements Callable<DevNode> {
        private DevNode device;

        public FetchDevNodeCall(DevNode info) {
            this.device = info;
        }

        private void queryDev() throws ToolException {
            TaskResult result = null;
            this.device.setOnlySecurityAlgorithm(SecurityConfigUtil.isOnlySecurityAlgorithm());
            result = ItDeviceType.Storage.equals((Object)this.device.getItDeviceType()) ? DeviceAddDialog.this.deviceManageService.addDeviceParallel(null, this.device, true) : (ItDeviceType.COMPUTE_STORAGE.equals((Object)this.device.getStorageDeviceType()) ? DeviceAddDialog.this.deviceManageService.addDeviceByFcv(this.device) : (this.device.getItDeviceType() == ItDeviceType.DPA ? DeviceAddDialog.this.deviceManageService.addDpaDevice(this.device) : (ItDeviceType.DStorage.equals((Object)this.device.getItDeviceType()) ? DeviceAddDialog.this.deviceManageService.addDeviceByRest(this.device) : (ItDeviceType.FUSIONCUBE.equals((Object)this.device.getItDeviceType()) ? DeviceAddDialog.this.deviceManageService.addDeviceByRest(this.device) : (ItDeviceType.A3000.equals((Object)this.device.getItDeviceType()) ? DeviceAddDialog.this.deviceManageService.addDeviceByRest(this.device) : DeviceAddDialog.this.deviceManageService.addDeviceBySsh(this.device, true))))));
            if (result == null) {
                throw new ToolException("result is null.");
            }
            result = DeviceQueryErrorParser.parseErrorInfo(result);
            this.addOperaLog(result);
            this.fillAddFailedMap(result);
            this.handleAlgorithmFailDevs(result);
            this.popCertCheck(result);
            this.popHostKeyCheck(result);
            this.popReConfirmAddCheck(result);
            this.popIPRangeOkDev(result);
            this.popUpNeedDebugDevs(result);
        }

        private void handleAlgorithmFailDevs(TaskResult result) {
            if (result != null && "ssh.connect.security.algorithm.error".equals(result.getErrorId())) {
                DeviceAddDialog.this.securityAlgorithmFailDev.put(this.device.getIp(), this.device);
            }
        }

        private void popUpNeedDebugDevs(TaskResult result) {
            if (result.getResultObject() != null && DeviceAddDialog.this.needDebugPasswd(result.getResultObject())) {
                DevNode devNode = (DevNode)result.getResultObject();
                DeviceAddDialog.this.add2needDebugPasswdMap(devNode, ResourceUtil.getString((String)"devicemanager.layout.device.need.debug.passwd"));
            }
        }

        private void busiCheckOne() {
            try {
                if (DeviceAddDialog.this.failedDeviceMap.containsKey(this.device)) {
                    return;
                }
                int checkflag = 1;
                String[] ret = DefaultNodeProviderImpl.getInstance().fireNodeAddChk(this.device);
                if (ret.length > 0 && ((checkflag = Integer.parseInt(ret[0])) == 0 || checkflag == 2)) {
                    DeviceAddDialog.this.add2FailList(this.device.getUid(), ret[1]);
                    DeviceAddDialog.this.hostKeyCheckMap.remove(this.device);
                    DeviceAddDialog.this.certFailMap.remove(this.device);
                    DeviceAddDialog.this.reConfirmAddMap.remove(this.device);
                    DeviceAddDialog.this.ipRangeOkMap.remove(this.device);
                    DeviceAddDialog.this.needDebugPasswdMap.remove(this.device);
                }
            }
            catch (ToolException e) {
                log.error("fire node check fail.", (Throwable)e);
            }
        }

        private void addOperaLog(TaskResult result) {
            if (null == result) {
                throw new NullPointerException("Result is null");
            }
            String reason = result.getErrorId();
            if (result.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
                reason = "";
            }
            LogUtils.addOperaLog("operalog.name.adddevices", this.device, result, reason);
        }

        private void fillAddFailedMap(TaskResult result) {
            if (null != result && result.getResult() == TaskResult.Result.FAILED) {
                DeviceAddDialog.this.add2FailList(this.device.getUid(), result.getErrorLocaleDescription());
                log.error("Call not query device info,ip: " + this.device.getUid());
            }
        }

        private void popCertCheck(TaskResult result) {
            if (!DeviceAddDialog.this.failedDeviceMap.containsKey(this.device.getUid()) && null != result && result.isNeedCertWarn()) {
                DeviceAddDialog.this.add2CertFailMap(this.device, ResourceUtil.getStringWithParams((String)"certifcate.check.simply.invalid", (Object[])new Object[0]));
            }
        }

        private void popReConfirmAddCheck(TaskResult result) {
            if (!DeviceAddDialog.this.failedDeviceMap.containsKey(this.device.getUid()) && null != result && result.hasConfirmInfo()) {
                DeviceAddDialog.this.add2ReConfirmAddMap(this.device, result.getAddConfirmInfo());
            }
        }

        private void popHostKeyCheck(TaskResult result) {
            String fingerPrint = result.getFingerPrint();
            if (StringUtils.isNULLStr((String)fingerPrint)) {
                return;
            }
            if (DeviceAddDialog.this.failedDeviceMap.containsKey(this.device.getUid())) {
                log.info("Connect is ok but query dev info erro,do not show hostkey info.");
                return;
            }
            String currIP = this.device.getUid();
            Properties fingerProperties = HostKeyCheckUtils.getFingerPrintProp();
            if (!fingerProperties.containsKey(currIP) || !fingerProperties.get(currIP).equals(fingerPrint)) {
                DeviceAddDialog.this.add2HostKeyMap(this.device, ResourceUtil.getStringWithParams((String)"ssh.adddevice.simply.alert", (Object[])new Object[]{result.getFingerPrint()}));
            }
        }

        private void popIPRangeOkDev(TaskResult result) {
            if (!(TaskResult.Result.FAILED.equals((Object)result.getResult()) || DeviceAddDialog.this.failedDeviceMap.containsKey(this.device.getUid()) || DeviceAddDialog.this.hostKeyCheckMap.containsKey(this.device) || DeviceAddDialog.this.certFailMap.containsKey(this.device) || DeviceAddDialog.this.reConfirmAddMap.containsKey(this.device))) {
                DeviceAddDialog.this.add2IPRangeOkMap(this.device);
            }
        }

        @Override
        public DevNode call() {
            try {
                this.queryDev();
                this.busiCheckOne();
            }
            catch (ToolException e) {
                log.error("Query device info error,ip: " + this.device.getUid());
            }
            return null;
        }
    }

    private class SelectSockes5Action
    implements ActionListener {
        private SelectSockes5Action() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String msg;
            WarningDialog wrDlg;
            if (0 == DeviceAddDialog.this.layout.getSocks5List().getModel().getSize() && 0 == (wrDlg = DialogUtils.showYesNoDialog((Window)DeviceAddDialog.this, (String)(msg = ResourceUtil.getString((String)"device.adddialog.proxysetting.nosocks5.config")))).getValue()) {
                SettingService.showSettingDialog(DeviceAddDialog.this, SettingType.Socks5Proxy);
                DeviceAddDialog.this.initSocks5Data();
            }
            if (0 == DeviceAddDialog.this.layout.getSocks5List().getModel().getSize()) {
                DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
            }
        }
    }

    private class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (DeviceAddDialog.this.layout.getTabState() == 2 || DeviceAddDialog.this.layout.getTabState() == 3 || DeviceAddDialog.this.layout.getTabState() == 4) {
                DeviceAddDialog.this.processAdd();
                DeviceAddDialog.this.layout.getUsername().requestFocus();
                return;
            }
            boolean rootFlag = !DeviceAddDialog.this.layout.getUsername().getText().isEmpty() && !DeviceAddDialog.ROOT_USER.equalsIgnoreCase(DeviceAddDialog.this.layout.getUsername().getText());
            DeviceAddDialog.this.layout.setRootPwVisible(DeviceAddDialog.this.needCheckSwitchRoot() && rootFlag);
            DeviceAddDialog.this.changeRootLoginPloicy();
            if (DeviceAddDialog.this.layout.getAssignIpRadio().isSelected()) {
                String ipAddress = DeviceAddDialog.this.layout.getIpAddress().getText();
                if (StringUtils.hasNULLStr((String[])new String[]{ipAddress})) {
                    DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceinfoipblank"));
                    return;
                }
                if (!NetUtil.isValidIP((String)ipAddress)) {
                    DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror"));
                    return;
                }
            } else if (!this.checkOnIpRangeAdd()) {
                return;
            }
            DeviceAddDialog.this.layout.setTabState(2);
            DeviceAddDialog.this.initState();
        }

        private boolean checkOnIpRangeAdd() {
            String endIpAddress;
            String startIpAddress = DeviceAddDialog.this.layout.getStartIpAddress().getText();
            if (StringUtils.hasNULLStr((String[])new String[]{startIpAddress, endIpAddress = DeviceAddDialog.this.layout.getEndIpAddress().getText()})) {
                DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.iprangeipblank"));
                return false;
            }
            if (!NetUtil.isValidIP((String)startIpAddress) || !NetUtil.isValidIP((String)endIpAddress)) {
                DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror"));
                return false;
            }
            String result = DeviceAddIpCheck.getInstance().ipIpRangeInvalid(startIpAddress, endIpAddress);
            if (!StringUtils.isNULLStr((String)result)) {
                DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)result);
                return false;
            }
            return true;
        }
    }

    private class ForwardAction
    implements ActionListener {
        private ForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String msg;
            WarningDialog wrDlg;
            if (0 == DeviceAddDialog.this.layout.getSshRouteList().getModel().getSize() && 0 == (wrDlg = DialogUtils.showYesNoDialog((Window)DeviceAddDialog.this, (String)(msg = ResourceUtil.getString((String)"device.adddialog.proxysetting.nomoreroute.config")))).getValue()) {
                SettingService.showSettingDialog(DeviceAddDialog.this, SettingType.SshForward);
                DeviceAddDialog.this.initSshData();
            }
            if (0 == DeviceAddDialog.this.layout.getSshRouteList().getModel().getSize()) {
                DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
            }
        }
    }

    public class DownLoadActionAdapter
    extends MouseAdapter {
        private DeviceAddDialog dialog;

        public DownLoadActionAdapter(DeviceAddDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            String defaultFileName;
            String suffix;
            if (!DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()) {
                return;
            }
            String title = ResourceUtil.getString((String)"infograb.layout.device.downloadtemplate.path");
            String filePath = ToolFileChooser.getSaveFilePath((String)title, (String)(suffix = "xls"), (Window)this.dialog, (String)(defaultFileName = DeviceAddDialog.TEMPLATE_FILE_NAME), (String)DeviceAddDialog.SAVEPATH_DEFAULT_ID);
            if (null == filePath) {
                return;
            }
            if (DeviceAddDialog.this.writeTemplateFile2Local(filePath)) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infograb.save.success"));
                LogUtils.addImportLog("infograb.layout.device.import.downloadtemplate", "Smartkit", true);
            }
        }
    }
}

