/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public final class DeviceAddIpCheck {
    private static final DeviceAddIpCheck INSTANCE = new DeviceAddIpCheck();

    private DeviceAddIpCheck() {
    }

    public static DeviceAddIpCheck getInstance() {
        return INSTANCE;
    }

    public String ipIpRangeInvalid(String startIP, String endIP) {
        String result = "";
        if (NetUtil.isValidIPV4((String)startIP) && NetUtil.isValidIPV4((String)endIP)) {
            if (this.checkIpV4Range(startIP, endIP) == -100) {
                result = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipsameneterror");
                return result;
            }
            if (this.checkIpV4Range(startIP, endIP) <= 0) {
                result = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.iprangeerror");
                return result;
            }
        } else if (NetUtil.isValidIPV6((String)startIP) && NetUtil.isValidIPV6((String)endIP)) {
            BigInteger startIPNum = NetUtil.ipv6Str2Int((String)startIP);
            BigInteger endIPNum = NetUtil.ipv6Str2Int((String)endIP);
            if (null == startIPNum || null == endIPNum) {
                throw new NullPointerException();
            }
            if (endIPNum.compareTo(startIPNum) <= 0) {
                result = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.iprangeerror");
            }
        } else {
            result = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror");
        }
        return result;
    }

    public int checkIpV4Range(String startIp, String endIp) {
        String[] endArr;
        String[] startArr = startIp.split("\\.");
        if (startArr.length != (endArr = endIp.split("\\.")).length) {
            throw new IllegalArgumentException("ip length not equals");
        }
        int singum = 0;
        for (int i = 0; i < 4; ++i) {
            int start = StringUtils.str2Int((String)startArr[i]);
            int end = StringUtils.str2Int((String)endArr[i]);
            if (i <= 2 && start != end) {
                return -100;
            }
            if (i != 3) continue;
            singum = end - start;
        }
        return (int)Math.signum(singum);
    }

    public List<String> constructIpSegs(String startIp, String endIp) {
        ArrayList<String> allIps = new ArrayList<String>();
        String actualStartIp = startIp;
        String actualEndIp = endIp;
        if (!NetUtil.isValidIPV4((String)actualStartIp) && !NetUtil.isValidIPV4((String)actualEndIp)) {
            String startIpTmp = "";
            String endIpTmp = "";
            try {
                startIpTmp = InetAddress.getByName(actualStartIp).getHostAddress();
                endIpTmp = InetAddress.getByName(actualEndIp).getHostAddress();
            }
            catch (UnknownHostException e) {
                LoggerFactory.getLogger(DeviceAddIpCheck.class).error("constructIpSegs error.", (Throwable)e);
                return allIps;
            }
            if (!NetUtil.isValidIPV4((String)startIpTmp) && !NetUtil.isValidIPV4((String)endIpTmp)) {
                actualStartIp = startIpTmp;
                actualEndIp = endIpTmp;
            }
        }
        int end = this.getIpSeg(actualEndIp);
        for (int start = this.getIpSeg(actualStartIp); start <= end; ++start) {
            String ipAddress = this.constructNewIpAddr(actualStartIp, start);
            allIps.add(ipAddress);
        }
        return allIps;
    }

    private int getIpSeg(String ipAddr) {
        if (NetUtil.isValidIPV4((String)ipAddr)) {
            return StringUtils.str2Int((String)ipAddr.split("\\.")[3]);
        }
        int symIndex = ipAddr.lastIndexOf(":") + 1;
        String lastSeg = ipAddr.substring(symIndex);
        if (NetUtil.isValidIPV4((String)lastSeg)) {
            return this.getIpSeg(lastSeg);
        }
        return Integer.parseInt(ipAddr.substring(symIndex), 16);
    }

    private String constructNewIpAddr(String ip, int lastSeg) {
        if (NetUtil.isValidIPV4((String)ip)) {
            return this.getIpSubNet(ip) + lastSeg;
        }
        int symIndex = ip.lastIndexOf(":") + 1;
        String ipv4Add = ip.substring(symIndex);
        if (NetUtil.isValidIPV4((String)ipv4Add)) {
            return this.getIpSubNet(ip) + this.getIpSubNet(ipv4Add) + lastSeg;
        }
        return this.getIpSubNet(ip) + Integer.toHexString(lastSeg).toLowerCase(Locale.ENGLISH);
    }

    private String getIpSubNet(String ip) {
        if (StringUtils.isIpv6Address((String)ip)) {
            return ip.substring(0, ip.lastIndexOf(58) + 1);
        }
        return ip.substring(0, ip.lastIndexOf(46) + 1);
    }
}

