/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddLayout;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeviceTypePaneLayout
extends JPanel {
    private static final long serialVersionUID = 410327757028784211L;
    private final JComboBox<ItDeviceType> itDevType = new JComboBox();
    private final JComboBox<DeviceType> l2Type = new JComboBox();
    private List<ItDeviceType> itDeviceList;
    private Map<ItDeviceType, List<String>> deviceTypel2;
    private final Dimension l2typeDimensioin = new Dimension(100, 20);
    private DeviceAddLayout parent;
    private OnDeviceTypeItemChangeListener listener;

    public DeviceTypePaneLayout(DeviceAddLayout parent) {
        this.parent = parent;
        this.initComponent();
        this.initUI();
        this.bondListener();
    }

    public DeviceTypePaneLayout(DeviceAddLayout parent, List<ItDeviceType> deviceTypes) {
        this.parent = parent;
        this.itDeviceList = new ArrayList<ItDeviceType>();
        this.deviceTypel2 = new HashMap<ItDeviceType, List<String>>();
        this.itDeviceList.addAll(deviceTypes);
        this.initComponent();
        this.initUI();
        this.bondListener();
    }

    public DeviceTypePaneLayout(List<ItDeviceType> deviceTypes) {
        this.itDeviceList = new ArrayList<ItDeviceType>();
        this.deviceTypel2 = new HashMap<ItDeviceType, List<String>>();
        this.itDeviceList.addAll(deviceTypes);
        this.initComponent();
        this.initUI();
        this.bondListener();
    }

    private void bondListener() {
        this.itDevType.addItemListener(event -> {
            Object selectItem;
            this.changel2View();
            this.resetDeveloperPwd4Host();
            if (this.listener != null && (selectItem = this.itDevType.getSelectedItem()) instanceof ItDeviceType) {
                this.listener.onDeviceTypeItemSelected((ItDeviceType)selectItem);
            }
        });
    }

    private void changel2View() {
        ItDeviceType type = (ItDeviceType)this.itDevType.getSelectedItem();
        this.l2Type.removeAllItems();
        List<String> l2Types = this.deviceTypel2.get(type);
        if (l2Types == null) {
            this.l2Type.setVisible(false);
        } else {
            for (String l2TypeStr : l2Types) {
                this.l2Type.addItem(DeviceType.valueOf((String)l2TypeStr));
            }
            this.l2Type.setVisible(true);
        }
    }

    private void resetDeveloperPwd4Host() {
        ItDeviceType type = (ItDeviceType)this.itDevType.getSelectedItem();
        if (ItDeviceType.Host.equals((Object)type) && Objects.nonNull(this.parent)) {
            this.parent.getDeveloperPwd().setText("");
            this.parent.getDeveloperCheck().setSelected(false);
        }
    }

    private void initComponent() {
        if (this.itDeviceList == null || this.itDeviceList.isEmpty()) {
            this.fullfillItDeviceTypel2();
        }
        this.itDevType.removeAllItems();
        for (ItDeviceType itType : this.itDeviceList) {
            this.itDevType.addItem(itType);
        }
        this.l2Type.setPreferredSize(this.l2typeDimensioin);
        this.l2Type.setVisible(this.deviceTypel2.get(this.itDevType.getSelectedItem()) != null);
    }

    private void fullfillItDeviceTypel2() {
        this.itDeviceList = new LinkedList<ItDeviceType>();
        this.itDeviceList.add(ItDeviceType.Storage);
        this.itDeviceList.add(ItDeviceType.Switch);
        this.itDeviceList.add(ItDeviceType.Host);
        this.itDeviceList.add(ItDeviceType.Database);
        LinkedList<String> hostdeviceTypeL2 = new LinkedList<String>();
        hostdeviceTypeL2.add("Linux");
        hostdeviceTypeL2.add("AIX");
        hostdeviceTypeL2.add("HP-UX");
        hostdeviceTypeL2.add("Solaris");
        hostdeviceTypeL2.add("VMware");
        LinkedList<String> dataBasedeviceTypeL2 = new LinkedList<String>();
        dataBasedeviceTypeL2.add("Oracle");
        dataBasedeviceTypeL2.add("DB2");
        dataBasedeviceTypeL2.add("MySQL");
        dataBasedeviceTypeL2.add("SQLServer");
        dataBasedeviceTypeL2.add("Sybase");
        this.deviceTypel2 = new HashMap<ItDeviceType, List<String>>();
        this.deviceTypel2.put(ItDeviceType.Host, hostdeviceTypeL2);
        this.deviceTypel2.put(ItDeviceType.Database, dataBasedeviceTypeL2);
    }

    public List<ItDeviceType> getItDeviceList() {
        return this.itDeviceList;
    }

    public Map<ItDeviceType, List<String>> getDeviceTypel2() {
        return this.deviceTypel2;
    }

    private void initUI() {
        JLabel typeLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceType"));
        JComponent box = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), typeLabel, this.itDevType, this.l2Type, Box.createHorizontalStrut(1)});
        this.setLayout(new BorderLayout());
        this.add((Component)box, "West");
        this.setCompName();
    }

    public JComboBox<ItDeviceType> getItDevType() {
        return this.itDevType;
    }

    public ItDeviceType getItDevTypeEnum() {
        return (ItDeviceType)this.itDevType.getSelectedItem();
    }

    public JComboBox<DeviceType> getl2Type() {
        return this.l2Type;
    }

    private void setItDeviceList(List<ItDeviceType> itDeviceList) {
        this.itDeviceList = itDeviceList;
    }

    private void setDeviceTypel2(Map<ItDeviceType, List<String>> deviceTypel2) {
        this.deviceTypel2 = deviceTypel2;
    }

    public void setItDeviceTypel2(List<ItDeviceType> itDevice1List, Map<ItDeviceType, List<String>> deviceTypel2Map) {
        this.setItDeviceList(itDevice1List);
        this.setDeviceTypel2(deviceTypel2Map);
        this.initComponent();
    }

    public void setCompName() {
        this.itDevType.setName("_Combo_itDevType");
        this.l2Type.setName("_Combo_l2Type");
    }

    public void addDeviceTypeItemChangeListener(OnDeviceTypeItemChangeListener listener) {
        this.listener = listener;
    }

    public static interface OnDeviceTypeItemChangeListener {
        public void onDeviceTypeItemSelected(ItDeviceType var1);
    }
}

