/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.ui.dialog.InputLoginInfoDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.component.AuthInfoInputPanel;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputLoginInfoLayout
extends JPanel
implements DialogsConstants {
    private static final Logger log = LoggerFactory.getLogger(InputLoginInfoLayout.class);
    private final AuthInfoInputPanel authInfoInputPanel = new AuthInfoInputPanel();
    private final JButton confirmButton = UiMethod.createButton((String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.confirm"));
    private final JButton cancelButton = UiMethod.createButton((String)ResourceUtil.getString((String)"scene.button.cancel"));
    private int clickButtonValue = 1;

    public InputLoginInfoLayout(String loginTip) {
        this.initUi(loginTip);
        this.authInfoInputPanel.setDefaultPort("8088");
    }

    private void initUi(String loginTip) {
        this.setLayout(new BorderLayout());
        this.initSize();
        this.add((Component)this.createCenterPanel(loginTip), "Center");
        this.add((Component)this.createBottomPanel(), "South");
        this.add(Box.createVerticalStrut(1), "East");
    }

    private JComponent createCenterPanel(String loginTip) {
        return StringUtils.isEmpty((CharSequence)loginTip) ? UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(12), this.authInfoInputPanel, Box.createVerticalStrut(12)})}) : UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(12), this.createTipPanel(loginTip), Box.createHorizontalStrut(0), this.authInfoInputPanel, Box.createVerticalStrut(12)})});
    }

    private JComponent createTipPanel(String loginTip) {
        JTextArea loginTipArea = UiMethod.createJTextArea((String)loginTip);
        loginTipArea.setPreferredSize(new Dimension(250, 50));
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), loginTipArea})});
    }

    private void initSize() {
        this.authInfoInputPanel.setLabelSize(new Dimension(100, 21));
        this.authInfoInputPanel.setFieldSize(new Dimension(150, 21));
    }

    private JComponent createBottomPanel() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxRight((Component[])new Component[]{this.confirmButton, this.cancelButton, Box.createHorizontalStrut(2)}), Box.createHorizontalStrut(2)});
    }

    public void bindListener(InputLoginInfoDialog parent) {
        this.confirmButton.addActionListener(e -> this.doConfirmAction(parent));
        this.cancelButton.addActionListener(e -> parent.dispose());
    }

    private void doConfirmAction(InputLoginInfoDialog parent) {
        try {
            this.authInfoInputPanel.validInput();
        }
        catch (ToolException ex) {
            log.warn("click ok but data valid failed");
            DialogUtils.showInfoDialog((JDialog)parent, (String)ex.getErrorLocaleDescription());
            return;
        }
        log.info("click ok and data valid pass");
        this.clickButtonValue = 0;
        parent.dispose();
    }

    public User buildLoginUser() {
        return this.authInfoInputPanel.buildLoginInfo();
    }

    public void setDefaultPort(String port) {
        this.authInfoInputPanel.setDefaultPort(port);
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public int getClickButtonValue() {
        return this.clickButtonValue;
    }
}

