/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.auth;

import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FusionStorageEvalContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.auth.AuthStep;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.ClusterEvalInfo;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.enums.ClusterMode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAuth
extends AuthStep {
    private static final Logger log = LoggerFactory.getLogger(SshAuth.class);
    private static final String CMD = "cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml |grep \"system wwn\"|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'";

    @Override
    public void auth(ClusterEvalInfo evalInfo, ProgressDialog progress, TaskResult taskResult) {
        progress.setCustMizeMsg(ResourceUtil.getString((String)"ssh.auth.processing"));
        this.authSSH((DevNode)evalInfo.getPrimaryNode(), ".pri", taskResult);
        if (ClusterMode.DOUBLE.equals((Object)evalInfo.getModel()) && !TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) {
            this.authSSH((DevNode)evalInfo.getStandbyNode(), ".standy", taskResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authSSH(DevNode node, String errFix, TaskResult taskResult) {
        try {
            ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)node);
            if (StringUtils.isNULLStr((String)FusionStorageEvalContext.getInstance().getNodeInfo().getFsmSerialNumber())) {
                log.info("Get sn from fsmNode...");
                String resultStr = sshConnection.execCmd(CMD);
                String[] results = resultStr.split(System.lineSeparator());
                if (results.length > 1) {
                    FusionStorageEvalContext.getInstance().getNodeInfo().setFsmSerialNumber(results[1]);
                } else {
                    FusionStorageEvalContext.getInstance().getNodeInfo().setFsmSerialNumber("");
                }
            }
        }
        catch (Exception e) {
            log.error("Ssh auth faild. node ip : {} port {}", (Object)node.getIp(), (Object)node.getPort());
            taskResult.setCurrNode(node);
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)("ssh.connect.fail" + errFix), (Object[])new Object[]{node.getIp(), node.getPort()}));
            log.info("Get sn from fsmNode failed!");
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)node);
        }
    }
}

