/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.MultiTaskResultMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.NodeMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.DmeLoginService;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.threadpool.ToolThreadFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBatchAuthUtil {
    private static final Logger log = LoggerFactory.getLogger(AsyncBatchAuthUtil.class);
    private static final ToolThreadFactory THREAD_FACTORY = new ToolThreadFactory("auth-dme-pool", (thread, ex) -> log.error("do dme auth uncaught error occurred", ex));
    private static final ExecutorService POOL = ThreadPoolHelper.getFixedNumThreadPool((int)ApplicationContext.getInstance().getMaxImportThreadSize(), (ThreadFactory)THREAD_FACTORY);

    public static TaskResult batchAsyncAuth(List<? extends DevNode> devNodes, Function<DevNode, TaskResult> doAuthFunc) {
        Map<DevNode, CompletableFuture<TaskResult>> nodeResult = AsyncBatchAuthUtil.doAsyncAuth(devNodes, doAuthFunc);
        return AsyncBatchAuthUtil.waitResult(nodeResult);
    }

    @NotNull
    private static Map<DevNode, CompletableFuture<TaskResult>> doAsyncAuth(List<? extends DevNode> devNodes, Function<DevNode, TaskResult> doAuthFunc) {
        HashMap<DevNode, CompletableFuture<TaskResult>> nodeResult = new HashMap<DevNode, CompletableFuture<TaskResult>>(devNodes.size());
        for (DevNode devNode : devNodes) {
            CompletableFuture<TaskResult> future = CompletableFuture.supplyAsync(() -> (TaskResult)doAuthFunc.apply(devNode), POOL);
            nodeResult.put(devNode, future);
        }
        return nodeResult;
    }

    private static TaskResult waitResult(Map<DevNode, CompletableFuture<TaskResult>> results) {
        TaskResult taskResult = new TaskResult(TaskResult.Result.SUCCESS);
        List<NodeMsg> nodeMsgs = results.entrySet().stream().map(AsyncBatchAuthUtil::parseAuthResult).collect(Collectors.toList());
        taskResult.setResultObject((Object)new MultiTaskResultMsg(nodeMsgs));
        return taskResult;
    }

    private static NodeMsg parseAuthResult(Map.Entry<DevNode, CompletableFuture<TaskResult>> result) {
        DevNode devNode = result.getKey();
        try {
            TaskResult nodeResult = result.getValue().get();
            if (Objects.isNull(nodeResult)) {
                log.warn("node :{} result is null", (Object)devNode.getIp());
                return new NodeMsg(false, devNode.getIp(), ResourceUtil.getString((String)"device.manager.result.get.error"));
            }
            if (TaskResult.Result.FAILED.equals((Object)nodeResult.getResult())) {
                return new NodeMsg(false, devNode.getIp(), nodeResult.getErrorLocaleDescription());
            }
            return new NodeMsg(true, devNode.getIp(), ResourceUtil.getString((String)"auth.state.success"));
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("node {} get device result failed", (Object)devNode.getIp(), (Object)e);
            return new NodeMsg(false, devNode.getIp(), ResourceUtil.getString((String)"device.manager.result.get.error"));
        }
    }

    public static boolean authDme(Window parent, AiDevNode aiDevNode) throws ToolException {
        TaskResult taskResult;
        CustMsgProgressDialog custMsgProgressDialog = new CustMsgProgressDialog(parent);
        DmeLoginService dmeLoginService = new DmeLoginService(custMsgProgressDialog, aiDevNode);
        Future result = AsyncExcutor.submit((Callable)dmeLoginService);
        if (custMsgProgressDialog.isDisplayable()) {
            custMsgProgressDialog.setVisible(true);
        }
        if ((taskResult = AsyncBatchAuthUtil.waitResult(result, aiDevNode)).getResult() != TaskResult.Result.SUCCESS) {
            throw new ToolException(taskResult.getErrorLocaleDescription(), false);
        }
        if (StringUtils.isNULLStr((String)taskResult.getAddConfirmInfo())) {
            return true;
        }
        log.warn("auth dme with confirm info, need user do choice");
        int value = DialogUtils.showYesNoConfirmDialog((Window)parent, (String)taskResult.getAddConfirmInfo(), (String)ResourceUtil.getString((String)"device.not.completeness.confirm.info")).getValue();
        log.info("user do choice with value :{}", (Object)value);
        return value == 0;
    }

    private static TaskResult waitResult(Future<TaskResult> result, AiDevNode aiDevNode) throws ToolException {
        try {
            return result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("get login result for :{} failed", (Object)aiDevNode.getIp(), (Object)e);
            throw new ToolException(ResourceUtil.getString((String)"device.manager.result.get.error"));
        }
    }

    private AsyncBatchAuthUtil() {
    }
}

