/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusionstorage;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FusionStorageEvalContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.ClusterEvalInfo;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractAddDeviceLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.listener.FusionStorageAddConfirmListener;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.config.validate.IpInputValidator;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.entity.enums.ClusterMode;
import com.huawei.ism.tool.obase.ui.wizard.YesAndNoRadioPanel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public class AddFusionStorageLayout
extends AbstractAddDeviceLayout {
    private static final String REST_PORT = "28443";
    private static final String REST_USER_NAME = "upadmin";
    private static final String FSM_PORT = "22";
    private static final String FSM_USER_NAME = "dsware";
    protected final IsmTextField priUserNameField = UiMethod.getUsernameFiled();
    protected final IsmTextField standbyUserNameField = UiMethod.getUsernameFiled();
    private final JLabel deployModeLabel = new JLabel(ResourceUtil.getString((String)"fusionstorage.eval.conn.deploy.desc") + ":");
    private final JComponent floatIpAddrLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.floatip.desc") + ":"), (boolean)true);
    private final JComponent floatPortLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.port.desc") + ":"), (boolean)false);
    private final JComponent innerUserName = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.inneruser.desc") + ":"), (boolean)false);
    private final JComponent basicInfoPwdLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc") + ":"), (boolean)true);
    private final TitledBorder basicBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.titleborder.desc"));
    private final JComponent priNodePortLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.pri.port.desc") + ":"), (boolean)false);
    private final JComponent priUserNameLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.username.desc") + ":"), (boolean)false);
    private final JComponent priPwdLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc") + ":"), (boolean)true);
    private final JComponent priRootPwdLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.root.pwd.desc") + ":"), (boolean)true);
    private final JComponent standbyNodePortLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.standby.port.desc") + ":"), (boolean)false);
    private final JComponent standbyUserNameLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.username.desc") + ":"), (boolean)false);
    private final JComponent standbyPwdLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc") + ":"), (boolean)true);
    private final JComponent standbyRootPwdLabel = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"fusionstorage.eval.conn.root.pwd.desc") + ":"), (boolean)true);
    private final TitledBorder configBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.titleborder.desc"));
    private final JComboBox<ClusterMode> mode = new JComboBox();
    private final IsmTextField floatIpAddrField = UiMethod.createIpv4v6TextField();
    private final IsmTextField floatPortField = UiMethod.getSshPortFiled();
    private final IsmTextField floatUserNameField = UiMethod.getUsernameFiled();
    private final IsmPasswordField floatPwdField = UiMethod.getPasswordFiled();
    private final IsmTextField priPortField = UiMethod.getSshPortFiled();
    private final IsmPasswordField priPwdField = UiMethod.getPasswordFiled();
    private final IsmPasswordField priRootPwdField = UiMethod.getPasswordFiled();
    private final IsmTextField standbyPortField = UiMethod.getSshPortFiled();
    private final IsmPasswordField standbyPwdField = UiMethod.getPasswordFiled();
    private final IsmPasswordField standbyRootPwdField = UiMethod.getPasswordFiled();
    private final JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
    private final JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"));
    private final YesAndNoRadioPanel yesAndNoButtonPanel = new YesAndNoRadioPanel();
    private JComponent priConfig;
    private JComponent standbyConfig;
    private ItDeviceType itDeviceType = ItDeviceType.FUSION_STORAGE;

    public AddFusionStorageLayout(SceneDeviceAddDialog sceneDeviceAddDialog) {
        this.parentDialog = sceneDeviceAddDialog;
        this.initComponentInfo();
        this.initUi();
    }

    private void initComponentInfo() {
        NotEmptyInputValidator notEmptyValidator = new NotEmptyInputValidator();
        this.mode.addItem(ClusterMode.DOUBLE);
        this.mode.addItem(ClusterMode.SINGLE);
        this.floatIpAddrField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.floatip.desc"));
        this.floatIpAddrField.addInputValidator((InputValidator)notEmptyValidator);
        this.floatIpAddrField.addInputValidator((InputValidator)new IpInputValidator());
        this.floatPortField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.port.desc"));
        this.floatPortField.addInputValidator((InputValidator)notEmptyValidator);
        this.floatPwdField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc"));
        this.floatPwdField.addInputValidator((InputValidator)notEmptyValidator);
        this.floatUserNameField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.inneruser.desc"));
        this.floatUserNameField.addInputValidator((InputValidator)notEmptyValidator);
        this.priPortField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.pri.port.desc"));
        this.priPortField.addInputValidator((InputValidator)notEmptyValidator);
        this.priUserNameField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.username.desc"));
        this.priUserNameField.addInputValidator((InputValidator)notEmptyValidator);
        this.priPwdField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc"));
        this.priPwdField.addInputValidator((InputValidator)notEmptyValidator);
        this.priRootPwdField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.root.pwd.desc"));
        this.priRootPwdField.addInputValidator((InputValidator)notEmptyValidator);
        this.standbyPortField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.standby.port.desc"));
        this.standbyPortField.addInputValidator((InputValidator)notEmptyValidator);
        this.standbyPwdField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc"));
        this.standbyPwdField.addInputValidator((InputValidator)notEmptyValidator);
        this.standbyRootPwdField.setInputValueName(ResourceUtil.getString((String)"fusionstorage.eval.conn.root.pwd.desc"));
        this.standbyRootPwdField.addInputValidator((InputValidator)notEmptyValidator);
    }

    private void initUi() {
        JComponent view = this.getInputPanel();
        this.add((Component)view, "Center");
        this.setPreferredSize(new Dimension(425, view.getPreferredSize().height));
    }

    @NotNull
    public JComponent getInputPanel() {
        Box deploy = UCD.buildHBoxLeft((Component[])new Component[]{this.deployModeLabel, this.mode});
        UCD.setSameWidth((JComponent[])new JComponent[]{this.mode});
        JComponent basicInfoUI = this.initBasicInfoUI();
        JComponent configInfoUI = this.initConfigInfoUI();
        UCD.setSameWidth((int)190, (JComponent[])new JComponent[]{this.floatIpAddrLabel, this.floatPortLabel, this.innerUserName, this.basicInfoPwdLabel, this.priNodePortLabel, this.priUserNameLabel, this.priRootPwdLabel, this.priPwdLabel, this.standbyNodePortLabel, this.standbyUserNameLabel, this.standbyRootPwdLabel, this.standbyPwdLabel});
        JComponent btnPan = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn, Box.createHorizontalStrut(0)}), Box.createHorizontalStrut(0)});
        return UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{deploy, basicInfoUI, configInfoUI, btnPan});
    }

    private JComponent initBasicInfoUI() {
        this.floatIpAddrField.addInputValidator((InputValidator)new NotEmptyInputValidator());
        Box ip = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.floatIpAddrLabel, this.floatIpAddrField, Box.createHorizontalStrut(10)});
        this.floatPortField.setText(REST_PORT);
        this.floatPortField.setBorder(null);
        this.floatPortField.setEditable(false);
        Box port = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.floatPortLabel, this.floatPortField, Box.createHorizontalStrut(10)});
        this.floatUserNameField.setText(REST_USER_NAME);
        this.floatUserNameField.setBorder(null);
        this.floatUserNameField.setEditable(false);
        Box innerUser = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.innerUserName, this.floatUserNameField, Box.createHorizontalStrut(10)});
        JLabel certificateLabel = new JLabel(ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.certificate"));
        Box certiCom = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), certificateLabel, this.yesAndNoButtonPanel, Box.createHorizontalStrut(10)});
        Box pwd = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.basicInfoPwdLabel, this.floatPwdField, Box.createHorizontalStrut(10)});
        return UCD.buildVerticalBox((Border)this.basicBorder, (int)6, (Component[])new Component[]{Box.createVerticalStrut(2), ip, port, innerUser, pwd, certiCom, Box.createVerticalStrut(2)});
    }

    private JComponent initConfigInfoUI() {
        this.priConfig = this.initPriConfig();
        this.standbyConfig = this.initStandbyConfig();
        return UCD.buildVerticalBox((Border)this.configBorder, (Component[])new Component[]{Box.createVerticalStrut(2), this.priConfig, this.standbyConfig, Box.createVerticalStrut(2)});
    }

    private JComponent initPriConfig() {
        this.priPortField.setText(FSM_PORT);
        this.priPortField.setBorder(null);
        this.priPortField.setEditable(false);
        Box nodePort = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.priNodePortLabel, this.priPortField, Box.createHorizontalStrut(10)});
        this.priUserNameField.setText(FSM_USER_NAME);
        this.priUserNameField.setBorder(null);
        this.priUserNameField.setEditable(false);
        Box userName = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.priUserNameLabel, this.priUserNameField, Box.createHorizontalStrut(10)});
        Box pwd = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.priPwdLabel, this.priPwdField, Box.createHorizontalStrut(10)});
        Box rootPwd = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.priRootPwdLabel, this.priRootPwdField, Box.createHorizontalStrut(10)});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{nodePort, userName, pwd, rootPwd});
    }

    private JComponent initStandbyConfig() {
        this.standbyPortField.setText(FSM_PORT);
        this.standbyPortField.setBorder(null);
        this.standbyPortField.setEditable(false);
        Box nodePort = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.standbyNodePortLabel, this.standbyPortField, Box.createHorizontalStrut(10)});
        this.standbyUserNameField.setText(FSM_USER_NAME);
        this.standbyUserNameField.setBorder(null);
        this.standbyUserNameField.setEditable(false);
        Box userName = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.standbyUserNameLabel, this.standbyUserNameField, Box.createHorizontalStrut(10)});
        Box pwd = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.standbyPwdLabel, this.standbyPwdField, Box.createHorizontalStrut(10)});
        Box rootPwd = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.standbyRootPwdLabel, this.standbyRootPwdField, Box.createHorizontalStrut(10)});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{nodePort, userName, pwd, rootPwd});
    }

    public List<IsmTextField> getTextCheckInput() {
        ArrayList<IsmTextField> textCheckedInput = new ArrayList<IsmTextField>();
        textCheckedInput.add(this.floatIpAddrField);
        textCheckedInput.add(this.floatPortField);
        textCheckedInput.add(this.floatUserNameField);
        if (ClusterMode.DOUBLE.equals(this.mode.getSelectedItem())) {
            textCheckedInput.add(this.standbyPortField);
            textCheckedInput.add(this.standbyUserNameField);
        }
        textCheckedInput.add(this.priUserNameField);
        textCheckedInput.add(this.priPortField);
        return textCheckedInput;
    }

    public List<IsmPasswordField> getPasswordCheckInput() {
        ArrayList<IsmPasswordField> pwdCheckedInput = new ArrayList<IsmPasswordField>();
        pwdCheckedInput.add(this.floatPwdField);
        if (ClusterMode.DOUBLE.equals(this.mode.getSelectedItem())) {
            pwdCheckedInput.add(this.standbyPwdField);
            pwdCheckedInput.add(this.standbyRootPwdField);
        }
        pwdCheckedInput.add(this.priPwdField);
        pwdCheckedInput.add(this.priRootPwdField);
        return pwdCheckedInput;
    }

    public ClusterEvalInfo buildLoginClusterInfo() {
        ClusterEvalInfo taskInfo = new ClusterEvalInfo();
        FusionStorageEvalContext.getInstance().setNodeInfo(taskInfo);
        if (this.mode.getSelectedItem() instanceof ClusterMode) {
            taskInfo.setModel((ClusterMode)this.mode.getSelectedItem());
        }
        taskInfo.setItDeviceType(this.itDeviceType);
        taskInfo.setFloatIp(this.floatIpAddrField.getText());
        taskInfo.setLoginUsername(this.floatUserNameField.getText());
        taskInfo.setLoginPassword(new String(this.floatPwdField.getPassword()));
        taskInfo.setRestPort(this.floatPortField.getText());
        taskInfo.setVerifyCertificate(this.yesAndNoButtonPanel.isSelectedYes());
        taskInfo.setPrimaryNode(this.initPriNodeInfo());
        if (ClusterMode.DOUBLE.equals((Object)taskInfo.getModel())) {
            taskInfo.setStandbyNode(this.initStandbyNodeInfo());
        }
        return taskInfo;
    }

    private FsDevNode initStandbyNodeInfo() {
        FsDevNode standbyNode = new FsDevNode();
        User user = new User(this.standbyUserNameField.getText(), new String(this.standbyPwdField.getPassword()));
        standbyNode.setLoginUser(user);
        User rootUser = new User("root", Base64EncodeUtils.encode((String)new String(this.standbyRootPwdField.getPassword())));
        standbyNode.setRootUser(rootUser);
        standbyNode.setPort(Integer.parseInt(this.standbyPortField.getText()));
        return standbyNode;
    }

    private FsDevNode initPriNodeInfo() {
        FsDevNode primaryNode = new FsDevNode();
        User user = new User(this.priUserNameField.getText(), new String(this.priPwdField.getPassword()));
        primaryNode.setLoginUser(user);
        User rootUser = new User("root", Base64EncodeUtils.encode((String)new String(this.priRootPwdField.getPassword())));
        primaryNode.setRootUser(rootUser);
        primaryNode.setPort(Integer.parseInt(this.priPortField.getText()));
        return primaryNode;
    }

    @Override
    public void bindListener() {
        this.cancelBtn.addActionListener(e -> this.parentDialog.dispose());
        this.okBtn.addActionListener(new FusionStorageAddConfirmListener(this.parentDialog, this));
        this.mode.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                if (ClusterMode.SINGLE.equals(event.getItem())) {
                    this.priConfig.setVisible(true);
                    this.standbyConfig.setVisible(false);
                } else {
                    this.priConfig.setVisible(true);
                    this.standbyConfig.setVisible(true);
                }
            }
        });
    }

    @Override
    public JButton getDefaultButton() {
        return this.okBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public void setItDeviceType(ItDeviceType itDeviceType) {
        this.itDeviceType = itDeviceType;
    }
}

