/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.ClusterEvalInfo;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.FusionStorageDeviceAddService;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusionstorage.AddFusionStorageLayout;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ErrorDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageAddConfirmListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(FusionStorageAddConfirmListener.class);
    private final SceneDeviceAddDialog parentDialog;
    private final AddFusionStorageLayout sourceLayout;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!SwingUtil.validateInput(this.sourceLayout.getTextCheckInput(), (Window)this.parentDialog)) {
            return;
        }
        if (!SwingUtil.validatePwdInput(this.sourceLayout.getPasswordCheckInput(), (Window)this.parentDialog)) {
            return;
        }
        CustMsgProgressDialog custMsgProgressDialog = new CustMsgProgressDialog((Window)this.parentDialog);
        ClusterEvalInfo clusterEvalInfo = this.sourceLayout.buildLoginClusterInfo();
        FusionStorageDeviceAddService fusionStorageDeviceAddService = new FusionStorageDeviceAddService(clusterEvalInfo, custMsgProgressDialog);
        Future submit = AsyncExcutor.submit((Callable)fusionStorageDeviceAddService);
        if (custMsgProgressDialog.isDisplayable()) {
            custMsgProgressDialog.setVisible(true);
        }
        this.waitResult(submit, clusterEvalInfo);
    }

    private void waitResult(Future<TaskResult> submit, ClusterEvalInfo clusterEvalInfo) {
        try {
            TaskResult taskResult = submit.get();
            if ("No trusted certificate found".equals(taskResult.getErrorId())) {
                ErrorDialog errorDialog = DialogUtils.showErrorDialog((JDialog)this.parentDialog, (String)ResourceUtil.getString((String)"fusionstorage.eval.conn.cert.verify.faled.tips"));
                errorDialog.setAlwaysOnTop(true);
            }
            if (TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) {
                DialogUtils.showInfoDialog((JDialog)this.parentDialog, (String)taskResult.getErrorLocaleDescription());
                return;
            }
            if (TaskResult.Result.SUCCESS.equals((Object)taskResult.getResult())) {
                this.notifyNodeAdded(clusterEvalInfo);
                this.parentDialog.dispose();
                return;
            }
            this.showErrorMsg(taskResult);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("login device :{} failed", (Object)clusterEvalInfo.getFloatIp(), (Object)e);
        }
        catch (ToolException e) {
            log.error("add fusionStorage node error", (Throwable)e);
        }
    }

    private void notifyNodeAdded(ClusterEvalInfo clusterEvalInfo) throws ToolException {
        FsDevNode floatNode = clusterEvalInfo.getFloatNode();
        floatNode.setDeviceType(FusionStorageAddConfirmListener.getDeviceType(clusterEvalInfo));
        floatNode.setItDeviceType(clusterEvalInfo.getItDeviceType());
        floatNode.setPriFsDevNode(clusterEvalInfo.getPrimaryNode());
        floatNode.setStandbyDevNode(clusterEvalInfo.getStandbyNode());
        floatNode.setClusterNodes(new ArrayList<ClusterNode>(clusterEvalInfo.getFsaNodes().values()));
        DefaultNodeProviderImpl.getInstance().addNode((DevNode)floatNode);
    }

    @NotNull
    private static DeviceType getDeviceType(ClusterEvalInfo clusterEvalInfo) {
        return clusterEvalInfo.getItDeviceType() == ItDeviceType.FUSION_STORAGE ? DeviceType.valueOf((String)"FusionStorage") : DeviceType.valueOf((String)"FusionCube");
    }

    private void showErrorMsg(TaskResult taskResult) {
        DialogUtils.showErrorDialog((JDialog)this.parentDialog, (String)taskResult.getErrorLocaleDescription());
    }

    public FusionStorageAddConfirmListener(SceneDeviceAddDialog parentDialog, AddFusionStorageLayout sourceLayout) {
        this.parentDialog = parentDialog;
        this.sourceLayout = sourceLayout;
    }
}

