/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former;

import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.former.GetTooolSupportList;
import com.huawei.ism.tool.devicemanager.ui.former.SupportProductsIntersection;
import com.huawei.ism.tool.devicemanager.utils.SceneParser;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SceneProductParser {
    private static final String DEFAULT_CONFIG_PATH = "config/sceneProducts.xml";
    private static final String XMLNAME = "xmlName";
    private static final String PRODUCT_NODE_NAME = "product";
    private static final String PRODUCT_MODE_NODE_NAME = "productname";
    private static final String SUPPORT_NODE_NAME = "supporttypes";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneProductParser.class);
    private static final String TOOLPATH_CONFIG_PATH = "config/toolPathCfg.xml";
    private static final String ID = "id";
    private static final String TOOL = "tool";
    private static final String RELATIVEPATH = "relativePath";
    private static final String MAINTAIN = "Routine Maintain";
    private Element root = null;
    private static Map<String, Map<String, ArrayList<String>>> sceneToolSupportMap;

    public SceneProductParser() {
        this.initDocument(TOOLPATH_CONFIG_PATH);
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDocument(String path) {
        InputStream in = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            if (null == cl) {
                throw new NullPointerException("Classloader is null");
            }
            in = cl.getResourceAsStream(path);
            Document document = XmlUtils.parseDocument((InputStream)in);
            this.root = document.getDocumentElement();
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(null, in);
            throw throwable;
        }
        StreamUtils.closeStream(null, (InputStream)in);
    }

    public Map<String, String> parse() {
        List<String> toolList = DeviceSceneContext.getInstance().getToolList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get scene tool list:" + toolList);
        }
        String mainSceneID = SceneParser.getInstance().getMainScene();
        String sceneID = SceneParser.getInstance().getSubScene();
        boolean isUnionDevice = SceneParser.isIsuniondevice();
        if (!this.judgeSceneID(mainSceneID, sceneID)) {
            return new KeyOrderedHashMap();
        }
        Map<String, String> toolCfgPathMap = this.getToolCfgPathMap(toolList);
        Map<String, Map<String, ArrayList<String>>> toolSupportMap = this.getToolSupportMap(toolCfgPathMap, mainSceneID, sceneID);
        SceneProductParser.setSceneToolSupportMap(toolSupportMap);
        return this.getSceneSupportList(isUnionDevice, mainSceneID, toolCfgPathMap, toolSupportMap, toolList);
    }

    private Map<String, String> getSceneSupportList(Boolean isUnionDevice, String mainSceneID, Map<String, String> toolCfgPathMap, Map<String, Map<String, ArrayList<String>>> toolSupportMap, List<String> toolList) {
        if (MAINTAIN.equalsIgnoreCase(mainSceneID) && toolSupportMap.size() < toolCfgPathMap.size()) {
            return this.getDefaultInfos();
        }
        if (!isUnionDevice.booleanValue() && toolSupportMap.size() < toolCfgPathMap.size()) {
            return new KeyOrderedHashMap();
        }
        if (isUnionDevice.booleanValue() && !toolList.isEmpty() && !toolSupportMap.isEmpty()) {
            Object allToolSupport = new KeyOrderedHashMap();
            for (String toolName : toolList) {
                Map<String, ArrayList<String>> singleToolSupport = toolSupportMap.get(toolName);
                if (allToolSupport.isEmpty()) {
                    this.copyMapInfo((Map<String, ArrayList<String>>)allToolSupport, singleToolSupport);
                    continue;
                }
                allToolSupport = SceneProductParser.getallToolSupportUnion(singleToolSupport, (Map<String, ArrayList<String>>)allToolSupport);
            }
            if (!allToolSupport.isEmpty()) {
                return SupportProductsIntersection.supportProducts((Map<String, ArrayList<String>>)allToolSupport);
            }
        }
        return SupportProductsIntersection.getIntersection(toolSupportMap);
    }

    private void copyMapInfo(Map<String, ArrayList<String>> allToolSupport, Map<String, ArrayList<String>> singleToolSupport) {
        for (Map.Entry<String, ArrayList<String>> singleToolKey : singleToolSupport.entrySet()) {
            ArrayList<String> dic = new ArrayList<String>(Arrays.asList(new String[singleToolKey.getValue().size()]));
            Collections.copy(dic, (List)singleToolKey.getValue());
            allToolSupport.put(singleToolKey.getKey(), dic);
        }
    }

    private static Map<String, ArrayList<String>> getallToolSupportUnion(Map<String, ArrayList<String>> singleToolSupport, Map<String, ArrayList<String>> allToolSupport) {
        boolean isExist = false;
        ArrayList<String> allToolList = null;
        List singleToolList = null;
        KeyOrderedHashMap allToolSupportMap = new KeyOrderedHashMap();
        if (null == singleToolSupport || singleToolSupport.isEmpty()) {
            LOGGER.info("the singleToolSupport is null.");
            return allToolSupport;
        }
        for (Map.Entry<String, ArrayList<String>> allToolKey : allToolSupport.entrySet()) {
            ArrayList<String> dic = new ArrayList<String>(Arrays.asList(new String[allToolKey.getValue().size()]));
            Collections.copy(dic, (List)allToolKey.getValue());
            allToolSupportMap.put(allToolKey.getKey(), dic);
        }
        for (Map.Entry<String, ArrayList<String>> singleToolKey : singleToolSupport.entrySet()) {
            isExist = false;
            for (Map.Entry<String, ArrayList<String>> allToolKey : allToolSupport.entrySet()) {
                if (!singleToolKey.getKey().equals(allToolKey.getKey())) continue;
                singleToolList = singleToolKey.getValue();
                allToolList = allToolKey.getValue();
                allToolList.addAll(singleToolList);
                allToolList = SceneProductParser.removeDuplicate(allToolList);
                allToolSupportMap.put(allToolKey.getKey(), allToolList);
                isExist = true;
                break;
            }
            if (isExist) continue;
            allToolSupportMap.put(singleToolKey.getKey(), singleToolKey.getValue());
        }
        return allToolSupportMap;
    }

    private static ArrayList<String> removeDuplicate(ArrayList<String> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (String str : list) {
            if (result.contains(str)) continue;
            result.add(str);
        }
        list.clear();
        list.addAll(result);
        return list;
    }

    private boolean judgeSceneID(String mainSceneID, String sceneID) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("mainScene = " + mainSceneID + " , SubScene = " + sceneID);
        }
        if (StringUtils.hasNULLStr((String[])new String[]{mainSceneID, sceneID})) {
            LOGGER.error("SceneID can not be null.");
            return false;
        }
        return true;
    }

    private Map<String, Map<String, ArrayList<String>>> getToolSupportMap(Map<String, String> toolCfgPathMap, String mainSceneID, String sceneID) {
        KeyOrderedHashMap supportListMap = new KeyOrderedHashMap();
        for (Map.Entry<String, String> toolCfgEntry : toolCfgPathMap.entrySet()) {
            String toolID = toolCfgEntry.getKey();
            String filePath = toolCfgEntry.getValue();
            try {
                filePath = new File(filePath).getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("get path fail!", (Throwable)e);
            }
            Map<String, ArrayList<String>> toolSupportMap = new GetTooolSupportList(filePath, mainSceneID, sceneID).parse();
            if (toolSupportMap.isEmpty()) {
                LOGGER.error("tool:" + toolID + " support is empty.");
                continue;
            }
            supportListMap.put(toolID, toolSupportMap);
        }
        return supportListMap;
    }

    private Map<String, String> getToolCfgPathMap(List<String> toolList) {
        String parentDir = SceneUtils.getToolBoxDir();
        HashMap<String, String> toolCfgPathMap = new HashMap<String, String>();
        for (String toolID : toolList) {
            String filePath = parentDir + File.separator + this.getToolCfgPath(toolID);
            toolCfgPathMap.put(toolID, filePath);
        }
        return toolCfgPathMap;
    }

    private String getToolCfgPath(String toolID) {
        Collection tools = XmlUtils.getChildren((Element)this.root, (String)TOOL);
        for (Element tool : tools) {
            if (!toolID.equalsIgnoreCase(tool.getAttribute(ID))) continue;
            Element dir = XmlUtils.getChild((Element)tool, (String)RELATIVEPATH);
            Element fileName = XmlUtils.getChild((Element)tool, (String)XMLNAME);
            if (null == dir || null == fileName) continue;
            return dir.getFirstChild().getTextContent() + File.separator + fileName.getFirstChild().getTextContent();
        }
        LOGGER.error("Config error:the subElement of toolId = " + toolID + " is not exist.");
        return "";
    }

    private Map<String, String> getDefaultInfos() {
        LOGGER.info("return default support list.");
        this.initDocument(DEFAULT_CONFIG_PATH);
        KeyOrderedHashMap infos = new KeyOrderedHashMap();
        if (this.root == null) {
            return null;
        }
        Collection products = XmlUtils.getChildren((Element)this.root, (String)PRODUCT_NODE_NAME);
        for (Element product : products) {
            this.parseProduct(product, (Map<String, String>)infos);
        }
        return infos;
    }

    private void parseProduct(Element product, Map<String, String> infos) {
        Element modelNode = XmlUtils.getChild((Element)product, (String)PRODUCT_MODE_NODE_NAME);
        String model = modelNode.getFirstChild().getTextContent();
        Element supportNode = XmlUtils.getChild((Element)product, (String)SUPPORT_NODE_NAME);
        String supports = supportNode.getFirstChild().getTextContent();
        infos.put(model, supports);
    }

    public static Map<String, Map<String, ArrayList<String>>> getSceneToolSupportMap() {
        return sceneToolSupportMap;
    }

    public static void setSceneToolSupportMap(Map<String, Map<String, ArrayList<String>>> sceneToolSupportMap) {
        SceneProductParser.sceneToolSupportMap = sceneToolSupportMap;
    }
}

