/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener;

import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.devicemanager.utils.FilesUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirSetupButtonListener
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirSetupButtonListener.class);
    private JDialog parent;
    private String text;

    public DirSetupButtonListener(JDialog parent, String text) {
        this.parent = parent;
        this.text = text;
    }

    public abstract void callback(String var1);

    @Override
    public void actionPerformed(ActionEvent event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("default text=" + this.text);
        }
        String[] exts = new String[]{};
        File file = ToolFileChooser.selectFileByPathDealDot((Window)this.parent, (String)ResourceUtil.getString((String)"scene.set.directory.title"), (String[])exts, (String)this.text, (String)ResourceUtil.getString((String)"scene.folder"), (int)1, (boolean)false, (boolean)ApplicationContext.getInstance().isWindowsOS(), (Locale)LanguageManager.getInstance().getCurrentLanguage(), (boolean)true);
        if (file == null) {
            LOGGER.warn("file is null!");
            return;
        }
        if (!FilesUtil.isNormalPath(FilePathUtils.getCanonicalPath((File)file))) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"scene.remind.dirchangefail.character"));
            this.actionPerformed(event);
            return;
        }
        if (40 < FilePathUtils.getCanonicalPath((File)file).length()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"scene.remind.file.max.length"));
            this.actionPerformed(event);
            return;
        }
        if (FilePathUtils.getCanonicalPath((File)file).contains(ApplicationContext.getInstance().getWorkPath())) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"file.path.can.not.install.path"));
            return;
        }
        try {
            LOGGER.info("change collect dir success.");
            this.text = file.getCanonicalPath();
            this.callback(file.getCanonicalPath());
        }
        catch (Exception ex) {
            LOGGER.error("save scene dir failed!!!", (Throwable)ex);
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"scene.remind.dirchangefail"));
        }
    }
}

