/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScenePreparedMainJDialogListener
extends WindowAdapter
implements KeyListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ScenePreparedMainJDialogListener.class);
    private JDialog dialog;

    public ScenePreparedMainJDialogListener(JDialog scenePreparedMainJDialog) {
        this.dialog = scenePreparedMainJDialog;
    }

    public abstract void okCallback();

    public abstract void cancelCallback();

    @Override
    public void windowClosing(WindowEvent e) {
        this.action();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.action();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void action() {
        try {
            WarningDialog pDialog = DialogUtils.showYesNoDialog((Window)this.dialog, (String)ResourceUtil.getString((String)"scene.remind.close"));
            if (0 == pDialog.getValue()) {
                this.okCallback();
                this.dialog.dispose();
                LoggerFactory.getLogger(this.getClass()).info("scene tool exit.");
            } else {
                this.cancelCallback();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("mainDialog close runtime exception", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("mainDialog close failed");
        }
    }
}

