/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.mainframe;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.AddAiDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.DeleteAiDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceToolAction;
import com.huawei.ism.tool.devicemanager.ui.action.ModifyAiDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.UpdateAiDeviceAction;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.ui.component.AbstractBasePanel;
import com.huawei.ism.tool.obase.ui.component.treetable.DefaultTreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiDeviceManagementPanel
extends AbstractBasePanel
implements INodeObserver {
    private static final Logger log = LoggerFactory.getLogger(AiDeviceManagementPanel.class);
    private TreeTable deviceTable;
    private TreeTableModel deviceTableModel;
    private DeviceToolAction addDeviceAction;
    private DeviceToolAction modifyAction;
    private DeviceToolAction deleteAction;
    private DeviceToolAction updateDeviceAction;
    private final List<ToolAction> rightMouseActions = new ArrayList<ToolAction>();
    private final Window parent;

    public AiDeviceManagementPanel(JFrame parentFrame) {
        super(false);
        this.parent = parentFrame;
        this.initBtnAction();
        this.initTableData();
    }

    private void initTableData() {
        for (DevNode devNode : DefaultNodeProviderImpl.getInstance().getNodeList()) {
            this.fireNodeAdd(devNode);
        }
    }

    public void updateButtons() {
        List selectRows = this.deviceTable.getSelectRows();
        List btnList = this.getBtnList();
        for (JButton btn : btnList) {
            Action action = btn.getAction();
            if (!(action instanceof ToolAction)) continue;
            this.setActionData((ToolAction)action, selectRows);
        }
    }

    private void setActionData(ToolAction btnAction, List<ITreeTableRow<?, ?>> selectRows) {
        btnAction.setSelectObject(this.getRowData(selectRows));
        if (((Object)((Object)this.modifyAction)).equals(btnAction)) {
            btnAction.setEnabled(false);
            btnAction.setEnabled(this.selectOnDmeNode(selectRows));
            return;
        }
        if (((Object)((Object)this.deleteAction)).equals(btnAction) || ((Object)((Object)this.updateDeviceAction)).equals(btnAction)) {
            btnAction.setEnabled(false);
            btnAction.setEnabled(this.selectOnlyDmeNode(selectRows));
        }
    }

    private List<AiDevNode> getRowData(List<ITreeTableRow<?, ?>> selectRows) {
        return selectRows.stream().map(ITreeTableRow::getUserObject).filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).collect(Collectors.toList());
    }

    private boolean selectOnlyDmeNode(List<ITreeTableRow<?, ?>> selectRows) {
        return !selectRows.isEmpty() && selectRows.stream().allMatch(row -> row.getIdentifier() instanceof AiDevNode);
    }

    private boolean selectOnDmeNode(List<ITreeTableRow<?, ?>> selectRows) {
        return selectRows.size() == 1 && selectRows.get(0).getIdentifier() instanceof AiDevNode;
    }

    protected void initListeners() {
        this.deviceTableModel.fireTableDataChanged();
        this.deviceTable.setUpdateSelectionOnSort(true);
        this.deviceTable.addMouseListener((MouseListener)new TableMouseAdapter());
        this.deviceTable.addListSelectionListener(event -> this.updateButtons());
        ListSelectionModel listModel = this.deviceTable.getSelectionModel();
        listModel.addListSelectionListener(event -> this.updateButtons());
    }

    protected JComponent getTopComponent() {
        String[] tableHeader = this.getTableHeader();
        this.deviceTableModel = new TreeTableModel(tableHeader);
        this.deviceTable = new TreeTable(this.deviceTableModel, true, false, false, true);
        ToolUCD.setStandardFont((JComponent[])new JComponent[]{this.deviceTable.getTableHeader()});
        TableColumn firstColumn = this.deviceTable.getColumnModel().getColumn(0);
        firstColumn.setPreferredWidth(200);
        firstColumn.setMaxWidth(280);
        firstColumn.setMinWidth(200);
        return new TableScrollPane(true, false, false, (IsmTable)this.deviceTable);
    }

    private void initBtnAction() {
        this.addDeviceAction = new AddAiDeviceAction(this.parent);
        this.modifyAction = new ModifyAiDeviceAction(this.parent);
        this.deleteAction = new DeleteAiDeviceAction(this.parent);
        this.updateDeviceAction = new UpdateAiDeviceAction(this.parent);
        this.addDeviceAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.add"));
        this.modifyAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.modify"));
        this.deleteAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.dele"));
        this.updateDeviceAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.update"));
        this.addDeviceAction.putValue("Icon", ResourceUtil.getImage((String)"device_add.png"));
        this.modifyAction.putValue("Icon", ResourceUtil.getImage((String)"device_modify.png"));
        this.deleteAction.putValue("Icon", ResourceUtil.getImage((String)"device_remove.png"));
        this.updateDeviceAction.putValue("Icon", ResourceUtil.getImage((String)"device_update.png"));
        this.setRolloverButton(false);
        this.setButtonPanelBackground(Color.WHITE);
        this.addButton(new ToolAction[]{this.addDeviceAction, this.modifyAction, this.deleteAction, this.updateDeviceAction});
        this.rightMouseActions.add(this.modifyAction);
        this.rightMouseActions.add(this.deleteAction);
    }

    private String[] getTableHeader() {
        return new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtype"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.productversion"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtname"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devsn"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devusername"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.sshport"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state")};
    }

    private ITreeTableRow<? extends DevNode, ? extends DevNode> buildDmeRow(AiDevNode deviceNode) {
        DefaultTreeTableRow dmeNodeRow = new DefaultTreeTableRow(this.deviceTableModel.getColumnCount(), (Object)deviceNode, (Object)deviceNode);
        this.setRowValue((ITreeTableRow<? extends DevNode, ? extends DevNode>)dmeNodeRow, (DevNode)deviceNode);
        this.buildA800SubRows(deviceNode.getA800Nodes()).forEach(arg_0 -> ((ITreeTableRow)dmeNodeRow).addSubRow(arg_0));
        this.buildOmRows(deviceNode.getOmNodes()).forEach(arg_0 -> ((ITreeTableRow)dmeNodeRow).addSubRow(arg_0));
        return dmeNodeRow;
    }

    private List<ITreeTableRow<DevNode, DevNode>> buildA800SubRows(List<A800Node> a800Nodes) {
        return a800Nodes.stream().map(this::buildA800Row).collect(Collectors.toList());
    }

    private ITreeTableRow<DevNode, DevNode> buildA800Row(A800Node node) {
        DefaultTreeTableRow a800NodeRow = new DefaultTreeTableRow(this.deviceTableModel.getColumnCount(), (Object)node, (Object)node);
        this.buildZoneRows(node.getZones()).forEach(arg_0 -> ((ITreeTableRow)a800NodeRow).addSubRow(arg_0));
        this.setRowValue((ITreeTableRow<? extends DevNode, ? extends DevNode>)a800NodeRow, (DevNode)node);
        return a800NodeRow;
    }

    private List<ITreeTableRow<DevNode, DevNode>> buildOmRows(List<? extends DevNode> omNodes) {
        if (CollectionUtil.isEmpty(omNodes)) {
            return Collections.emptyList();
        }
        return omNodes.stream().map(this::buildNodeRow).collect(Collectors.toList());
    }

    private List<ITreeTableRow<DevNode, DevNode>> buildZoneRows(List<? extends DevNode> zoneNodes) {
        if (CollectionUtil.isEmpty(zoneNodes)) {
            return Collections.emptyList();
        }
        return zoneNodes.stream().map(this::buildNodeRow).collect(Collectors.toList());
    }

    private ITreeTableRow<DevNode, DevNode> buildNodeRow(DevNode node) {
        DefaultTreeTableRow nodeRow = new DefaultTreeTableRow(this.deviceTableModel.getColumnCount(), (Object)node, (Object)node);
        this.setRowValue((ITreeTableRow<? extends DevNode, ? extends DevNode>)nodeRow, node);
        return nodeRow;
    }

    private void setRowValue(ITreeTableRow<? extends DevNode, ? extends DevNode> nodeRow, DevNode node) {
        int index = 0;
        nodeRow.setValue(index++, (Object)this.getShowStr(node.getProductModel()));
        nodeRow.setValue(index++, (Object)this.getShowStr(node.getProductVersion()));
        nodeRow.setValue(index++, (Object)this.getShowStr(node.getDeviceName()));
        nodeRow.setValue(index++, (Object)this.getShowStr(node.getIp()));
        nodeRow.setValue(index++, (Object)this.getShowStr(node.getDeviceSerialNumber()));
        nodeRow.setValue(index++, (Object)(Objects.isNull(node.getLoginUser()) ? "" : node.getLoginUser().getUserName()));
        nodeRow.setValue(index++, (Object)node.getPort());
        if (node instanceof DmeNode) {
            nodeRow.setValue(index, (Object)((DmeNode)node).getStatus());
        }
        this.deviceTableModel.fireTableDataChanged();
    }

    private String getShowStr(String field) {
        return StringUtils.isNULLStr((String)field) ? "--" : field;
    }

    @Override
    public void fireNodeAdd(DevNode dev) {
        if (dev instanceof AiDevNode) {
            this.deviceTableModel.addOneRow(this.buildDmeRow((AiDevNode)dev), true);
        }
    }

    @Override
    public void fireNodeDelete(DevNode dev) throws ToolException {
        if (dev instanceof AiDevNode) {
            this.deviceTableModel.getAllTableRows().stream().filter(row -> row.getUserObject().equals(dev)).forEach(row -> this.deviceTableModel.deleteRowByUpdate(row));
        }
    }

    @Override
    public void fireNodeModify(DevNode dev) throws ToolException {
        if (dev instanceof AiDevNode) {
            this.deviceTableModel.getAllTableRows().stream().filter(row -> row.getIdentifier().equals(dev)).forEach(row -> this.updateRowByDevice((ITreeTableRow)row, (AiDevNode)dev));
        }
    }

    private void updateRowByDevice(ITreeTableRow tableRow, AiDevNode dev) {
        log.info("update device :{}", (Object)dev.getIp());
        this.deviceTableModel.deleteRowByUpdate(tableRow);
        this.deviceTableModel.addOneRow(this.buildDmeRow(dev), true);
    }

    private class TableMouseAdapter
    extends MouseAdapter {
        private TableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            int row = AiDeviceManagementPanel.this.deviceTable.rowAtPoint(mouseEvent.getPoint());
            AiDeviceManagementPanel.this.deviceTable.setRowSelectionInterval(row, row);
            JPopupMenu popupmenu = this.buildPopupMenu(row);
            popupmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        @NotNull
        private JPopupMenu buildPopupMenu(int row) {
            JPopupMenu popupmenu = new JPopupMenu();
            for (ToolAction action : AiDeviceManagementPanel.this.rightMouseActions) {
                if (action instanceof DeleteAiDeviceAction) {
                    if (!this.isRootRow(row)) continue;
                    popupmenu.add((Action)action);
                    continue;
                }
                popupmenu.add((Action)action);
            }
            return popupmenu;
        }

        private boolean isRootRow(int row) {
            return AiDeviceManagementPanel.this.deviceTable.getTreeTableModel().getRowElement(row).getTableRow().getParentRow() == null;
        }
    }
}

