/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class CertCheckCfmUtils {
    private static final String FINGERPRINT_CONFIG = "configuration";
    private static final String CERT_PROPERTIES = "certcomfirm.properties";
    private static final String LANGUAGE = "language";
    private static final String TOOLSFOLDER = "tools";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CertCheckCfmUtils.class);
    private static String currCertPath;

    public static Properties getCertConfirmProp() {
        return CertCheckCfmUtils.shareCertkey();
    }

    public static boolean isTCfmrusteDev(String devSn) {
        Object val = CertCheckCfmUtils.getCertConfirmProp().get(devSn);
        return val != null && Boolean.valueOf(val.toString()) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private static Properties shareCertkey() {
        Properties ret2333333332;
        Properties p = new Properties();
        FileInputStream in = null;
        currCertPath = FilePathUtils.filterPath((String)CertCheckCfmUtils.initHostKeyPath());
        File hostkeyFile = new File(currCertPath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Current cert path is : " + currCertPath);
        }
        try {
            boolean ret2333333332;
            if (!hostkeyFile.exists() && !(ret2333333332 = hostkeyFile.createNewFile())) {
                LOGGER.error("Error happened in creat file.");
            }
            in = new FileInputStream(hostkeyFile);
            p.load(in);
            ret2333333332 = p;
        }
        catch (RuntimeException exception) {
            LOGGER.error("Exception of run time happened in load properties", (Throwable)exception);
            StreamUtils.closeStream(null, (InputStream)in);
        }
        catch (Exception e) {
            LOGGER.error("Exception happened in load properties", (Throwable)e);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, in);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, (InputStream)in);
        }
        StreamUtils.closeStream(null, (InputStream)in);
        return ret2333333332;
        return p;
    }

    private static String initHostKeyPath() {
        if (!StringUtils.isNULLStr((String)currCertPath)) {
            return currCertPath;
        }
        String userDir = SystemEnvUtil.getDefaultUserDir();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("userDir::::" + userDir);
        }
        if (null == userDir) {
            throw new NullPointerException("UserDir is null");
        }
        StringBuilder sbBuilder = new StringBuilder();
        StringBuilder rightSBStr = new StringBuilder(FINGERPRINT_CONFIG).append(File.separator).append(CERT_PROPERTIES);
        if (StringUtils.isNULLStr((String)System.getenv(LANGUAGE))) {
            sbBuilder.append(userDir).append(File.separator).append((CharSequence)rightSBStr);
        } else {
            int index = userDir.lastIndexOf(TOOLSFOLDER);
            if (index != -1) {
                sbBuilder.append(userDir.substring(0, index)).append((CharSequence)rightSBStr);
            } else {
                sbBuilder.append(userDir).append(File.separator).append((CharSequence)rightSBStr);
            }
        }
        return sbBuilder.toString();
    }

    public static void setCertConfirmProps(Map<String, String> currIPFPProps) {
        Properties p = CertCheckCfmUtils.getCertConfirmProp();
        for (Map.Entry<String, String> i : currIPFPProps.entrySet()) {
            p.setProperty(i.getKey(), i.getValue());
        }
        CertCheckCfmUtils.flushPropToFile(p);
    }

    public static void setCertConfirmProp(String ipStr, String fingerPrint) {
        Properties p = CertCheckCfmUtils.getCertConfirmProp();
        p.setProperty(ipStr, fingerPrint);
        CertCheckCfmUtils.flushPropToFile(p);
    }

    private static void flushPropToFile(Properties p) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(currCertPath));
            p.store(out, "");
        }
        catch (Exception e) {
            try {
                LOGGER.error("Exception happened in store properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(out, null);
                throw throwable;
            }
            StreamUtils.closeStream((OutputStream)out, null);
        }
        StreamUtils.closeStream((OutputStream)out, null);
    }
}

