/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.DevInfoQryFactory;
import com.huawei.ism.tool.devicemanager.service.IDevInfoQueryService;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.HostServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.former.XmlFormer;
import com.huawei.ism.tool.devicemanager.utils.DeviceForbidLoginUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.obase.connection.FileConnection;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.InstanceLocator;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;

public class FileHostUtils {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String SN = "sn";
    private static final String VERSION = "version";
    private static final String BASE_INFO_CMD = "self_define_cmd_basicinfo";
    private static final String COLLECT_SUCCESS_KEY = "success";
    private static final String COLLECT_POSTFIX = ".data";
    private static final String HOST_SCRIPT_NAME = "scriptforhost";
    private static final String[] ONLY_NEED_USE_HYPER_FILEHOST_STEP_IDS = new String[]{"Inspector"};
    private static final String SCENE_HOST_DEVICE_FILE = "sceneHostDeviceList.xml";
    private static final String[] SUPPORT_HOST_TYPE = new String[]{"linux", "windows", "aix", "solaris", "vmware"};
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileHostUtils.class);

    private FileHostUtils() {
    }

    public static DevNode parseFileHost(String hostIp, String dataFilePath) throws ToolException, FileNotFoundException {
        DevNode devNode = FileHostUtils.createFileDevNode(hostIp, dataFilePath);
        FileConnection con = new FileConnection(devNode);
        devNode.setDevTypeLevel2(DeviceType.valueOf((String)FileHostUtils.getHostName((ICliConnection)con, dataFilePath)));
        try {
            IDevInfoQueryService queryService = DevInfoQryFactory.findInfoQryService(EntityUtils.toOldDev((DevNode)devNode));
            if (queryService != null) {
                LOGGER.info("Begin to query node info .");
                return EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)((com.huawei.ism.tool.obase.entity.DevNode)queryService.queryNodeInfo(EntityUtils.toOldDev((DevNode)devNode), null, null).getResultObject()));
            }
            Map hostInfo = FileHostUtils.scriptParseHostBaseInfo(devNode, (ICliConnection)con);
            FileHostUtils.addDevNodeBaseInfo(devNode, hostInfo, (ICliConnection)con);
            return devNode;
        }
        catch (ToolException e) {
            LOGGER.error("parse without host failed.ip:" + hostIp, (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("parse without host failed, not found the file.ip:" + hostIp);
            throw new FileNotFoundException("can not find file.");
        }
    }

    public static void dealCollectResult(Map collectResult) {
        Map<String, String> collectFilePathMap = FileHostUtils.parseCollectFilePath(collectResult);
        List<DevNode> fileHosts = FileHostUtils.parseCollectFileToDevNode(collectFilePathMap);
        List hyperMetroHostIps = FileHostUtils.parseHyperMetroHost(collectResult);
        for (DevNode fileHost : fileHosts) {
            fileHost.setHyperMetroHost(hyperMetroHostIps.contains(fileHost.getIp()));
        }
        FileHostUtils.writeDevNodeToSceneFile(fileHosts);
    }

    private static DevNode createFileDevNode(String hostIp, String dataFilePath) {
        DevNode devNode = new DevNode();
        LOGGER.error("file host Ip: {}", (Object)hostIp);
        devNode.setIp(hostIp.replaceAll("_", ":").trim());
        devNode.setDevInfoPkgPath(dataFilePath);
        devNode.setLoginUser(new User("", ""));
        devNode.setNodeAddType(NodeAddEnum.COLLECT_FILE);
        devNode.setItDeviceType(ItDeviceType.Host);
        return devNode;
    }

    private static Map<String, String> parseCollectFilePath(Map collectResult) {
        HashMap<String, String> filePathIpMap = new HashMap<String, String>();
        Object successHostsObject = collectResult.get(COLLECT_SUCCESS_KEY);
        if (!(successHostsObject instanceof List)) {
            LOGGER.error("File host wrong success result");
            return filePathIpMap;
        }
        List successHosts = (List)successHostsObject;
        for (Object hostIpObject : successHosts) {
            Object hostDataPathsObject = collectResult.get(hostIpObject);
            if (hostDataPathsObject instanceof List) {
                List hostDataPaths = (List)hostDataPathsObject;
                for (String collectPath : hostDataPaths) {
                    filePathIpMap.put(collectPath, hostIpObject.toString().trim());
                }
                continue;
            }
            if (hostDataPathsObject instanceof String) {
                String collectPath = (String)hostDataPathsObject;
                filePathIpMap.put(collectPath, hostIpObject.toString().trim());
                continue;
            }
            LOGGER.error("Deal fileHost collect file failed, Can't find the host data paths.");
        }
        LOGGER.info("parse collect file path: {}", filePathIpMap);
        return filePathIpMap;
    }

    private static List parseHyperMetroHost(Map collectResult) {
        Object hyperMetroHostIpsObject = collectResult.get("hyper_host");
        LOGGER.info("Hyper metro hosts: {}", hyperMetroHostIpsObject);
        if (hyperMetroHostIpsObject instanceof List) {
            return (List)hyperMetroHostIpsObject;
        }
        return new ArrayList();
    }

    private static List<DevNode> parseCollectFileToDevNode(Map<String, String> collectFilePathMap) {
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        for (String collectPath : collectFilePathMap.keySet()) {
            String hostIp = collectFilePathMap.get(collectPath);
            if (!FileHostUtils.isCollectDataFile(collectPath)) continue;
            try {
                devNodes.add(FileHostUtils.parseFileHost(hostIp, collectPath));
            }
            catch (ToolException e) {
                LOGGER.error("deal collect file error", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("file not found.");
            }
        }
        LOGGER.info("parse collect file to devNode result: {}", devNodes);
        return devNodes;
    }

    public static void removeNoUseSceneFileHosts(List<DevNode> nodeList) {
        String currentSceneStepId = FileHostUtils.getCurrentSceneStepId();
        if (FileHostUtils.isOnlyNeedUseHyperFileHostScene(currentSceneStepId)) {
            nodeList.removeIf(devNode -> ItDeviceType.Host.equals((Object)devNode.getItDeviceType()) && !devNode.isHyperMetroHost());
        }
    }

    private static String getCurrentSceneStepId() {
        String sceneInfo = System.getenv("jsonScene");
        if (StringUtils.isNULLStr((String)sceneInfo)) {
            return "";
        }
        LOGGER.info("File host judge whether need use scene, sceneInfo: {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)sceneInfo));
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(sceneInfo);
        }
        catch (JSONException e) {
            LOGGER.error("File host judge whether need use scene, get step filed", (Throwable)e);
            return "";
        }
        if (!jsonObject.has("stepID")) {
            return "";
        }
        return jsonObject.getString("stepID");
    }

    private static boolean isOnlyNeedUseHyperFileHostScene(String currentSceneStepId) {
        if (StringUtils.isNULLStr((String)currentSceneStepId)) {
            return false;
        }
        for (String needUseSceneStepId : ONLY_NEED_USE_HYPER_FILEHOST_STEP_IDS) {
            if (!needUseSceneStepId.equals(currentSceneStepId)) continue;
            return true;
        }
        return false;
    }

    private static synchronized Map scriptParseHostBaseInfo(DevNode devNode, ICliConnection con) throws ToolException, FileNotFoundException {
        InstanceLocator<JythonExecuter> insLocator = JythonExecuter.getNewInstanceInAsyncWay();
        JythonExecuter executer = insLocator.getInstance();
        executer = executer == null ? new JythonExecuter() : executer;
        Map nodeInfos = new HashMap();
        String queryPath = FileHostUtils.getQueryScriptPath(devNode.getDevTypeLevel2().toString());
        File queryFile = new File(FilePathUtils.filterPath((String)queryPath));
        executer.compileScript(queryFile);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("SSH", con);
        context.put("dev", devNode);
        Object execObject = executer.simpleInvokeFunction("execute", context);
        if (!(execObject instanceof Map)) {
            throw new ToolException("exec script result type is not Map");
        }
        nodeInfos = (Map)execObject;
        return nodeInfos;
    }

    private static String getQueryScriptPath(String devType) {
        String scriptName = devType + ".py";
        CharSequence[] pathStrs = new String[]{FileUtils.getAddDevProductSuprotPkgPath(), "host", HOST_SCRIPT_NAME, "discovery", scriptName};
        return String.join((CharSequence)File.separator, pathStrs);
    }

    private static String getHostName(ICliConnection con, String filePath) throws ToolException {
        String result = con.execCmd(BASE_INFO_CMD);
        ArrayList<String> baseInfoList = new ArrayList<String>(Arrays.asList(result.split("\r\n")));
        int hostNameIndex = 1;
        if (baseInfoList.size() < hostNameIndex + 1) {
            throw new ToolException("get without host name failed. exec result:{0}", (Object[])new String[]{((Object)baseInfoList).toString()});
        }
        String name = baseInfoList.get(hostNameIndex).toString().trim().toLowerCase(Locale.ENGLISH);
        String[] temp = filePath.split("\\\\");
        if (temp.length > 1) {
            String dataFile = temp[temp.length - 1].toLowerCase(Locale.ENGLISH);
            if (dataFile.startsWith(name)) {
                return name;
            }
            for (String type : SUPPORT_HOST_TYPE) {
                if (!dataFile.startsWith(type)) continue;
                return type;
            }
        }
        return name;
    }

    private static void addDevNodeBaseInfo(DevNode devNode, Map hostInfo, ICliConnection con) throws ToolException {
        if (hostInfo.containsKey(NAME)) {
            Object nameObject = hostInfo.get(NAME);
            if (nameObject instanceof String) {
                devNode.setDeviceName((String)nameObject);
            } else {
                LOGGER.error("File Host name is not String.");
            }
        }
        if (hostInfo.containsKey(TYPE)) {
            Object typeObject = hostInfo.get(TYPE);
            if (typeObject instanceof String) {
                devNode.setDeviceType(DeviceType.valueOf((String)((String)typeObject)));
            } else {
                LOGGER.error("File Host type is not String.");
            }
        }
        if (hostInfo.containsKey(SN)) {
            Object snObject = hostInfo.get(SN);
            if (snObject instanceof String) {
                devNode.setDeviceSerialNumber((String)snObject);
            } else {
                LOGGER.error("File Host sn is not String.");
            }
        }
        if (hostInfo.containsKey(VERSION)) {
            Object versionObject = hostInfo.get(VERSION);
            if (versionObject instanceof String) {
                devNode.setProductVersion((String)versionObject);
            } else {
                LOGGER.error("File Host version is not String.");
            }
        }
        FileHostUtils.setDevNodeWwn(devNode, con);
    }

    private static void setDevNodeWwn(DevNode devNode, ICliConnection con) throws ToolException {
        HostService hostService = HostServiceFactory.createHostService(EntityUtils.toOldDev((DevNode)devNode));
        if (Objects.isNull(hostService)) {
            throw new ToolException("UnSupport without host type{0}", (Object[])new String[]{devNode.getDeviceName()});
        }
        Launcher launcher = hostService.queryWwn(con, EntityUtils.toOldDev((DevNode)devNode));
        if (Objects.isNull(launcher)) {
            throw new ToolException("query Wwn failed, result launcher is null");
        }
        List<String> fcWwns = launcher.getFcWwns();
        List<String> iscsiWwns = launcher.getiSCSIWwns();
        Object wwnErrMsg = launcher.getOtherDataMap().get("queryWwnSuccess");
        if (Objects.isNull(wwnErrMsg)) {
            throw new ToolException("query Wwn failed, result launcher can't contains errMsg:{0}", (Object[])new String[]{"queryWwnSuccess"});
        }
        if (wwnErrMsg.toString().equals("unknown")) {
            throw new ToolException("query Wwn failed, the errMsg is {0}", (Object[])new String[]{"unknown"});
        }
        List<String> ibWwns = launcher.getIBWwns();
        List<String> nvmeWwns = launcher.getNVMEWwns();
        devNode.setHostFCLauncherWwns(fcWwns);
        devNode.setHostISCSILauncherWwns(iscsiWwns);
        devNode.setHostIbLauncherWwns(ibWwns);
        devNode.setHostNvmeLauncherWwns(nvmeWwns);
    }

    public static void writeDevNodeToSceneFile(List<DevNode> devNodes) {
        FileHostUtils.joinSceneHostDevices(devNodes);
        XmlFormer xmlFormer = new XmlFormer();
        List<Map<String, String>> listMap = xmlFormer.injectDeviceData(devNodes);
        SceneXmlData.getInstance().writeDevData2File(devNodes, listMap, new File(SceneUtils.getSceneFilePath((String)SCENE_HOST_DEVICE_FILE)));
    }

    private static void joinSceneHostDevices(List<DevNode> devNodes) {
        String currentFile = SceneUtils.getSceneFilePath((String)SCENE_HOST_DEVICE_FILE);
        LOGGER.info("sceneHostDeviceList xml path is : {}", (Object)currentFile);
        if (!new File(currentFile).exists()) {
            return;
        }
        List<DevNode> devsXML = SceneXmlData.getInstance().loadSceneFromFile(SCENE_HOST_DEVICE_FILE);
        devsXML = DeviceForbidLoginUtil.filterForbidDevContainsShowErrMsg(devsXML);
        HashMap<String, List<DevNode>> snNode = new HashMap<String, List<DevNode>>();
        for (DevNode node : devNodes) {
            snNode.put(node.getDeviceSerialNumber(), devNodes);
        }
        for (DevNode xmlDev : devsXML) {
            if (snNode.containsKey(xmlDev.getDeviceSerialNumber())) continue;
            devNodes.add(xmlDev);
        }
    }

    private static boolean isCollectDataFile(String collectPath) {
        LOGGER.info("Collect file path: {}", (Object)collectPath);
        return collectPath.endsWith(COLLECT_POSTFIX);
    }
}

