/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Date;
import java.util.Locale;

public final class LogUtils {
    private static ILogSupportService opLogger = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);

    private LogUtils() {
    }

    private static OperaLog createOperaLog(String oprateName, String devIp) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperateType("operalog.type.device");
        log.setResult(true);
        log.setOperaName(oprateName);
        log.setDeviceName(devIp);
        log.setDeviceNameEn(devIp);
        return log;
    }

    private static OperaLog createOperaLog(String oprateName, String devIp, String detailInfo) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperateType("operalog.type.device");
        log.setResult(true);
        log.setOperaName(oprateName);
        log.setDeviceName(devIp);
        log.setDeviceNameEn(devIp);
        log.setDetailInfo(detailInfo);
        return log;
    }

    public static void addOperaLog(String oprateName, DevNode devNode) {
        try {
            OperaLog log = LogUtils.createOperaLog(oprateName, devNode.getIp());
            log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
            if (null == opLogger) {
                ToolLoggerFactory.getLogger(LogUtils.class).error("ServiceUtils.getServiceByIntf(ILogSupportService.class) is : null");
                return;
            }
            opLogger.addOperaLog(log);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(LogUtils.class).error("add operate log error", (Throwable)e);
        }
    }

    public static void addOperaLog(String oprateName, DevNode devNode, String detailInfo) {
        try {
            OperaLog log = LogUtils.createOperaLog(oprateName, devNode.getIp(), detailInfo);
            log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
            if (null == opLogger) {
                ToolLoggerFactory.getLogger(LogUtils.class).error("ServiceUtils.getServiceByIntf(ILogSupportService.class) is : null");
                return;
            }
            opLogger.addOperaLog(log);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(LogUtils.class).error("add operate log error", (Throwable)e);
        }
    }

    public static void addOperaLog(String oprateName, DevNode devNode, TaskResult ret) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperateType("operalog.type.device");
        log.setResult(true);
        log.setOperaName(oprateName);
        log.setDeviceName(devNode.getIp());
        log.setDeviceNameEn(devNode.getIp());
        if (!StringUtils.isNULLStr((String)ret.getErrorLocaleDescription())) {
            log.setDetailInfo(ret.getErrorLocaleDescription());
        }
        boolean result = TaskResult.Result.SUCCESS.equals((Object)ret.getResult());
        log.setResult(result);
        if (null == opLogger) {
            ToolLoggerFactory.getLogger(LogUtils.class).error("ServiceUtils.getServiceByIntf(ILogSupportService.class) is : null");
            return;
        }
        opLogger.addOperaLog(log);
    }

    public static void addOperaLog(String oprateName, DevNode devNode, TaskResult ret, String detailInfo) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperateType("operalog.type.device");
        log.setResult(true);
        log.setOperaName(oprateName);
        log.setDeviceName(devNode.getIp());
        log.setDeviceNameEn(devNode.getIp());
        log.setDetailInfo(detailInfo);
        boolean result = TaskResult.Result.SUCCESS.equals((Object)ret.getResult());
        log.setResult(result);
        if (null == opLogger) {
            ToolLoggerFactory.getLogger(LogUtils.class).error("ServiceUtils.getServiceByIntf(ILogSupportService.class) is : null");
            return;
        }
        opLogger.addOperaLog(log);
    }

    public static void addOperateLog(String operateType, String operateName, boolean isSuccess) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperateDate(new Date());
        log.setOperaName(operateName);
        log.setOperateType(operateType);
        log.setResult(isSuccess);
        log.setDeviceName("Smartkit");
        log.setDeviceNameEn("Smartkit");
        if (opLogger == null) {
            ToolLoggerFactory.getLogger(LogUtils.class).error("ServiceUtils.getServiceByIntf(ILogSupportService.class) is : null");
            return;
        }
        opLogger.addOperaLog(log);
    }

    public static void addOperaLog(boolean succ) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperateType("operalog.type.device");
        log.setResult(succ);
        log.setOperaName("operalog.name.adddevices");
        log.setDeviceName("Smartkit");
        log.setDeviceNameEn("Smartkit");
        if (null == opLogger) {
            ToolLoggerFactory.getLogger(LogUtils.class).error("ServiceUtils.getServiceByIntf(ILogSupportService.class) is : null");
            return;
        }
        opLogger.addOperaLog(log);
    }

    public static OperaLog addOperaLogForProxy(String name, String deviceName, boolean success, boolean isSSH) {
        String beauNameZH = LogUtils.getResourceName(isSSH, Locale.CHINESE);
        String beauNameEN = LogUtils.getResourceName(isSSH, Locale.ENGLISH);
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setOperaName(name);
        log.setDeviceName(beauNameZH + deviceName);
        log.setDeviceNameEn(beauNameEN + deviceName);
        log.setOperateType("operalog.type.system");
        log.setResult(success);
        return log;
    }

    public static void addSettingLog(String name, String deviceName, boolean success, boolean isSSH) {
        String beauNameZH = LogUtils.getResourceName(isSSH, Locale.CHINESE);
        String beauNameEN = LogUtils.getResourceName(isSSH, Locale.ENGLISH);
        OperaLog log = new OperaLog();
        log.setOperaName(name);
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName(beauNameZH + deviceName);
        log.setDeviceNameEn(beauNameEN + deviceName);
        log.setOperateType("operalog.type.system");
        log.setResult(success);
        ILogSupportService logService = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }

    private static String getResourceName(boolean isSSH, Locale loc) {
        String beauName = "";
        beauName = isSSH ? ResourceUtil.getString((String)"toolbox.ssh.beau.name", (Locale)loc) : ResourceUtil.getString((String)"toolbox.socks5.beau.name", (Locale)loc);
        return beauName;
    }

    public static void addImportLog(String name, String deviceName, boolean success) {
        OperaLog log = new OperaLog();
        log.setOperaName(name);
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName(deviceName);
        log.setDeviceNameEn(deviceName);
        log.setOperateType("operalog.type.system");
        log.setResult(success);
        ILogSupportService logService = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }
}

