/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.cert.service;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.channel.cert.service.HttpsCertPwdHelper;
import com.huawei.ism.tool.channel.cert.utils.SSLCertUtils;
import com.huawei.ism.tool.channel.utils.CertPwdInfoKeeper;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsCertManager {
    public static final String NOT_FOUND = "notFound";
    public static final String CERTIFICATE_EXPIRED = "CertificateExpired";
    public static final String CERTIFICATE_NOT_YET_VALID = "CertificateNotYetValid";
    public static final String CERT_OK = "ok";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsCertManager.class);
    private static final HttpsCertManager INSTANCE = new HttpsCertManager();
    private static final String CERT_SAVE_PATH = "cert";
    private static final String CLIENT_CERT_NAME = "client.p12";
    private static final String USERINFO_FILE = "roleInfo";
    private static final String CLIENT_USERINFO_TMP_NAME_CARRIER = "roleInfo.carrier.tmp";
    private static final String CLIENT_USERINFO_TMP_NAME_ENTERPRISE = "roleInfo.enterprise.tmp";
    private static final String CARRIER = "Carrier";
    private static final String PUBKEY_PATH = "config/https/pubkey/";
    private SSLSocketFactory sslSocketFactory;
    private SSLSocketFactory sslServerSocketFactory;
    private SSLSocketFactory sslYellowServerSocketFactory;
    private X509Certificate clientX509Cert;
    private String certDesc;
    private boolean existDataCert = true;
    private Map<Locale, String> errorMsgMap = new HashMap<Locale, String>();

    public static HttpsCertManager getInstance() {
        return INSTANCE;
    }

    public String getClientCertPath() {
        String cerPath = this.getDataCertFolderPath() + CLIENT_CERT_NAME;
        String defaultCerPath = ApplicationContext.getInstance().getDefaultCerPath();
        File file = new File(defaultCerPath + CLIENT_CERT_NAME);
        File cerFile = new File(cerPath);
        if (file.exists() && !cerFile.exists()) {
            return defaultCerPath + CLIENT_CERT_NAME;
        }
        return cerPath;
    }

    public String getDefaultClientCertPath() {
        return this.getDefaultCertFolderPath() + CLIENT_CERT_NAME;
    }

    private String getDefaultCertFolderPath() {
        StringBuffer sb = new StringBuffer();
        String configPath = ApplicationContext.getInstance().getPluginsCfgPath();
        String workPath = null;
        try {
            File tempFile = new File(ApplicationContext.getInstance().getCurrWorkPath());
            if (tempFile.exists()) {
                workPath = tempFile.getCanonicalPath();
            }
        }
        catch (IOException e) {
            LOGGER.error("The file is not exist.");
        }
        if (null == workPath) {
            workPath = "";
        }
        String filePath = workPath;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("dft cert folderPath workPath:" + workPath);
        }
        sb.append(filePath).append(File.separator);
        sb.append(configPath);
        sb.append(File.separatorChar);
        return sb.toString();
    }

    public char[] getClientCertPwd() {
        return new HttpsCertPwdHelper().getCertPwd().toCharArray();
    }

    public String getClientCertPwdPath() {
        return CertPwdInfoKeeper.getInstance().getClientInterInfoFilePath();
    }

    public String getTmpInterInfoFilePath() {
        return CertPwdInfoKeeper.getInstance().getTmpInterInfoFilePath();
    }

    public char[] getDefaultClientCertPwd() {
        return "".toCharArray();
    }

    public void updateCert() {
        this.sslSocketFactory = SSLCertUtils.getSSLFactory();
        this.clientX509Cert = SSLCertUtils.getClientX509Cert();
    }

    public void updateCert(String clientCertPath) {
        this.sslSocketFactory = SSLCertUtils.getSSLFactory();
        this.clientX509Cert = SSLCertUtils.getClientX509Cert(clientCertPath);
    }

    public SSLSocketFactory getSslSocketFactory() {
        File file = new File(this.getClientCertPath());
        if (null == this.sslSocketFactory || file.exists() && file.length() > 0L && this.existDataCert) {
            this.updateCert();
            this.existDataCert = false;
        }
        return this.sslSocketFactory;
    }

    public SSLSocketFactory getSslServerSocketFactory() {
        if (null == this.sslServerSocketFactory) {
            this.sslServerSocketFactory = SSLCertUtils.getServerSSLFactory();
        }
        return this.sslServerSocketFactory;
    }

    public SSLSocketFactory getSslYellowServerSocketFactory() {
        if (null == this.sslYellowServerSocketFactory) {
            this.sslYellowServerSocketFactory = SSLCertUtils.getYellowServerSSLFactory();
        }
        return this.sslYellowServerSocketFactory;
    }

    public void setClientX509Cert(X509Certificate clientX509Cert) {
        this.clientX509Cert = clientX509Cert;
    }

    public synchronized boolean saveUserInfo(String userInfoParm, String role) {
        LOGGER.info("start to saveCertFile...");
        boolean isSuccess = this.initUserInfoFolder(role);
        if (!isSuccess) {
            LOGGER.error("initCertFolder failed.");
            return false;
        }
        isSuccess = this.writeUserTmpFile(userInfoParm, role);
        if (!isSuccess) {
            LOGGER.error("writeCertFile failed.");
            return false;
        }
        return true;
    }

    public boolean replaceAndUpdateCert() {
        boolean isSuccess = this.replaceCertFile();
        if (!isSuccess) {
            LOGGER.error("replaceCertFile failed.");
            return false;
        }
        this.updateCert();
        boolean reNameCertPwd = new HttpsCertPwdHelper().reNameCertPwd();
        if (!reNameCertPwd) {
            LOGGER.error("replaceCertPwdfile failed.");
            return false;
        }
        return true;
    }

    public String getClientCertDescInfo() {
        return this.getClientCertDescInfo(null);
    }

    public String getClientCertDescInfo(String clientCertPath) {
        return this.getUserInfo();
    }

    public boolean isValidCert() {
        String cerDesc;
        if (null == this.clientX509Cert) {
            this.updateCert();
        }
        if (StringUtils.isNULLStr(cerDesc = this.getClientCertDescInfo())) {
            return false;
        }
        String certId = "";
        return cerDesc.contains(certId);
    }

    public String checkValid(String path) {
        LOGGER.info("check cert valid");
        X509Certificate x509Cert = SSLCertUtils.getClientX509Cert(path);
        if (null == x509Cert) {
            LOGGER.info("client x509 cert is null");
            return NOT_FOUND;
        }
        try {
            x509Cert.checkValidity(new Date());
        }
        catch (CertificateExpiredException e) {
            LOGGER.error("The certificate is expired");
            return CERTIFICATE_EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            LOGGER.error("The certificate is not valid");
            return CERT_OK;
        }
        return CERT_OK;
    }

    public String getDataCertFolderPath() {
        StringBuffer sb = new StringBuffer();
        String userDataPath = ApplicationContext.getInstance().getUserDataPath();
        String filePath = ApplicationContext.getInstance().getCurrWorkPath();
        sb.append(filePath);
        sb.append(userDataPath);
        sb.append(File.separatorChar);
        sb.append(CERT_SAVE_PATH);
        sb.append(File.separatorChar);
        return sb.toString();
    }

    private boolean initUserInfoFolder(String role) {
        try {
            boolean isSuccess;
            String path = this.getDataCertFolderPath();
            File pubFoler = new File(path);
            if (!pubFoler.exists() && !pubFoler.mkdir()) {
                return false;
            }
            File pubFile = new File(this.getUserTempPathByRole(role));
            if (pubFile.exists() && !(isSuccess = pubFile.delete())) {
                return false;
            }
            return pubFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean writeUserTmpFile(String roleInfo, String role) {
        String tmpFilePath = this.getUserTempPathByRole(role);
        return this.saveCertDescJson2File(tmpFilePath, roleInfo);
    }

    private String getUserTempPathByRole(String Role) {
        if (CARRIER.equalsIgnoreCase(Role)) {
            return this.getDataCertFolderPath() + CLIENT_USERINFO_TMP_NAME_CARRIER;
        }
        return this.getDataCertFolderPath() + CLIENT_USERINFO_TMP_NAME_ENTERPRISE;
    }

    private boolean replaceCertFile() {
        boolean isSuccess;
        String path = this.getDataCertFolderPath();
        File certFile = new File(path + USERINFO_FILE);
        File certTmpFile = new File(this.getUserTempPathByRole(ApplicationContext.getInstance().getUserRole()));
        if (!certTmpFile.exists()) {
            return false;
        }
        if (certFile.exists() && !(isSuccess = certFile.delete())) {
            return false;
        }
        return certTmpFile.renameTo(certFile);
    }

    public String getCertDesc() {
        return this.certDesc;
    }

    public void setCertDesc(String certDesc) {
        this.certDesc = certDesc;
    }

    public Map<Locale, String> getErrorMsgMap() {
        return this.errorMsgMap;
    }

    public static String getUserInfoJsonFilePath() {
        String path = HttpsCertManager.getInstance().getDataCertFolderPath() + USERINFO_FILE;
        File file = new File(path);
        if (file.exists()) {
            return path;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCertDescJson2File(String path, String info) {
        FileOutputStream out = null;
        BufferedOutputStream buffOut = null;
        File certDescFile = new File(path);
        try {
            if (certDescFile.exists()) {
                out = new FileOutputStream(certDescFile);
                buffOut = new BufferedOutputStream(out);
                buffOut.write(AESEncrypt.encrypt((String)info).getBytes(StandardCharsets.UTF_8));
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
        }
        catch (IOException e) {
            LOGGER.error("io exception");
        }
        finally {
            StreamUtils.closeStream(buffOut, null);
            StreamUtils.closeStream((OutputStream)out, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInfo() {
        StringBuilder roleInfo = new StringBuilder();
        File file = new File(HttpsCertManager.getUserInfoJsonFilePath());
        FileInputStream in = null;
        byte[] tempBytes = new byte[128];
        int readByte = 0;
        try {
            in = new FileInputStream(file);
            while (-1 != (readByte = ((InputStream)in).read(tempBytes))) {
                roleInfo.append(new String(tempBytes, 0, readByte, Charset.forName("UTF-8")));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("roleInfo file not found.");
        }
        catch (IOException e) {
            LOGGER.error("roleInfo io error.");
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)in);
        }
        if (StringUtils.isNULLStr(roleInfo.toString())) {
            return "";
        }
        String tempRoleInfo = AESEncrypt.decrypt((String)roleInfo.toString());
        if (StringUtils.isNULLStr(tempRoleInfo)) {
            LOGGER.info("the roleinfo from file is empty.");
            return "";
        }
        JSONObject roleInfoObj = null;
        try {
            roleInfoObj = new JSONObject(tempRoleInfo);
        }
        catch (JSONException e) {
            LOGGER.info("init roleInfo json error.");
            return "";
        }
        String role = roleInfoObj.getStringOrDefault("role", "");
        String userId = roleInfoObj.getStringOrDefault("userId", "");
        if (StringUtils.isNULLStr(role) || StringUtils.isNULLStr(userId)) {
            LOGGER.info("account or right info get failed.");
            return "";
        }
        roleInfoObj.put("role", (Object)role);
        roleInfoObj.put("userId", (Object)userId);
        return roleInfoObj.toString();
    }

    public boolean useredDefaultCer() {
        String clientCertPath = this.getClientCertPath();
        return clientCertPath.equals(ApplicationContext.getInstance().getDefaultCerPath() + CLIENT_CERT_NAME);
    }
}

